'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

var _gitShellOutStrategy = require('../git-shell-out-strategy');

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let BranchMenuView = (_class = (_temp = _class2 = class BranchMenuView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      createNew: false,
      checkingOutBranch: null
    };
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.repository !== nextProps.repository) {
      this.setState({ checkingOutBranch: null });
    }
  }

  render() {
    const currentBranchName = this.state.checkingOutBranch || this.props.currentBranch.getName();
    const branchNames = this.props.branches.map(branch => branch.getName());
    if (this.state.checkingOutBranch && branchNames.indexOf(this.state.checkingOutBranch) === -1) {
      branchNames.push(this.state.checkingOutBranch);
    }

    const newBranchEditor = _react2.default.createElement(
      'div',
      { className: 'github-BranchMenuView-item github-BranchMenuView-editor' },
      _react2.default.createElement('atom-text-editor', {
        ref: e => {
          this.editorElement = e;
        },
        mini: true,
        softWrapped: true,
        placeholderText: 'enter new branch name',
        lineNumberGutterVisible: false,
        showInvisibles: false,
        scrollPastEnd: false
      })
    );

    const selectBranchView = _react2.default.createElement(
      'select',
      {
        className: 'github-BranchMenuView-item github-BranchMenuView-select input-select',
        onChange: this.didSelectItem,
        value: currentBranchName },
      this.props.currentBranch.isDetached() && _react2.default.createElement(
        'option',
        { key: 'detached', value: 'detached', disabled: true },
        this.props.currentBranch.getName()
      ),
      branchNames.map(branchName => {
        return _react2.default.createElement(
          'option',
          { key: branchName, value: branchName },
          branchName
        );
      })
    );

    return _react2.default.createElement(
      'div',
      { className: 'github-BranchMenuView' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-BranchMenuView-editor atom-text-editor[mini]' },
        _react2.default.createElement(_commands.Command, { command: 'tool-panel:unfocus', callback: this.cancelCreateNewBranch }),
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancelCreateNewBranch }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.createBranch })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-BranchMenuView-selector' },
        _react2.default.createElement('span', { className: 'github-BranchMenuView-item icon icon-git-branch' }),
        this.state.createNew ? newBranchEditor : selectBranchView,
        _react2.default.createElement(
          'button',
          { className: 'github-BranchMenuView-item github-BranchMenuView-button btn',
            onClick: this.createBranch },
          ' New Branch '
        )
      )
    );
  }

  didSelectItem(event) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const branchName = event.target.value;
      _this.setState({ checkingOutBranch: branchName });

      try {
        yield _this.props.checkout(branchName);
      } catch (e) {
        _this.setState({ checkingOutBranch: null });
        if (!(e instanceof _gitShellOutStrategy.GitError)) {
          throw e;
        }
        if (e.stdErr.match(/local changes.*would be overwritten/)) {
          const files = e.stdErr.split(/\r?\n/).filter(function (l) {
            return l.startsWith('\t');
          }).map(function (l) {
            return `\`${l.trim()}\``;
          }).join('<br>');
          _this.props.notificationManager.addError('Checkout aborted', {
            description: 'Local changes to the following would be overwritten:<br>' + files + '<br>Please commit your changes or stash them.',
            dismissable: true
          });
        } else {
          _this.props.notificationManager.addError('Checkout aborted', { description: e.stdErr, dismissable: true });
        }
      }
      return null;
    })();
  }

  createBranch() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2.state.createNew) {
        const branchName = _this2.editorElement.getModel().getText().trim();
        try {
          yield _this2.props.checkout(branchName, { createNew: true });
          _this2.setState({ createNew: false, checkingOutBranch: branchName });
        } catch (e) {
          if (!(e instanceof _gitShellOutStrategy.GitError)) {
            throw e;
          }
          if (e.stdErr.match(/branch.*already exists/)) {
            _this2.props.notificationManager.addError('Cannot create branch', {
              description: `\`${branchName}\` already exists. Choose another branch name.`
            });
          } else if (e.stdErr.match(/error: you need to resolve your current index first/)) {
            _this2.props.notificationManager.addError('Cannot create branch', {
              description: 'You must first resolve merge conflicts.',
              dismissable: true
            });
          } else {
            _this2.props.notificationManager.addError('Cannot create branch', { description: e.stdErr, dismissable: true });
          }
          _this2.setState({ createNew: false });
        }
      } else {
        _this2.setState({ createNew: true }, function () {
          return _this2.editorElement.focus();
        });
      }
    })();
  }

  cancelCreateNewBranch() {
    this.setState({ createNew: false });
  }
}, _class2.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object,
  branches: _propTypes2.default.arrayOf(_propTypes3.BranchPropType).isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  checkout: _propTypes2.default.func
}, _class2.defaultProps = {
  checkout: () => Promise.resolve()
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'didSelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didSelectItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createBranch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createBranch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelCreateNewBranch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelCreateNewBranch'), _class.prototype)), _class);
exports.default = BranchMenuView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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