'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const relayEnvironmentPerGithubHost = new Map();

let RelayNetworkLayerManager = class RelayNetworkLayerManager {
  static getEnvironmentForHost(host, token) {
    host = host === 'github.com' ? 'https://api.github.com' : host; // eslint-disable-line no-param-reassign
    const url = host === 'https://api.github.com' ? `${host}/graphql` : `${host}/api/v3/graphql`;
    const config = relayEnvironmentPerGithubHost.get(host) || {};
    let environment = config.environment,
        networkLayer = config.networkLayer;

    if (!environment) {
      environment = new _reactRelay2.default.Environment();
      networkLayer = new _reactRelay2.default.DefaultNetworkLayer(url, {
        headers: {
          Authorization: `bearer ${token}`,
          Accept: 'application/vnd.github.graphql-profiling+json'
        }
      });
      environment.injectNetworkLayer(networkLayer);
      relayEnvironmentPerGithubHost.set(host, { environment, networkLayer });
    } else {
      networkLayer._init.headers = {
        Authorization: `bearer ${token}`
      };
    }
    return environment;
  }
};
exports.default = RelayNetworkLayerManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbGF5LW5ldHdvcmstbGF5ZXItbWFuYWdlci5qcyJdLCJuYW1lcyI6WyJyZWxheUVudmlyb25tZW50UGVyR2l0aHViSG9zdCIsIk1hcCIsIlJlbGF5TmV0d29ya0xheWVyTWFuYWdlciIsImdldEVudmlyb25tZW50Rm9ySG9zdCIsImhvc3QiLCJ0b2tlbiIsInVybCIsImNvbmZpZyIsImdldCIsImVudmlyb25tZW50IiwibmV0d29ya0xheWVyIiwiRW52aXJvbm1lbnQiLCJEZWZhdWx0TmV0d29ya0xheWVyIiwiaGVhZGVycyIsIkF1dGhvcml6YXRpb24iLCJBY2NlcHQiLCJpbmplY3ROZXR3b3JrTGF5ZXIiLCJzZXQiLCJfaW5pdCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7Ozs7QUFFQSxNQUFNQSxnQ0FBZ0MsSUFBSUMsR0FBSixFQUF0Qzs7SUFFcUJDLHdCLEdBQU4sTUFBTUEsd0JBQU4sQ0FBK0I7QUFDNUMsU0FBT0MscUJBQVAsQ0FBNkJDLElBQTdCLEVBQW1DQyxLQUFuQyxFQUEwQztBQUN4Q0QsV0FBT0EsU0FBUyxZQUFULEdBQXdCLHdCQUF4QixHQUFtREEsSUFBMUQsQ0FEd0MsQ0FDd0I7QUFDaEUsVUFBTUUsTUFBTUYsU0FBUyx3QkFBVCxHQUFxQyxHQUFFQSxJQUFLLFVBQTVDLEdBQXlELEdBQUVBLElBQUssaUJBQTVFO0FBQ0EsVUFBTUcsU0FBU1AsOEJBQThCUSxHQUE5QixDQUFrQ0osSUFBbEMsS0FBMkMsRUFBMUQ7QUFId0MsUUFJbkNLLFdBSm1DLEdBSU5GLE1BSk0sQ0FJbkNFLFdBSm1DO0FBQUEsUUFJdEJDLFlBSnNCLEdBSU5ILE1BSk0sQ0FJdEJHLFlBSnNCOztBQUt4QyxRQUFJLENBQUNELFdBQUwsRUFBa0I7QUFDaEJBLG9CQUFjLElBQUkscUJBQU1FLFdBQVYsRUFBZDtBQUNBRCxxQkFBZSxJQUFJLHFCQUFNRSxtQkFBVixDQUE4Qk4sR0FBOUIsRUFBbUM7QUFDaERPLGlCQUFTO0FBQ1BDLHlCQUFnQixVQUFTVCxLQUFNLEVBRHhCO0FBRVBVLGtCQUFRO0FBRkQ7QUFEdUMsT0FBbkMsQ0FBZjtBQU1BTixrQkFBWU8sa0JBQVosQ0FBK0JOLFlBQS9CO0FBQ0FWLG9DQUE4QmlCLEdBQTlCLENBQWtDYixJQUFsQyxFQUF3QyxFQUFDSyxXQUFELEVBQWNDLFlBQWQsRUFBeEM7QUFDRCxLQVZELE1BVU87QUFDTEEsbUJBQWFRLEtBQWIsQ0FBbUJMLE9BQW5CLEdBQTZCO0FBQzNCQyx1QkFBZ0IsVUFBU1QsS0FBTTtBQURKLE9BQTdCO0FBR0Q7QUFDRCxXQUFPSSxXQUFQO0FBQ0Q7QUF0QjJDLEM7a0JBQXpCUCx3QiIsImZpbGUiOiJyZWxheS1uZXR3b3JrLWxheWVyLW1hbmFnZXIuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWxheSBmcm9tICdyZWFjdC1yZWxheSc7XG5cbmNvbnN0IHJlbGF5RW52aXJvbm1lbnRQZXJHaXRodWJIb3N0ID0gbmV3IE1hcCgpO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIge1xuICBzdGF0aWMgZ2V0RW52aXJvbm1lbnRGb3JIb3N0KGhvc3QsIHRva2VuKSB7XG4gICAgaG9zdCA9IGhvc3QgPT09ICdnaXRodWIuY29tJyA/ICdodHRwczovL2FwaS5naXRodWIuY29tJyA6IGhvc3Q7IC8vIGVzbGludC1kaXNhYmxlLWxpbmUgbm8tcGFyYW0tcmVhc3NpZ25cbiAgICBjb25zdCB1cmwgPSBob3N0ID09PSAnaHR0cHM6Ly9hcGkuZ2l0aHViLmNvbScgPyBgJHtob3N0fS9ncmFwaHFsYCA6IGAke2hvc3R9L2FwaS92My9ncmFwaHFsYDtcbiAgICBjb25zdCBjb25maWcgPSByZWxheUVudmlyb25tZW50UGVyR2l0aHViSG9zdC5nZXQoaG9zdCkgfHwge307XG4gICAgbGV0IHtlbnZpcm9ubWVudCwgbmV0d29ya0xheWVyfSA9IGNvbmZpZztcbiAgICBpZiAoIWVudmlyb25tZW50KSB7XG4gICAgICBlbnZpcm9ubWVudCA9IG5ldyBSZWxheS5FbnZpcm9ubWVudCgpO1xuICAgICAgbmV0d29ya0xheWVyID0gbmV3IFJlbGF5LkRlZmF1bHROZXR3b3JrTGF5ZXIodXJsLCB7XG4gICAgICAgIGhlYWRlcnM6IHtcbiAgICAgICAgICBBdXRob3JpemF0aW9uOiBgYmVhcmVyICR7dG9rZW59YCxcbiAgICAgICAgICBBY2NlcHQ6ICdhcHBsaWNhdGlvbi92bmQuZ2l0aHViLmdyYXBocWwtcHJvZmlsaW5nK2pzb24nLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgICBlbnZpcm9ubWVudC5pbmplY3ROZXR3b3JrTGF5ZXIobmV0d29ya0xheWVyKTtcbiAgICAgIHJlbGF5RW52aXJvbm1lbnRQZXJHaXRodWJIb3N0LnNldChob3N0LCB7ZW52aXJvbm1lbnQsIG5ldHdvcmtMYXllcn0pO1xuICAgIH0gZWxzZSB7XG4gICAgICBuZXR3b3JrTGF5ZXIuX2luaXQuaGVhZGVycyA9IHtcbiAgICAgICAgQXV0aG9yaXphdGlvbjogYGJlYXJlciAke3Rva2VufWAsXG4gICAgICB9O1xuICAgIH1cbiAgICByZXR1cm4gZW52aXJvbm1lbnQ7XG4gIH1cbn1cbiJdfQ==