'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _compareSets2 = require('compare-sets');

var _compareSets3 = _interopRequireDefault(_compareSets2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let MultiList = class MultiList {
  constructor(lists, didChangeActiveItem) {
    this.listInfoByKey = new Map();
    this.listOrderByKey = lists.map(list => {
      this.listInfoByKey.set(list.key, {
        items: list.items,
        activeItem: list.items[0],
        activeIndex: 0
      });
      return list.key;
    });
    this.didChangeActiveItem = didChangeActiveItem;
    this.activateListForKey(lists[0].key, { suppressCallback: true });
  }

  getListKeys() {
    return this.listOrderByKey;
  }

  getActiveListKey() {
    return this.activeListKey;
  }

  getItemsForKey(key) {
    return this.listInfoByKey.get(key).items;
  }

  getItemsInActiveList() {
    return this.getItemsForKey(this.getActiveListKey());
  }

  getItemIndexForKey(key, item) {
    const items = this.getItemsForKey(key);
    return items.indexOf(item);
  }

  getActiveItemForKey(key) {
    if (key === undefined) {
      throw new RangeError();
    }
    return this.listInfoByKey.get(key).activeItem;
  }

  getActiveItem() {
    return this.listInfoByKey.get(this.getActiveListKey()).activeItem;
  }

  activateListForKey(key) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref.suppressCallback;

    this.activeListKey = key;

    if (this.didChangeActiveItem && !suppressCallback) {
      this.didChangeActiveItem(this.getActiveItem(), this.getActiveListKey());
    }
  }

  activateItemAtIndexForKey(key, index) {
    var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    let suppressCallback = _ref2.suppressCallback;

    this.activateListForKey(key, { suppressCallback: true });
    const listInfo = this.listInfoByKey.get(key);
    listInfo.activeIndex = index;
    listInfo.activeItem = listInfo.items[index];

    if (this.didChangeActiveItem && !suppressCallback) {
      this.didChangeActiveItem(this.getActiveItem(), this.getActiveListKey());
    }
  }

  activateItem(activeItem) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref3.suppressCallback;

    for (const _ref4 of this.listInfoByKey) {
      var _ref5 = _slicedToArray(_ref4, 2);

      const key = _ref5[0];
      const listInfo = _ref5[1];

      for (let index = 0; index < listInfo.items.length; index++) {
        const item = listInfo.items[index];
        if (activeItem === item) {
          return this.activateItemAtIndexForKey(key, index, { suppressCallback });
        }
      }
    }
    return null;
  }

  activateNextList() {
    var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref6.wrap,
        activateFirst = _ref6.activateFirst,
        suppressCallback = _ref6.suppressCallback;

    const listCount = this.listOrderByKey.length;
    let index = this.listOrderByKey.indexOf(this.getActiveListKey()) + 1;
    if (wrap && index >= listCount) {
      index = 0;
    }
    let listsLeft = listCount - 1;
    while (index < listCount && listsLeft && this.getItemsForKey(this.listOrderByKey[index]).length === 0) {
      index++;
      if (wrap && index >= listCount) {
        index = 0;
      }
      listsLeft--;
    }
    if (index < listCount) {
      const key = this.listOrderByKey[index];
      activateFirst ? this.activateItemAtIndexForKey(key, 0, { suppressCallback }) : this.activateListForKey(key, { suppressCallback });
    }
  }

  activatePreviousList() {
    var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref7.wrap,
        activateLast = _ref7.activateLast,
        suppressCallback = _ref7.suppressCallback;

    const listCount = this.listOrderByKey.length;
    let index = this.listOrderByKey.indexOf(this.getActiveListKey()) - 1;
    if (wrap && index < 0) {
      index = listCount - 1;
    }
    let listsLeft = index;
    while (index >= 0 && listsLeft && this.getItemsForKey(this.listOrderByKey[index]).length === 0) {
      index--;
      if (wrap && index < 0) {
        index = listCount - 1;
      }
      listsLeft--;
    }
    if (index >= 0) {
      const key = this.listOrderByKey[index];
      if (activateLast) {
        const lastItemIndex = this.getItemsForKey(this.listOrderByKey[index]).length - 1;
        this.activateItemAtIndexForKey(key, lastItemIndex, { suppressCallback });
      } else {
        this.activateListForKey(key, { suppressCallback });
      }
    }
  }

  activateNextItem() {
    var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref8.wrap,
        stopAtBounds = _ref8.stopAtBounds;

    const key = this.getActiveListKey();
    const listInfo = this.listInfoByKey.get(key);
    const newItemIndex = listInfo.activeIndex + 1;
    if (newItemIndex < listInfo.items.length) {
      this.activateItemAtIndexForKey(key, newItemIndex);
    } else {
      if (!stopAtBounds) {
        this.activateNextList({ activateFirst: true, wrap });
      }
    }
  }

  activatePreviousItem() {
    var _ref9 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref9.wrap,
        stopAtBounds = _ref9.stopAtBounds;

    const key = this.getActiveListKey();
    const listInfo = this.listInfoByKey.get(key);
    const newItemIndex = listInfo.activeIndex - 1;
    if (newItemIndex >= 0) {
      this.activateItemAtIndexForKey(key, newItemIndex);
    } else {
      if (!stopAtBounds) {
        this.activatePreviousList({ activateLast: true, wrap });
      }
    }
  }

  getItemsAndKeysInRange(endPoint1, endPoint2) {
    // TODO: optimize
    const index1 = this.listOrderByKey.indexOf(endPoint1.key);
    const index2 = this.listOrderByKey.indexOf(endPoint2.key);

    if (index1 < 0) {
      throw new Error(`key "${endPoint1.key}" not found`);
    }
    if (index2 < 0) {
      throw new Error(`key "${endPoint2.key}" not found`);
    }
    let startPoint, endPoint, startKeyIndex, endKeyIndex;
    if (index1 < index2) {
      startPoint = endPoint1;
      endPoint = endPoint2;
      startKeyIndex = index1;
      endKeyIndex = index2;
    } else {
      startPoint = endPoint2;
      endPoint = endPoint1;
      startKeyIndex = index2;
      endKeyIndex = index1;
    }
    const startItemIndex = this.getItemIndexForKey(startPoint.key, startPoint.item);
    const endItemIndex = this.getItemIndexForKey(endPoint.key, endPoint.item);
    if (startItemIndex < 0) {
      throw new Error(`item "${startPoint.item}" not found`);
    }
    if (endItemIndex < 0) {
      throw new Error(`item "${endPoint.item}" not found`);
    }

    if (startKeyIndex === endKeyIndex) {
      const items = this.getItemsForKey(this.listOrderByKey[startKeyIndex]);
      const indexes = [startItemIndex, endItemIndex].sort();
      return {
        items: items.slice(indexes[0], indexes[1] + 1),
        keys: [startPoint.key]
      };
    }

    let itemsInRange;
    for (let i = startKeyIndex; i <= endKeyIndex; i++) {
      const items = this.getItemsForKey(this.listOrderByKey[i]);
      if (i === startKeyIndex) {
        itemsInRange = items.slice(startItemIndex);
      } else if (i === endKeyIndex) {
        itemsInRange = itemsInRange.concat(items.slice(0, endItemIndex + 1));
      } else {
        itemsInRange = itemsInRange.concat(items);
      }
    }
    return {
      items: itemsInRange,
      keys: this.listOrderByKey.slice(startKeyIndex, endKeyIndex + 1)
    };
  }

  updateLists(newLists) {
    var _ref10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref10.suppressCallback,
        oldActiveListIndex = _ref10.oldActiveListIndex,
        oldActiveListItemIndex = _ref10.oldActiveListItemIndex;

    const oldActiveItem = this.getActiveItem();
    const oldActiveListKey = this.getActiveListKey();
    // eslint-disable-next-line no-param-reassign
    oldActiveListIndex = oldActiveListIndex || this.listOrderByKey.indexOf(oldActiveListKey);

    const newListInfo = this.getNewListInfoAndOrder(newLists, { oldActiveListIndex, oldActiveListItemIndex });
    const newListOrderByKey = newListInfo.newListOrderByKey,
          newListInfoByKey = newListInfo.newListInfoByKey,
          selectNext = newListInfo.selectNext;

    this.listInfoByKey = newListInfoByKey;
    this.listOrderByKey = newListOrderByKey;

    if (!newListOrderByKey.includes(oldActiveListKey)) {
      this.activateItemBasedOnIndex(oldActiveListIndex);
    }

    if (this.getItemsInActiveList().length === 0 || selectNext) {
      this.activateNextList({ suppressCallback: true, activateFirst: true });
      if (this.getItemsInActiveList().length === 0) {
        this.activatePreviousList({ suppressCallback: true, activateLast: true });
      }
    }

    if (this.getActiveItem() !== oldActiveItem && this.didChangeActiveItem && !suppressCallback) {
      this.didChangeActiveItem(this.getActiveItem(), this.getActiveListKey());
    }
  }

  getNewListInfoAndOrder(newLists, _ref11) {
    let oldActiveListIndex = _ref11.oldActiveListIndex,
        oldActiveListItemIndex = _ref11.oldActiveListItemIndex;

    var _compareSets = (0, _compareSets3.default)(new Set(this.listOrderByKey), new Set(newLists.map(list => list.key)));

    const retained = _compareSets.retained;

    if (retained.size > 0) {
      return this.getInfoBasedOnOldActiveItem(newLists);
    } else {
      return this.getInfoBasedOnOldActiveIndex(newLists, { oldActiveListIndex, oldActiveListItemIndex });
    }
  }

  getInfoBasedOnOldActiveIndex(newLists, _ref12) {
    let oldActiveListIndex = _ref12.oldActiveListIndex,
        oldActiveListItemIndex = _ref12.oldActiveListItemIndex;

    let selectNext;
    const newListInfoByKey = new Map();
    const newListOrderByKey = newLists.map((list, listIndex) => {
      const newListItems = list.items;
      let newInfo;
      if (oldActiveListItemIndex !== undefined && listIndex === oldActiveListIndex) {
        const items = list.items;
        const item = items[oldActiveListItemIndex];
        if (item !== undefined) {
          newInfo = {
            activeItem: item,
            activeIndex: oldActiveListItemIndex
          };
        } else {
          selectNext = true;
          newInfo = {
            activeItem: items[items.length - 1],
            activeIndex: Math.max(items.length - 1, 0)
          };
        }
      } else {
        newInfo = {
          activeItem: newListItems[0],
          activeIndex: 0
        };
      }
      newInfo.items = newListItems;
      newListInfoByKey.set(list.key, newInfo);
      return list.key;
    });

    return { newListOrderByKey, newListInfoByKey, selectNext };
  }

  getInfoBasedOnOldActiveItem(newLists) {
    const newListInfoByKey = new Map();
    const newListOrderByKey = newLists.map(list => {
      const oldInfo = this.listInfoByKey.get(list.key);
      const key = list.key;
      const newListItems = list.items;
      let newInfo;
      if (oldInfo && newListItems.length > 0) {
        const activeItemIndex = newListItems.indexOf(oldInfo.activeItem);
        if (activeItemIndex > -1) {
          newInfo = {
            activeItem: oldInfo.activeItem,
            activeIndex: activeItemIndex
          };
        } else if (newListItems[oldInfo.activeIndex] !== undefined) {
          newInfo = {
            activeItem: newListItems[oldInfo.activeIndex],
            activeIndex: oldInfo.activeIndex
          };
        } else {
          newInfo = {
            activeItem: newListItems[newListItems.length - 1],
            activeIndex: newListItems.length - 1
          };
        }
      } else {
        newInfo = {
          activeItem: newListItems[0],
          activeIndex: 0
        };
      }
      newInfo.items = newListItems;

      newListInfoByKey.set(key, newInfo);
      return key;
    });

    return { newListOrderByKey, newListInfoByKey };
  }

  activateItemBasedOnIndex(oldActiveListIndex) {
    let newActiveListKey = this.listOrderByKey[oldActiveListIndex];
    if (newActiveListKey) {
      this.activateListForKey(newActiveListKey, { suppressCallback: true });
    } else {
      newActiveListKey = this.listOrderByKey[this.listOrderByKey.length - 1];
      const items = this.getItemsForKey(newActiveListKey);
      this.activateItemAtIndexForKey(newActiveListKey, items.length - 1, { suppressCallback: true });
    }
  }

  toObject() {
    const listOrderByKey = this.listOrderByKey,
          activeListKey = this.activeListKey;

    return { listOrderByKey, activeListKey };
  }
};
exports.default = MultiList;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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