'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _multiList = require('./multi-list');

var _multiList2 = _interopRequireDefault(_multiList);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let MultiListCollection = class MultiListCollection {
  constructor(lists, didChangeSelection) {
    this.list = new _multiList2.default(lists, (item, key) => {
      didChangeSelection && didChangeSelection(item, key);
    });
    const selectedKey = this.list.getActiveListKey();
    const selectedItem = this.list.getActiveItem();
    this.selectedKeys = new Set(selectedKey ? [selectedKey] : []);
    this.selectedItems = new Set(selectedItem ? [selectedItem] : []);
  }

  updateLists(lists) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let suppressCallback = _ref.suppressCallback;

    const listKeys = this.list.getListKeys();

    let oldActiveListIndex, oldActiveListItemIndex;
    for (let i = 0; i < listKeys.length; i++) {
      const key = listKeys[i];
      if (this.selectedKeys.has(key)) {
        oldActiveListIndex = i;
        const items = this.getItemsForKey(key);
        for (let j = 0; j < items.length; j++) {
          const item = items[j];
          if (this.selectedItems.has(item)) {
            oldActiveListItemIndex = j;
            break;
          }
        }
        break;
      }
    }

    this.list.updateLists(lists, { suppressCallback, oldActiveListIndex, oldActiveListItemIndex });
    this.updateSelections();
  }

  clearSelectedItems() {
    this.selectedItems = new Set();
  }

  clearSelectedKeys() {
    this.selectedKeys = new Set();
  }

  getSelectedItems() {
    return this.selectedItems;
  }

  getSelectedKeys() {
    return this.selectedKeys;
  }

  getItemsForKey(key) {
    return this.list.getItemsForKey(key);
  }

  getActiveListKey() {
    return this.list.getActiveListKey();
  }

  getActiveItem() {
    return this.list.getActiveItem();
  }

  selectNextList() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref2.wrap,
        addToExisting = _ref2.addToExisting;

    this.list.activateNextList({ wrap });
    this.updateSelections({ addToExisting });
  }

  selectPreviousList() {
    var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let wrap = _ref3.wrap,
        addToExisting = _ref3.addToExisting;

    this.list.activatePreviousList({ wrap });
    this.updateSelections({ addToExisting });
  }

  selectNextItem() {
    var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let addToExisting = _ref4.addToExisting,
        stopAtBounds = _ref4.stopAtBounds;

    this.list.activateNextItem({ stopAtBounds });
    this.updateSelections({ addToExisting });
  }

  selectPreviousItem() {
    var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let addToExisting = _ref5.addToExisting,
        stopAtBounds = _ref5.stopAtBounds;

    this.list.activatePreviousItem({ stopAtBounds });
    this.updateSelections({ addToExisting });
  }

  updateSelections() {
    var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let addToExisting = _ref6.addToExisting;

    const selectedKey = this.list.getActiveListKey();
    const selectedItem = this.list.getActiveItem();
    this.selectItems(selectedItem ? [selectedItem] : [], { addToExisting, suppressCallback: true });
    this.selectKeys(selectedKey ? [selectedKey] : [], { addToExisting, suppressCallback: true });
  }

  selectItems(items) {
    var _ref7 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let addToExisting = _ref7.addToExisting,
        suppressCallback = _ref7.suppressCallback;

    if (!addToExisting) {
      this.clearSelectedItems();
    }
    items.forEach(item => this.selectedItems.add(item));
    this.list.activateItem(items[0], { suppressCallback });
  }

  selectKeys(keys) {
    var _ref8 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let addToExisting = _ref8.addToExisting,
        suppressCallback = _ref8.suppressCallback;

    if (!addToExisting) {
      this.clearSelectedKeys();
    }
    keys.forEach(key => this.selectedKeys.add(key));
    this.list.activateListForKey(keys[0], { suppressCallback });
  }

  selectAllItemsForKey(key, addToExisting) {
    this.selectKeys([key], { addToExisting });
    this.selectItems(this.list.getItemsForKey(key), { addToExisting });
  }

  selectFirstItemForKey(key) {
    var _ref9 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let addToExisting = _ref9.addToExisting;

    this.selectKeys([key], { addToExisting });
    this.selectItems([this.list.getItemsForKey(key)[0]], { addToExisting });
  }

  selectItemsAndKeysInRange(endPoint1, endPoint2, addToExisting) {
    if (!addToExisting) {
      this.clearSelectedItems();
      this.clearSelectedKeys();
    }
    // TODO: optimize
    const listKeys = this.list.getListKeys();
    const index1 = listKeys.indexOf(endPoint1.key);
    const index2 = listKeys.indexOf(endPoint2.key);

    if (index1 < 0) {
      throw new Error(`key "${endPoint1.key}" not found`);
    }
    if (index2 < 0) {
      throw new Error(`key "${endPoint2.key}" not found`);
    }
    let startPoint, endPoint, startKeyIndex, endKeyIndex;
    if (index1 < index2) {
      startPoint = endPoint1;
      endPoint = endPoint2;
      startKeyIndex = index1;
      endKeyIndex = index2;
    } else {
      startPoint = endPoint2;
      endPoint = endPoint1;
      startKeyIndex = index2;
      endKeyIndex = index1;
    }
    const startItemIndex = this.list.getItemIndexForKey(startPoint.key, startPoint.item);
    const endItemIndex = this.list.getItemIndexForKey(endPoint.key, endPoint.item);
    if (startItemIndex < 0) {
      throw new Error(`item "${startPoint.item}" not found`);
    }
    if (endItemIndex < 0) {
      throw new Error(`item "${endPoint.item}" not found`);
    }

    if (startKeyIndex === endKeyIndex) {
      const items = this.list.getItemsForKey(listKeys[startKeyIndex]);
      const indexes = [startItemIndex, endItemIndex].sort((a, b) => a - b);
      this.selectKeys([startPoint.key], { addToExisting: true, suppressCallback: true });
      this.selectItems(items.slice(indexes[0], indexes[1] + 1), { addToExisting: true });
      return;
    }

    for (let i = startKeyIndex; i <= endKeyIndex; i++) {
      const key = listKeys[i];
      const items = this.list.getItemsForKey(key);
      if (i === startKeyIndex) {
        this.selectItems(items.slice(startItemIndex), { addToExisting: true });
      } else if (i === endKeyIndex) {
        this.selectItems(items.slice(0, endItemIndex + 1), { addToExisting: true });
      } else {
        this.selectItems(items, { addToExisting: true });
      }
    }
    const keys = listKeys.slice(startKeyIndex, endKeyIndex - startKeyIndex + 1);
    this.selectKeys(keys, { addToExisting: true, suppressCallback: true });
  }
};
exports.default = MultiListCollection;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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