'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _compareSets2 = require('compare-sets');

var _compareSets3 = _interopRequireDefault(_compareSets2);

var _eventKit = require('event-kit');

var _workdirContext = require('./workdir-context');

var _workdirContext2 = _interopRequireDefault(_workdirContext);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Manage a WorkdirContext for each open directory.
 */
let WorkdirContextPool = class WorkdirContextPool {

  /**
   * Options will be passed to each `WorkdirContext` as it is created.
   */
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    this.options = options;

    this.contexts = new Map();
    this.emitter = new _eventKit.Emitter();
  }

  size() {
    return this.contexts.size;
  }

  /**
   * Access the context mapped to a known directory.
   */
  getContext(directory) {
    return this.contexts.get(directory) || _workdirContext2.default.absent();
  }

  add(directory) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (this.contexts.has(directory)) {
      return this.getContext(directory);
    }

    const context = new _workdirContext2.default(directory, _extends({}, this.options, options));
    this.contexts.set(directory, context);

    const disposable = new _eventKit.CompositeDisposable();

    const forwardEvent = (subMethod, emitEventName) => {
      const emit = () => this.emitter.emit(emitEventName, context);
      disposable.add(context[subMethod](emit));
    };

    forwardEvent('onDidStartObserver', 'did-start-observer');
    forwardEvent('onDidChangeWorkdirOrHead', 'did-change-workdir-or-head');
    forwardEvent('onDidChangeRepositoryState', 'did-change-repository-state');
    forwardEvent('onDidUpdateRepository', 'did-update-repository');
    forwardEvent('onDidDestroyRepository', 'did-destroy-repository');

    disposable.add(this.onDidRemoveContext(removed => {
      if (removed === context) {
        disposable.dispose();
      }
    }));

    return context;
  }

  replace(directory) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    this.remove(directory);
    this.add(directory, options);
  }

  remove(directory) {
    const existing = this.contexts.get(directory);
    this.contexts.delete(directory);

    if (existing) {
      this.emitter.emit('did-remove-context', existing);
      existing.destroy();
    }
  }

  set(directories) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    const previous = new Set(this.contexts.keys());

    var _compareSets = (0, _compareSets3.default)(previous, directories);

    const added = _compareSets.added,
          removed = _compareSets.removed;


    for (const directory of added) {
      this.add(directory, options);
    }
    for (const directory of removed) {
      this.remove(directory);
    }
  }

  withResidentContexts(callback) {
    for (const _ref of this.contexts) {
      var _ref2 = _slicedToArray(_ref, 2);

      const workdir = _ref2[0];
      const context = _ref2[1];

      callback(workdir, context);
    }
  }

  onDidStartObserver(callback) {
    return this.emitter.on('did-start-observer', callback);
  }

  onDidChangeWorkdirOrHead(callback) {
    return this.emitter.on('did-change-workdir-or-head', callback);
  }

  onDidRemoveContext(callback) {
    return this.emitter.on('did-remove-context', callback);
  }

  onDidChangeRepositoryState(callback) {
    return this.emitter.on('did-change-repository-state', callback);
  }

  onDidUpdateRepository(callback) {
    return this.emitter.on('did-update-repository', callback);
  }

  onDidDestroyRepository(callback) {
    return this.emitter.on('did-destroy-repository', callback);
  }

  clear() {
    this.withResidentContexts(workdir => this.remove(workdir));
    _workdirContext2.default.destroyAbsent();
  }
};
exports.default = WorkdirContextPool;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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