'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Git is asynchronously initializing a new repository in this working directory.
 */
let Initializing = class Initializing extends _state2.default {
  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield _this.doInit(_this.workdir());

      yield _this.transitionTo('Loading');
    })();
  }

  showGitTabLoading() {
    return true;
  }

  directInit(workdir) {
    return this.git().init(workdir);
  }
};
exports.default = Initializing;


_state2.default.register(Initializing);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXRpYWxpemluZy5qcyJdLCJuYW1lcyI6WyJJbml0aWFsaXppbmciLCJzdGFydCIsImRvSW5pdCIsIndvcmtkaXIiLCJ0cmFuc2l0aW9uVG8iLCJzaG93R2l0VGFiTG9hZGluZyIsImRpcmVjdEluaXQiLCJnaXQiLCJpbml0IiwicmVnaXN0ZXIiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7Ozs7Ozs7QUFFQTs7O0lBR3FCQSxZLEdBQU4sTUFBTUEsWUFBTix5QkFBaUM7QUFDeENDLE9BQU4sR0FBYztBQUFBOztBQUFBO0FBQ1osWUFBTSxNQUFLQyxNQUFMLENBQVksTUFBS0MsT0FBTCxFQUFaLENBQU47O0FBRUEsWUFBTSxNQUFLQyxZQUFMLENBQWtCLFNBQWxCLENBQU47QUFIWTtBQUliOztBQUVEQyxzQkFBb0I7QUFDbEIsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLGFBQVdILE9BQVgsRUFBb0I7QUFDbEIsV0FBTyxLQUFLSSxHQUFMLEdBQVdDLElBQVgsQ0FBZ0JMLE9BQWhCLENBQVA7QUFDRDtBQWI2QyxDO2tCQUEzQkgsWTs7O0FBZ0JyQixnQkFBTVMsUUFBTixDQUFlVCxZQUFmIiwiZmlsZSI6ImluaXRpYWxpemluZy5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS9hbmRyZWkvYXRvbS0xLjE5LjIvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIEdpdCBpcyBhc3luY2hyb25vdXNseSBpbml0aWFsaXppbmcgYSBuZXcgcmVwb3NpdG9yeSBpbiB0aGlzIHdvcmtpbmcgZGlyZWN0b3J5LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBJbml0aWFsaXppbmcgZXh0ZW5kcyBTdGF0ZSB7XG4gIGFzeW5jIHN0YXJ0KCkge1xuICAgIGF3YWl0IHRoaXMuZG9Jbml0KHRoaXMud29ya2RpcigpKTtcblxuICAgIGF3YWl0IHRoaXMudHJhbnNpdGlvblRvKCdMb2FkaW5nJyk7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGRpcmVjdEluaXQod29ya2Rpcikge1xuICAgIHJldHVybiB0aGlzLmdpdCgpLmluaXQod29ya2Rpcik7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoSW5pdGlhbGl6aW5nKTtcbiJdfQ==