'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _helpers = require('../../helpers');

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
let Cloning = class Cloning extends _state2.default {
  constructor(repository, remoteUrl) {
    super(repository);
    this.remoteUrl = remoteUrl;
  }

  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield (0, _helpers.mkdirs)(_this.workdir());
      yield _this.doClone(_this.remoteUrl, { recursive: true });

      yield _this.transitionTo('Loading');
    })();
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }
};
exports.default = Cloning;


_state2.default.register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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