"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
let statePerType = new WeakMap();

let _default = class _default {
  static clearSavedState() {
    statePerType = new WeakMap();
  }

  constructor(type, _ref) {
    let initialModel = _ref.initialModel,
        save = _ref.save,
        restore = _ref.restore;

    this.saveData = save;
    this.restoreData = restore;
    if (statePerType.has(type)) {
      this.statePerModel = statePerType.get(type);
    } else {
      this.statePerModel = new WeakMap();
      statePerType.set(type, this.statePerModel);
    }
    this.setModel(initialModel);
  }

  setModel(model) {
    if (model !== this.model) {
      this.save();
      this.restore(model);
    }
  }

  save() {
    this.model && this.statePerModel.set(this.model, this.saveData());
  }

  restore(model) {
    model && this.restoreData(this.statePerModel.get(model));
    this.model = model;
  }
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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