"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let ModelObserver = class ModelObserver {
  constructor(_ref) {
    let fetchData = _ref.fetchData,
        didUpdate = _ref.didUpdate;

    this.fetchData = fetchData || (() => {});
    this.didUpdate = didUpdate || (() => {});
    this.activeModel = null;
    this.activeModelData = null;
    this.activeModelUpdateSubscription = null;
    this.inProgress = false;
    this.pending = false;
  }

  setActiveModel(model) {
    if (model !== this.activeModel) {
      if (this.activeModelUpdateSubscription) {
        this.activeModelUpdateSubscription.dispose();
        this.activeModelUpdateSubscription = null;
      }
      this.activeModel = model;
      this.activeModelData = null;
      this.inProgress = false;
      this.pending = false;
      this.didUpdate(model);
      if (model) {
        this.activeModelUpdateSubscription = model.onDidUpdate(() => this.refreshModelData(model));
        return this.refreshModelData(model);
      }
    }
    return null;
  }

  refreshModelData() {
    let model = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.activeModel;

    if (this.inProgress) {
      this.pending = true;
      return null;
    }
    this.lastModelDataRefreshPromise = this._refreshModelData(model);
    return this.lastModelDataRefreshPromise;
  }

  _refreshModelData(model) {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        _this.inProgress = true;
        const fetchDataPromise = _this.fetchData(model);
        _this.lastFetchDataPromise = fetchDataPromise;
        const modelData = yield fetchDataPromise;
        // Since we re-fetch immediately when the model changes,
        // we need to ensure a fetch for an old active model
        // does not trample the newer fetch for the newer active model.
        if (fetchDataPromise === _this.lastFetchDataPromise) {
          _this.activeModel = model;
          _this.activeModelData = modelData;
          _this.didUpdate(model);
        }
      } finally {
        _this.inProgress = false;
        if (_this.pending) {
          _this.pending = false;
          _this.refreshModelData();
        }
      }
    })();
  }

  getActiveModel() {
    return this.activeModel;
  }

  getActiveModelData() {
    return this.activeModelData;
  }

  getLastModelDataRefreshPromise() {
    return this.lastModelDataRefreshPromise;
  }

  destroy() {
    if (this.activeModelUpdateSubscription) {
      this.activeModelUpdateSubscription.dispose();
    }
  }
};
exports.default = ModelObserver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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