'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _class, _temp;

let HunkLine = (_temp = _class = class HunkLine {

  constructor(text, status, oldLineNumber, newLineNumber, diffLineNumber) {
    this.text = text;
    this.status = status;
    this.oldLineNumber = oldLineNumber;
    this.newLineNumber = newLineNumber;
    this.diffLineNumber = diffLineNumber;
  }

  copy() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let text = _ref.text,
        status = _ref.status,
        oldLineNumber = _ref.oldLineNumber,
        newLineNumber = _ref.newLineNumber;

    return new HunkLine(text || this.getText(), status || this.getStatus(), oldLineNumber || this.getOldLineNumber(), newLineNumber || this.getNewLineNumber());
  }

  getText() {
    return this.text;
  }

  getOldLineNumber() {
    return this.oldLineNumber;
  }

  getNewLineNumber() {
    return this.newLineNumber;
  }

  getStatus() {
    return this.status;
  }

  isChanged() {
    return this.getStatus() === 'added' || this.getStatus() === 'deleted';
  }

  getOrigin() {
    switch (this.getStatus()) {
      case 'added':
        return '+';
      case 'deleted':
        return '-';
      case 'unchanged':
        return ' ';
      case 'nonewline':
        return '\\';
      default:
        return '';
    }
  }

  invert() {
    let invertedStatus;
    switch (this.getStatus()) {
      case 'added':
        invertedStatus = 'deleted';
        break;
      case 'deleted':
        invertedStatus = 'added';
        break;
      case 'unchanged':
        invertedStatus = 'unchanged';
        break;
      case 'nonewline':
        invertedStatus = 'nonewline';
        break;
    }

    return new HunkLine(this.text, invertedStatus, this.newLineNumber, this.oldLineNumber);
  }

  toString() {
    return this.getOrigin() + (this.getStatus() === 'nonewline' ? ' ' : '') + this.getText();
  }
}, _class.statusMap = {
  '+': 'added',
  '-': 'deleted',
  ' ': 'unchanged',
  '\\': 'nonewline'
}, _temp);
exports.default = HunkLine;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh1bmstbGluZS5qcyJdLCJuYW1lcyI6WyJIdW5rTGluZSIsImNvbnN0cnVjdG9yIiwidGV4dCIsInN0YXR1cyIsIm9sZExpbmVOdW1iZXIiLCJuZXdMaW5lTnVtYmVyIiwiZGlmZkxpbmVOdW1iZXIiLCJjb3B5IiwiZ2V0VGV4dCIsImdldFN0YXR1cyIsImdldE9sZExpbmVOdW1iZXIiLCJnZXROZXdMaW5lTnVtYmVyIiwiaXNDaGFuZ2VkIiwiZ2V0T3JpZ2luIiwiaW52ZXJ0IiwiaW52ZXJ0ZWRTdGF0dXMiLCJ0b1N0cmluZyIsInN0YXR1c01hcCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7SUFBcUJBLFEscUJBQU4sTUFBTUEsUUFBTixDQUFlOztBQVE1QkMsY0FBWUMsSUFBWixFQUFrQkMsTUFBbEIsRUFBMEJDLGFBQTFCLEVBQXlDQyxhQUF6QyxFQUF3REMsY0FBeEQsRUFBd0U7QUFDdEUsU0FBS0osSUFBTCxHQUFZQSxJQUFaO0FBQ0EsU0FBS0MsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0MsYUFBTCxHQUFxQkEsYUFBckI7QUFDQSxTQUFLQyxhQUFMLEdBQXFCQSxhQUFyQjtBQUNBLFNBQUtDLGNBQUwsR0FBc0JBLGNBQXRCO0FBQ0Q7O0FBRURDLFNBQXdEO0FBQUEsbUZBQUosRUFBSTs7QUFBQSxRQUFsREwsSUFBa0QsUUFBbERBLElBQWtEO0FBQUEsUUFBNUNDLE1BQTRDLFFBQTVDQSxNQUE0QztBQUFBLFFBQXBDQyxhQUFvQyxRQUFwQ0EsYUFBb0M7QUFBQSxRQUFyQkMsYUFBcUIsUUFBckJBLGFBQXFCOztBQUN0RCxXQUFPLElBQUlMLFFBQUosQ0FDTEUsUUFBUSxLQUFLTSxPQUFMLEVBREgsRUFFTEwsVUFBVSxLQUFLTSxTQUFMLEVBRkwsRUFHTEwsaUJBQWlCLEtBQUtNLGdCQUFMLEVBSFosRUFJTEwsaUJBQWlCLEtBQUtNLGdCQUFMLEVBSlosQ0FBUDtBQU1EOztBQUVESCxZQUFVO0FBQ1IsV0FBTyxLQUFLTixJQUFaO0FBQ0Q7O0FBRURRLHFCQUFtQjtBQUNqQixXQUFPLEtBQUtOLGFBQVo7QUFDRDs7QUFFRE8scUJBQW1CO0FBQ2pCLFdBQU8sS0FBS04sYUFBWjtBQUNEOztBQUVESSxjQUFZO0FBQ1YsV0FBTyxLQUFLTixNQUFaO0FBQ0Q7O0FBRURTLGNBQVk7QUFDVixXQUFPLEtBQUtILFNBQUwsT0FBcUIsT0FBckIsSUFBZ0MsS0FBS0EsU0FBTCxPQUFxQixTQUE1RDtBQUNEOztBQUVESSxjQUFZO0FBQ1YsWUFBUSxLQUFLSixTQUFMLEVBQVI7QUFDRSxXQUFLLE9BQUw7QUFDRSxlQUFPLEdBQVA7QUFDRixXQUFLLFNBQUw7QUFDRSxlQUFPLEdBQVA7QUFDRixXQUFLLFdBQUw7QUFDRSxlQUFPLEdBQVA7QUFDRixXQUFLLFdBQUw7QUFDRSxlQUFPLElBQVA7QUFDRjtBQUNFLGVBQU8sRUFBUDtBQVZKO0FBWUQ7O0FBRURLLFdBQVM7QUFDUCxRQUFJQyxjQUFKO0FBQ0EsWUFBUSxLQUFLTixTQUFMLEVBQVI7QUFDRSxXQUFLLE9BQUw7QUFDRU0seUJBQWlCLFNBQWpCO0FBQ0E7QUFDRixXQUFLLFNBQUw7QUFDRUEseUJBQWlCLE9BQWpCO0FBQ0E7QUFDRixXQUFLLFdBQUw7QUFDRUEseUJBQWlCLFdBQWpCO0FBQ0E7QUFDRixXQUFLLFdBQUw7QUFDRUEseUJBQWlCLFdBQWpCO0FBQ0E7QUFaSjs7QUFlQSxXQUFPLElBQUlmLFFBQUosQ0FDTCxLQUFLRSxJQURBLEVBRUxhLGNBRkssRUFHTCxLQUFLVixhQUhBLEVBSUwsS0FBS0QsYUFKQSxDQUFQO0FBTUQ7O0FBRURZLGFBQVc7QUFDVCxXQUFPLEtBQUtILFNBQUwsTUFBb0IsS0FBS0osU0FBTCxPQUFxQixXQUFyQixHQUFtQyxHQUFuQyxHQUF5QyxFQUE3RCxJQUFtRSxLQUFLRCxPQUFMLEVBQTFFO0FBQ0Q7QUF2RjJCLEMsU0FDckJTLFMsR0FBWTtBQUNqQixPQUFLLE9BRFk7QUFFakIsT0FBSyxTQUZZO0FBR2pCLE9BQUssV0FIWTtBQUlqQixRQUFNO0FBSlcsQztrQkFEQWpCLFEiLCJmaWxlIjoiaHVuay1saW5lLmpzIiwic291cmNlUm9vdCI6Ii9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBjbGFzcyBIdW5rTGluZSB7XG4gIHN0YXRpYyBzdGF0dXNNYXAgPSB7XG4gICAgJysnOiAnYWRkZWQnLFxuICAgICctJzogJ2RlbGV0ZWQnLFxuICAgICcgJzogJ3VuY2hhbmdlZCcsXG4gICAgJ1xcXFwnOiAnbm9uZXdsaW5lJyxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHRleHQsIHN0YXR1cywgb2xkTGluZU51bWJlciwgbmV3TGluZU51bWJlciwgZGlmZkxpbmVOdW1iZXIpIHtcbiAgICB0aGlzLnRleHQgPSB0ZXh0O1xuICAgIHRoaXMuc3RhdHVzID0gc3RhdHVzO1xuICAgIHRoaXMub2xkTGluZU51bWJlciA9IG9sZExpbmVOdW1iZXI7XG4gICAgdGhpcy5uZXdMaW5lTnVtYmVyID0gbmV3TGluZU51bWJlcjtcbiAgICB0aGlzLmRpZmZMaW5lTnVtYmVyID0gZGlmZkxpbmVOdW1iZXI7XG4gIH1cblxuICBjb3B5KHt0ZXh0LCBzdGF0dXMsIG9sZExpbmVOdW1iZXIsIG5ld0xpbmVOdW1iZXJ9ID0ge30pIHtcbiAgICByZXR1cm4gbmV3IEh1bmtMaW5lKFxuICAgICAgdGV4dCB8fCB0aGlzLmdldFRleHQoKSxcbiAgICAgIHN0YXR1cyB8fCB0aGlzLmdldFN0YXR1cygpLFxuICAgICAgb2xkTGluZU51bWJlciB8fCB0aGlzLmdldE9sZExpbmVOdW1iZXIoKSxcbiAgICAgIG5ld0xpbmVOdW1iZXIgfHwgdGhpcy5nZXROZXdMaW5lTnVtYmVyKCksXG4gICAgKTtcbiAgfVxuXG4gIGdldFRleHQoKSB7XG4gICAgcmV0dXJuIHRoaXMudGV4dDtcbiAgfVxuXG4gIGdldE9sZExpbmVOdW1iZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMub2xkTGluZU51bWJlcjtcbiAgfVxuXG4gIGdldE5ld0xpbmVOdW1iZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMubmV3TGluZU51bWJlcjtcbiAgfVxuXG4gIGdldFN0YXR1cygpIHtcbiAgICByZXR1cm4gdGhpcy5zdGF0dXM7XG4gIH1cblxuICBpc0NoYW5nZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RhdHVzKCkgPT09ICdhZGRlZCcgfHwgdGhpcy5nZXRTdGF0dXMoKSA9PT0gJ2RlbGV0ZWQnO1xuICB9XG5cbiAgZ2V0T3JpZ2luKCkge1xuICAgIHN3aXRjaCAodGhpcy5nZXRTdGF0dXMoKSkge1xuICAgICAgY2FzZSAnYWRkZWQnOlxuICAgICAgICByZXR1cm4gJysnO1xuICAgICAgY2FzZSAnZGVsZXRlZCc6XG4gICAgICAgIHJldHVybiAnLSc7XG4gICAgICBjYXNlICd1bmNoYW5nZWQnOlxuICAgICAgICByZXR1cm4gJyAnO1xuICAgICAgY2FzZSAnbm9uZXdsaW5lJzpcbiAgICAgICAgcmV0dXJuICdcXFxcJztcbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIHJldHVybiAnJztcbiAgICB9XG4gIH1cblxuICBpbnZlcnQoKSB7XG4gICAgbGV0IGludmVydGVkU3RhdHVzO1xuICAgIHN3aXRjaCAodGhpcy5nZXRTdGF0dXMoKSkge1xuICAgICAgY2FzZSAnYWRkZWQnOlxuICAgICAgICBpbnZlcnRlZFN0YXR1cyA9ICdkZWxldGVkJztcbiAgICAgICAgYnJlYWs7XG4gICAgICBjYXNlICdkZWxldGVkJzpcbiAgICAgICAgaW52ZXJ0ZWRTdGF0dXMgPSAnYWRkZWQnO1xuICAgICAgICBicmVhaztcbiAgICAgIGNhc2UgJ3VuY2hhbmdlZCc6XG4gICAgICAgIGludmVydGVkU3RhdHVzID0gJ3VuY2hhbmdlZCc7XG4gICAgICAgIGJyZWFrO1xuICAgICAgY2FzZSAnbm9uZXdsaW5lJzpcbiAgICAgICAgaW52ZXJ0ZWRTdGF0dXMgPSAnbm9uZXdsaW5lJztcbiAgICAgICAgYnJlYWs7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBIdW5rTGluZShcbiAgICAgIHRoaXMudGV4dCxcbiAgICAgIGludmVydGVkU3RhdHVzLFxuICAgICAgdGhpcy5uZXdMaW5lTnVtYmVyLFxuICAgICAgdGhpcy5vbGRMaW5lTnVtYmVyLFxuICAgICk7XG4gIH1cblxuICB0b1N0cmluZygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRPcmlnaW4oKSArICh0aGlzLmdldFN0YXR1cygpID09PSAnbm9uZXdsaW5lJyA/ICcgJyA6ICcnKSArIHRoaXMuZ2V0VGV4dCgpO1xuICB9XG59XG4iXX0=