'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _eventKit = require('event-kit');

var _nsfw = require('nsfw');

var _nsfw2 = _interopRequireDefault(_nsfw);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _eventLogger = require('./event-logger');

var _eventLogger2 = _interopRequireDefault(_eventLogger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let FileSystemChangeObserver = class FileSystemChangeObserver {
  constructor(repository) {
    this.emitter = new _eventKit.Emitter();
    this.repository = repository;
    this.logger = new _eventLogger2.default('fs watcher');
    this.started = false;
  }

  start() {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield _this.watchRepository();
      _this.started = true;
      return _this;
    })();
  }

  destroy() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.started = false;
      _this2.emitter.dispose();
      yield _this2.stopCurrentFileWatcher();
    })();
  }

  isStarted() {
    return this.started;
  }

  didChange(payload) {
    this.emitter.emit('did-change', payload);
  }

  didChangeWorkdirOrHead() {
    this.emitter.emit('did-change-workdir-or-head');
  }

  onDidChange(callback) {
    return this.emitter.on('did-change', callback);
  }

  onDidChangeWorkdirOrHead(callback) {
    return this.emitter.on('did-change-workdir-or-head', callback);
  }

  getRepository() {
    return this.repository;
  }

  watchRepository() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      if (_this3.repository) {
        _this3.currentFileWatcher = yield (0, _nsfw2.default)(_this3.repository.getWorkingDirectoryPath(), function (events) {
          const isNonGitFile = function (event) {
            return !event.directory.split(_path2.default.sep).includes('.git') && event.file !== '.git';
          };
          const isWatchedGitFile = function (event) {
            return ['config', 'index', 'HEAD', 'MERGE_HEAD'].includes(event.file || event.newFile) || event.directory.includes(_path2.default.join('.git', 'refs'));
          };
          const filteredEvents = events.filter(function (e) {
            return isNonGitFile(e) || isWatchedGitFile(e);
          });
          if (filteredEvents.length) {
            _this3.logger.showEvents(filteredEvents);
            _this3.didChange(filteredEvents);
            const workdirOrHeadEvent = filteredEvents.find(function (e) {
              return !['config', 'index'].includes(e.file || e.newFile);
            });
            if (workdirOrHeadEvent) {
              _this3.logger.showWorkdirOrHeadEvents();
              _this3.didChangeWorkdirOrHead();
            }
          }
        }, {
          debounceMS: 100,
          errorCallback: function (errors) {
            const workingDirectory = _this3.repository.getWorkingDirectoryPath();
            // eslint-disable-next-line no-console
            console.warn(`Error in FileSystemChangeObserver in ${workingDirectory}:`, errors);
            _this3.stopCurrentFileWatcher();
          }
        });
        yield _this3.currentFileWatcher.start();
        _this3.logger.showStarted(_this3.repository.getWorkingDirectoryPath());
      }
    })();
  }

  stopCurrentFileWatcher() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (_this4.currentFileWatcher) {
        const stopPromise = _this4.currentFileWatcher.stop();
        _this4.currentFileWatcher = null;
        yield stopPromise;
        _this4.logger.showStopped();
      }
    })();
  }
};
exports.default = FileSystemChangeObserver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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