'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _nsfw = require('nsfw');

var _nsfw2 = _interopRequireDefault(_nsfw);

var _electron = require('electron');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const actionText = new Map();
actionText.set(_nsfw2.default.actions.CREATED, 'created');
actionText.set(_nsfw2.default.actions.DELETED, 'deleted');
actionText.set(_nsfw2.default.actions.MODIFIED, 'modified');
actionText.set(_nsfw2.default.actions.RENAMED, 'renamed');

let headless = null;

let EventLogger = class EventLogger {
  constructor(kind) {
    this.kind = kind;
    this.directory = '<unknown>';
    this.shortDirectory = '<unknown>';

    if (headless === null) {
      headless = !_electron.remote.getCurrentWindow().isVisible();
    }
  }

  showStarted(directory) {
    this.directory = directory;
    this.shortDirectory = _path2.default.basename(directory);

    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('watcher started');
  }

  showEvents(events) {
    if (!this.isEnabled()) {
      return;
    }

    const uniqueRelativeNames = new Set(events.map(event => {
      const fullPath = _path2.default.join(event.directory, event.file || event.newFile);
      return _path2.default.relative(this.directory, fullPath);
    }));

    const fileNames = Array.from(uniqueRelativeNames).slice(0, 3);
    const elipses = uniqueRelativeNames.size > 3 ? '...' : '';
    const summary = `${this.getShortName()}: ${fileNames.join(', ')}${elipses}`;

    /* eslint-disable no-console */
    if (headless) {
      const eventText = events.map(event => {
        const file = event.file ? event.file : `${event.oldFile} => ${event.newFile}`;
        const action = actionText.get(event.action) || `unknown: ${event.action}`;
        return `  ${event.directory} => ${file} (${action})\n`;
      }).join('\n');
      console.log(summary + '\n' + eventText);
    } else {
      console.groupCollapsed(summary);
      console.table(events.map(event => ({
        directory: event.directory,
        file: event.file,
        newFile: event.newFile,
        action: actionText.get(event.action) || `(unknown: ${event.action})`
      })), ['directory', 'action', 'file', 'newFile']);
      console.groupEnd();
    }
    /* eslint-enable no-console */
  }

  showFocusEvent() {
    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('focus triggered');
  }

  showWorkdirOrHeadEvents() {
    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('working directory or HEAD change');
  }

  showStopped() {
    if (!this.isEnabled()) {
      return;
    }

    this.shortLog('stopped');
  }

  isEnabled() {
    return process.env.ATOM_GITHUB_FS_EVENT_LOG || atom.config.get('github.filesystemEventDiagnostics');
  }

  getShortName() {
    return `${this.kind} @ ${this.shortDirectory}`;
  }

  shortLog(line) {
    if (headless) {
      // eslint-disable-next-line no-console
      console.log(`${this.getShortName()}: ${line}`);
      return;
    }

    // eslint-disable-next-line no-console
    console.log('%c%s%c: %s', 'font-weight: bold; color: blue;', this.getShortName(), 'font-weight: normal; color: black;', line);
  }
};
exports.default = EventLogger;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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