'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _mkdirp = require('mkdirp');

var _mkdirp2 = _interopRequireDefault(_mkdirp);

var _discardHistoryStores = require('./discard-history-stores');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

const emptyFilePath = _path2.default.join(_os2.default.tmpdir(), 'empty-file.txt');
const emptyFilePromise = (0, _helpers.writeFile)(emptyFilePath, '');

let DiscardHistory = class DiscardHistory {
  constructor(createBlob, expandBlobToFile, mergeFile, workdirPath) {
    var _ref = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    let maxHistoryLength = _ref.maxHistoryLength;

    this.createBlob = createBlob;
    this.expandBlobToFile = expandBlobToFile;
    this.mergeFile = mergeFile;
    this.workdirPath = workdirPath;
    this.partialFileHistory = new _discardHistoryStores.PartialFileDiscardHistory(maxHistoryLength);
    this.wholeFileHistory = new _discardHistoryStores.WholeFileDiscardHistory(maxHistoryLength);
  }

  getLastSnapshots() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      return this.partialFileHistory.getLastSnapshotsForPath(partialDiscardFilePath);
    } else {
      return this.wholeFileHistory.getLastSnapshots();
    }
  }

  getHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      return this.partialFileHistory.getHistoryForPath(partialDiscardFilePath);
    } else {
      return this.wholeFileHistory.getHistory();
    }
  }

  hasHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    const history = this.getHistory(partialDiscardFilePath);
    return history.length > 0;
  }

  popHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      return this.partialFileHistory.popHistoryForPath(partialDiscardFilePath);
    } else {
      return this.wholeFileHistory.popHistory();
    }
  }

  clearHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    if (partialDiscardFilePath) {
      this.partialFileHistory.clearHistoryForPath(partialDiscardFilePath);
    } else {
      this.wholeFileHistory.clearHistory();
    }
  }

  updateHistory(history) {
    this.partialFileHistory.setHistory(history.partialFileHistory || {});
    this.wholeFileHistory.setHistory(history.wholeFileHistory || []);
  }

  createHistoryBlob() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const histories = {
        wholeFileHistory: _this.wholeFileHistory.getHistory(),
        partialFileHistory: _this.partialFileHistory.getHistory()
      };
      const historySha = yield _this.createBlob({ stdin: JSON.stringify(histories) });
      return historySha;
    })();
  }

  storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction) {
    var _this2 = this;

    let partialDiscardFilePath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    return _asyncToGenerator(function* () {
      if (partialDiscardFilePath) {
        return yield _this2.storeBlobsForPartialFileHistory(partialDiscardFilePath, isSafe, destructiveAction);
      } else {
        return yield _this2.storeBlobsForWholeFileHistory(filePaths, isSafe, destructiveAction);
      }
    })();
  }

  storeBlobsForPartialFileHistory(filePath, isSafe, destructiveAction) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const beforeSha = yield _this3.createBlob({ filePath });
      const isNotSafe = !(yield isSafe());
      if (isNotSafe) {
        return null;
      }
      yield destructiveAction();
      const afterSha = yield _this3.createBlob({ filePath });
      const snapshots = { beforeSha, afterSha };
      _this3.partialFileHistory.addHistory(filePath, snapshots);
      return snapshots;
    })();
  }

  storeBlobsForWholeFileHistory(filePaths, isSafe, destructiveAction) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const snapshotsByPath = {};
      const beforePromises = filePaths.map((() => {
        var _ref2 = _asyncToGenerator(function* (filePath) {
          snapshotsByPath[filePath] = { beforeSha: yield _this4.createBlob({ filePath }) };
        });

        return function (_x8) {
          return _ref2.apply(this, arguments);
        };
      })());
      yield Promise.all(beforePromises);
      const isNotSafe = !(yield isSafe());
      if (isNotSafe) {
        return null;
      }
      yield destructiveAction();
      const afterPromises = filePaths.map((() => {
        var _ref3 = _asyncToGenerator(function* (filePath) {
          snapshotsByPath[filePath].afterSha = yield _this4.createBlob({ filePath });
        });

        return function (_x9) {
          return _ref3.apply(this, arguments);
        };
      })());
      yield Promise.all(afterPromises);
      _this4.wholeFileHistory.addHistory(snapshotsByPath);
      return snapshotsByPath;
    })();
  }

  restoreLastDiscardInTempFiles(isSafe) {
    var _this5 = this;

    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _asyncToGenerator(function* () {
      let lastDiscardSnapshots = _this5.getLastSnapshots(partialDiscardFilePath);
      if (partialDiscardFilePath) {
        lastDiscardSnapshots = lastDiscardSnapshots ? [lastDiscardSnapshots] : [];
      }
      const tempFolderPaths = yield _this5.expandBlobsToFilesInTempFolder(lastDiscardSnapshots);
      if (!isSafe()) {
        return [];
      }
      return yield _this5.mergeFiles(tempFolderPaths);
    })();
  }

  expandBlobsToFilesInTempFolder(snapshots) {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      const tempFolderPath = yield (0, _helpers.getTempDir)('github-discard-history-');
      const pathPromises = snapshots.map((() => {
        var _ref4 = _asyncToGenerator(function* (_ref5) {
          let filePath = _ref5.filePath,
              beforeSha = _ref5.beforeSha,
              afterSha = _ref5.afterSha;

          const dir = _path2.default.dirname(_path2.default.join(tempFolderPath, filePath));
          yield (0, _mkdirp2.default)(dir);
          const theirsPath = !beforeSha ? null : yield _this6.expandBlobToFile(_path2.default.join(tempFolderPath, `${filePath}-before-discard`), beforeSha);
          const commonBasePath = !afterSha ? null : yield _this6.expandBlobToFile(_path2.default.join(tempFolderPath, `${filePath}-after-discard`), afterSha);
          const resultPath = _path2.default.join(tempFolderPath, `~${_path2.default.basename(filePath)}-merge-result`);
          return { filePath, commonBasePath, theirsPath, resultPath, theirsSha: beforeSha, commonBaseSha: afterSha };
        });

        return function (_x11) {
          return _ref4.apply(this, arguments);
        };
      })());
      return yield Promise.all(pathPromises);
    })();
  }

  mergeFiles(filePaths) {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      const mergeFilePromises = filePaths.map((() => {
        var _ref6 = _asyncToGenerator(function* (filePathInfo, i) {
          const filePath = filePathInfo.filePath,
                commonBasePath = filePathInfo.commonBasePath,
                theirsPath = filePathInfo.theirsPath,
                resultPath = filePathInfo.resultPath,
                theirsSha = filePathInfo.theirsSha,
                commonBaseSha = filePathInfo.commonBaseSha;

          const currentSha = yield _this7.createBlob({ filePath });
          let mergeResult;
          if (theirsPath && commonBasePath) {
            mergeResult = yield _this7.mergeFile(filePath, commonBasePath, theirsPath, resultPath);
          } else if (!theirsPath && commonBasePath) {
            // deleted file
            const oursSha = yield _this7.createBlob({ filePath });
            if (oursSha === commonBaseSha) {
              // no changes since discard, mark file to be deleted
              mergeResult = { filePath, resultPath: null, deleted: true, conflict: false };
            } else {
              // changes since discard result in conflict
              yield (0, _helpers.copyFile)(_path2.default.join(_this7.workdirPath, filePath), resultPath);
              mergeResult = { filePath, resultPath, conflict: true };
            }
          } else if (theirsPath && !commonBasePath) {
            // added file
            const fileDoesExist = yield (0, _helpers.fileExists)(_path2.default.join(_this7.workdirPath, filePath));
            if (!fileDoesExist) {
              yield (0, _helpers.copyFile)(theirsPath, resultPath);
              mergeResult = { filePath, resultPath, conflict: false };
            } else {
              yield emptyFilePromise;
              mergeResult = yield _this7.mergeFile(filePath, emptyFilePath, theirsPath, resultPath);
            }
          } else {
            throw new Error('One of the following must be defined - theirsPath:' + `${theirsPath} or commonBasePath: ${commonBasePath}`);
          }
          return _extends({}, mergeResult, { theirsSha, commonBaseSha, currentSha });
        });

        return function (_x12, _x13) {
          return _ref6.apply(this, arguments);
        };
      })());
      return yield Promise.all(mergeFilePromises);
    })();
  }
};
exports.default = DiscardHistory;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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