'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _markerTools = require('./marker-tools');

let Separator = class Separator {
  constructor(editor, marker) {
    this.editor = editor;
    this.marker = marker;
  }

  getMarker() {
    return this.marker;
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }

  isModified() {
    const currentText = this.editor.getTextInBufferRange(this.getMarker().getBufferRange());
    return !/^=======\r?\n?$/.test(currentText);
  }
};
exports.default = Separator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlcGFyYXRvci5qcyJdLCJuYW1lcyI6WyJTZXBhcmF0b3IiLCJjb25zdHJ1Y3RvciIsImVkaXRvciIsIm1hcmtlciIsImdldE1hcmtlciIsImRlbGV0ZSIsImlzTW9kaWZpZWQiLCJjdXJyZW50VGV4dCIsImdldFRleHRJbkJ1ZmZlclJhbmdlIiwiZ2V0QnVmZmVyUmFuZ2UiLCJ0ZXN0Il0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0lBRXFCQSxTLEdBQU4sTUFBTUEsU0FBTixDQUFnQjtBQUM3QkMsY0FBWUMsTUFBWixFQUFvQkMsTUFBcEIsRUFBNEI7QUFDMUIsU0FBS0QsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0MsTUFBTCxHQUFjQSxNQUFkO0FBQ0Q7O0FBRURDLGNBQVk7QUFDVixXQUFPLEtBQUtELE1BQVo7QUFDRDs7QUFFREUsV0FBUztBQUNQLHFDQUFlLEtBQUtELFNBQUwsRUFBZixFQUFpQyxLQUFLRixNQUF0QztBQUNEOztBQUVESSxlQUFhO0FBQ1gsVUFBTUMsY0FBYyxLQUFLTCxNQUFMLENBQVlNLG9CQUFaLENBQWlDLEtBQUtKLFNBQUwsR0FBaUJLLGNBQWpCLEVBQWpDLENBQXBCO0FBQ0EsV0FBTyxDQUFDLGtCQUFrQkMsSUFBbEIsQ0FBdUJILFdBQXZCLENBQVI7QUFDRDtBQWpCNEIsQztrQkFBVlAsUyIsImZpbGUiOiJzZXBhcmF0b3IuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7ZGVsZXRlTWFya2VySW59IGZyb20gJy4vbWFya2VyLXRvb2xzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU2VwYXJhdG9yIHtcbiAgY29uc3RydWN0b3IoZWRpdG9yLCBtYXJrZXIpIHtcbiAgICB0aGlzLmVkaXRvciA9IGVkaXRvcjtcbiAgICB0aGlzLm1hcmtlciA9IG1hcmtlcjtcbiAgfVxuXG4gIGdldE1hcmtlcigpIHtcbiAgICByZXR1cm4gdGhpcy5tYXJrZXI7XG4gIH1cblxuICBkZWxldGUoKSB7XG4gICAgZGVsZXRlTWFya2VySW4odGhpcy5nZXRNYXJrZXIoKSwgdGhpcy5lZGl0b3IpO1xuICB9XG5cbiAgaXNNb2RpZmllZCgpIHtcbiAgICBjb25zdCBjdXJyZW50VGV4dCA9IHRoaXMuZWRpdG9yLmdldFRleHRJbkJ1ZmZlclJhbmdlKHRoaXMuZ2V0TWFya2VyKCkuZ2V0QnVmZmVyUmFuZ2UoKSk7XG4gICAgcmV0dXJuICEvXj09PT09PT1cXHI/XFxuPyQvLnRlc3QoY3VycmVudFRleHQpO1xuICB9XG59XG4iXX0=