'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const UNBORN = {};

let Commit = class Commit {
  static createUnborn() {
    return new Commit('', '', UNBORN);
  }

  constructor(sha, message) {
    let unbornRef = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

    this.sha = sha;
    this.message = message.trim();
    this.unbornRef = unbornRef === UNBORN;
  }

  getSha() {
    return this.sha;
  }

  getMessage() {
    return this.message;
  }

  isUnbornRef() {
    return this.unbornRef;
  }

  isPresent() {
    return true;
  }
};
exports.default = Commit;
const nullCommit = exports.nullCommit = {
  getSha() {
    return '';
  },

  getMessage() {
    return '';
  },

  isUnbornRef() {
    return false;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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