'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class;

var _eventKit = require('event-kit');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _coreDecorators = require('core-decorators');

var _helpers = require('./helpers');

var _workdirCache = require('./models/workdir-cache');

var _workdirCache2 = _interopRequireDefault(_workdirCache);

var _workdirContext = require('./models/workdir-context');

var _workdirContext2 = _interopRequireDefault(_workdirContext);

var _workdirContextPool = require('./models/workdir-context-pool');

var _workdirContextPool2 = _interopRequireDefault(_workdirContextPool);

var _repository = require('./models/repository');

var _repository2 = _interopRequireDefault(_repository);

var _styleCalculator = require('./models/style-calculator');

var _styleCalculator2 = _interopRequireDefault(_styleCalculator);

var _rootController = require('./controllers/root-controller');

var _rootController2 = _interopRequireDefault(_rootController);

var _issueishPaneItem = require('./atom-items/issueish-pane-item');

var _issueishPaneItem2 = _interopRequireDefault(_issueishPaneItem);

var _stubItem = require('./atom-items/stub-item');

var _stubItem2 = _interopRequireDefault(_stubItem);

var _switchboard = require('./switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

var _yardstick = require('./yardstick');

var _yardstick2 = _interopRequireDefault(_yardstick);

var _gitTimingsView = require('./views/git-timings-view');

var _gitTimingsView2 = _interopRequireDefault(_gitTimingsView);

var _contextMenuInterceptor = require('./context-menu-interceptor');

var _contextMenuInterceptor2 = _interopRequireDefault(_contextMenuInterceptor);

var _asyncQueue = require('./async-queue');

var _asyncQueue2 = _interopRequireDefault(_asyncQueue);

var _workerManager = require('./worker-manager');

var _workerManager2 = _interopRequireDefault(_workerManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const defaultState = {};

let GithubPackage = (_class = class GithubPackage {
  constructor(workspace, project, commandRegistry, notificationManager, tooltips, styles, config, confirm, configDirPath, getLoadSettings) {
    this.workspace = workspace;
    this.project = project;
    this.commandRegistry = commandRegistry;
    this.notificationManager = notificationManager;
    this.tooltips = tooltips;
    this.config = config;
    this.styles = styles;
    this.configPath = _path2.default.join(configDirPath, 'github.cson');

    this.styleCalculator = new _styleCalculator2.default(this.styles, this.config);
    this.confirm = confirm;
    this.useLegacyPanels = !this.workspace.getLeftDock || this.config.get('github.useLegacyPanels');
    this.startOpen = false;
    this.activated = false;

    const criteria = {
      projectPathCount: this.project.getPaths().length,
      initPathCount: (getLoadSettings().initialPaths || []).length
    };

    this.activeContextQueue = new _asyncQueue2.default();
    this.guessedContext = _workdirContext2.default.guess(criteria);
    this.activeContext = this.guessedContext;
    this.workdirCache = new _workdirCache2.default();
    this.contextPool = new _workdirContextPool2.default({
      window,
      workspace,
      promptCallback: query => this.controller.promptForCredentials(query)
    });

    this.switchboard = new _switchboard2.default();

    // Handle events from all resident contexts.
    this.subscriptions = new _eventKit.CompositeDisposable(this.contextPool.onDidChangeWorkdirOrHead(context => {
      this.refreshAtomGitRepository(context.getWorkingDirectory());
    }), this.contextPool.onDidUpdateRepository(context => {
      this.switchboard.didUpdateRepository(context.getRepository());
    }), this.contextPool.onDidDestroyRepository(context => {
      if (context === this.activeContext) {
        this.setActiveContext(_workdirContext2.default.absent());
      }
    }), _contextMenuInterceptor2.default);

    this.setupYardstick();
  }

  setupYardstick() {
    const stagingSeries = ['stageLine', 'stageHunk', 'unstageLine', 'unstageHunk'];

    this.subscriptions.add(
    // Staging and unstaging operations
    this.switchboard.onDidBeginStageOperation(payload => {
      if (payload.stage && payload.line) {
        _yardstick2.default.begin('stageLine');
      } else if (payload.stage && payload.hunk) {
        _yardstick2.default.begin('stageHunk');
      } else if (payload.unstage && payload.line) {
        _yardstick2.default.begin('unstageLine');
      } else if (payload.unstage && payload.hunk) {
        _yardstick2.default.begin('unstageHunk');
      }
    }), this.switchboard.onDidUpdateRepository(() => {
      _yardstick2.default.mark(stagingSeries, 'update-repository');
    }), this.switchboard.onDidFinishRender(context => {
      if (context === 'RootController.showFilePatchForPath') {
        _yardstick2.default.finish(stagingSeries);
      }
    }),

    // Active context changes
    this.switchboard.onDidScheduleActiveContextUpdate(() => {
      _yardstick2.default.begin('activeContextChange');
    }), this.switchboard.onDidBeginActiveContextUpdate(() => {
      _yardstick2.default.mark('activeContextChange', 'queue-wait');
    }), this.switchboard.onDidFinishContextChangeRender(() => {
      _yardstick2.default.mark('activeContextChange', 'render');
    }), this.switchboard.onDidFinishActiveContextUpdate(() => {
      _yardstick2.default.finish('activeContextChange');
    }));
  }

  activate() {
    var _this = this;

    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return _asyncToGenerator(function* () {
      _this.savedState = _extends({}, defaultState, state);

      const firstRun = !(yield (0, _helpers.fileExists)(_this.configPath));
      _this.startOpen = firstRun && !_this.config.get('welcome.showOnStartup');
      if (firstRun) {
        yield (0, _helpers.writeFile)(_this.configPath, '# Store non-visible GitHub package state.\n');
      }

      _this.subscriptions.add(atom.config.onDidChange('github.useLegacyPanels', function (_ref) {
        let newValue = _ref.newValue;

        if (newValue) {
          _this.useLegacyPanels = true;
        } else {
          // Only use new docks if they exist
          _this.useLegacyPanels = !_this.workspace.getLeftDock;
        }

        _this.rerender();
      }), _this.project.onDidChangePaths(_this.scheduleActiveContextUpdate), _this.workspace.getCenter().onDidChangeActivePaneItem(_this.scheduleActiveContextUpdate), _this.styleCalculator.startWatching('github-package-styles', ['editor.fontSize', 'editor.fontFamily', 'editor.lineHeight'], function (config) {
        return `
          .github-FilePatchView {
            font-size: 1.1em;
          }

          .github-HunkView-line {
            font-size: ${config.get('editor.fontSize')}px;
            font-family: ${config.get('editor.fontFamily')};
            line-height: ${config.get('editor.lineHeight')};
          }
        `;
      }), _this.workspace.addOpener(function (uri) {
        if (uri === 'atom-github://debug/timings') {
          return _this.createGitTimingsView();
        } else {
          return null;
        }
      }), _this.workspace.addOpener(_issueishPaneItem2.default.opener));

      _this.activated = true;
      _this.scheduleActiveContextUpdate(_this.savedState);
      _this.rerender();
    })();
  }

  serialize() {
    const activeRepository = this.getActiveRepository();
    const activeRepositoryPath = activeRepository ? activeRepository.getWorkingDirectoryPath() : null;

    return {
      activeRepositoryPath,
      gitController: this.controller.serialize(),
      firstRun: false
    };
  }

  rerender(callback) {
    if (this.workspace.isDestroyed()) {
      return;
    }

    if (!this.activated) {
      return;
    }

    if (!this.element) {
      this.element = document.createElement('div');
      this.subscriptions.add(new _eventKit.Disposable(() => {
        _reactDom2.default.unmountComponentAtNode(this.element);
        delete this.element;
      }));
    }

    _reactDom2.default.render(_react2.default.createElement(_rootController2.default, {
      ref: c => {
        this.controller = c;
      },
      workspace: this.workspace,
      commandRegistry: this.commandRegistry,
      notificationManager: this.notificationManager,
      tooltips: this.tooltips,
      config: this.config,
      confirm: this.confirm,
      activeWorkingDirectory: this.getActiveWorkdir(),
      repository: this.getActiveRepository(),
      resolutionProgress: this.getActiveResolutionProgress(),
      statusBar: this.statusBar,
      savedState: this.savedState.gitController,
      createRepositoryForProjectPath: this.createRepositoryForProjectPath,
      cloneRepositoryForProjectPath: this.cloneRepositoryForProjectPath,
      switchboard: this.switchboard,
      useLegacyPanels: this.useLegacyPanels,
      startOpen: this.startOpen
    }), this.element, callback);
  }

  deactivate() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.subscriptions.dispose();
      _this2.contextPool.clear();
      _workerManager2.default.reset(true);
      if (_this2.guessedContext) {
        _this2.guessedContext.destroy();
        _this2.guessedContext = null;
      }
      yield _yardstick2.default.flush();
    })();
  }

  consumeStatusBar(statusBar) {
    this.statusBar = statusBar;
    this.rerender();
  }

  createGitTimingsView() {
    return _gitTimingsView2.default.createPaneItem();
  }

  createIssueishPaneItem(_ref2) {
    let uri = _ref2.uri;

    return _issueishPaneItem2.default.opener(uri);
  }

  createGitTabControllerStub() {
    return _stubItem2.default.create('git-tab-controller', {
      title: 'Git'
    });
  }

  createGithubTabControllerStub() {
    return _stubItem2.default.create('github-tab-controller', {
      title: 'GitHub (preview)'
    });
  }

  createRepositoryForProjectPath(projectPath) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      yield (0, _helpers.mkdirs)(projectPath);

      const repository = _this3.contextPool.add(projectPath).getRepository();
      yield repository.init();
      _this3.workdirCache.invalidate(projectPath);

      if (!_this3.project.contains(projectPath)) {
        _this3.project.addPath(projectPath);
      }

      yield _this3.scheduleActiveContextUpdate();
    })();
  }

  cloneRepositoryForProjectPath(remoteUrl, projectPath) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const context = _this4.contextPool.getContext(projectPath);
      const repository = context.isPresent() ? context.getRepository() : new _repository2.default(projectPath);

      yield repository.clone(remoteUrl);
      _this4.workdirCache.invalidate(projectPath);

      _this4.project.addPath(projectPath);

      yield _this4.scheduleActiveContextUpdate();
    })();
  }

  getActiveWorkdir() {
    return this.activeContext.getWorkingDirectory();
  }

  getActiveRepository() {
    return this.activeContext.getRepository();
  }

  getActiveResolutionProgress() {
    return this.activeContext.getResolutionProgress();
  }

  getContextPool() {
    return this.contextPool;
  }

  getSwitchboard() {
    return this.switchboard;
  }

  scheduleActiveContextUpdate() {
    var _this5 = this;

    let savedState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return _asyncToGenerator(function* () {
      _this5.switchboard.didScheduleActiveContextUpdate();
      yield _this5.activeContextQueue.push(_this5.updateActiveContext.bind(_this5, savedState), { parallel: false });
    })();
  }

  /**
   * Derive the git working directory context that should be used for the package's git operations based on the current
   * state of the Atom workspace. In priority, this prefers:
   *
   * - A git working directory that contains the active pane item in the workspace's center.
   * - A git working directory corresponding to a single Project.
   * - When initially activating the package, the working directory that was active when the package was last
   *   serialized.
   * - The current context, unchanged, which may be a `NullWorkdirContext`.
   *
   * First updates the pool of resident contexts to match all git working directories that correspond to open
   * projects and pane items.
   */
  getNextContext(savedState) {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      const workdirs = new Set((yield Promise.all(_this6.project.getPaths().map((() => {
        var _ref3 = _asyncToGenerator(function* (projectPath) {
          const workdir = yield _this6.workdirCache.find(projectPath);
          return workdir || projectPath;
        });

        return function (_x3) {
          return _ref3.apply(this, arguments);
        };
      })()))));

      const fromPaneItem = (() => {
        var _ref4 = _asyncToGenerator(function* (maybeItem) {
          const itemPath = pathForPaneItem(maybeItem);

          if (!itemPath) {
            return {};
          }

          const itemWorkdir = yield _this6.workdirCache.find(itemPath);

          if (itemWorkdir && !_this6.project.contains(itemPath)) {
            workdirs.add(itemWorkdir);
          }

          return { itemPath, itemWorkdir };
        });

        return function fromPaneItem(_x4) {
          return _ref4.apply(this, arguments);
        };
      })();

      const active = yield fromPaneItem(_this6.workspace.getCenter().getActivePaneItem());

      _this6.contextPool.set(workdirs, savedState);

      if (active.itemPath) {
        // Prefer an active item
        return _this6.contextPool.getContext(active.itemWorkdir || active.itemPath);
      }

      if (_this6.project.getPaths().length === 1) {
        // Single project
        const projectPath = _this6.project.getPaths()[0];
        const activeWorkingDir = yield _this6.workdirCache.find(projectPath);
        return _this6.contextPool.getContext(activeWorkingDir || projectPath);
      }

      if (_this6.project.getPaths().length === 0 && !_this6.activeContext.getRepository().isUndetermined()) {
        // No projects. Revert to the absent context unless we've guessed that more projects are on the way.
        return _workdirContext2.default.absent();
      }

      // Restore models from saved state. Will return a NullWorkdirContext if this path is not presently
      // resident in the pool.
      const savedWorkingDir = savedState.activeRepositoryPath;
      if (savedWorkingDir) {
        return _this6.contextPool.getContext(savedWorkingDir);
      }

      return _this6.activeContext;
    })();
  }

  setActiveContext(nextActiveContext) {
    if (nextActiveContext !== this.activeContext) {
      if (this.activeContext === this.guessedContext) {
        this.guessedContext.destroy();
        this.guessedContext = null;
      }
      this.activeContext = nextActiveContext;
      this.rerender(() => {
        this.switchboard.didFinishContextChangeRender();
        this.switchboard.didFinishActiveContextUpdate();
      });
    } else {
      this.switchboard.didFinishActiveContextUpdate();
    }
  }

  updateActiveContext() {
    var _this7 = this;

    let savedState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return _asyncToGenerator(function* () {
      if (_this7.workspace.isDestroyed()) {
        return;
      }

      _this7.switchboard.didBeginActiveContextUpdate();

      const nextActiveContext = yield _this7.getNextContext(savedState);
      _this7.setActiveContext(nextActiveContext);
    })();
  }

  refreshAtomGitRepository(workdir) {
    const atomGitRepo = this.project.getRepositories().find(repo => {
      return repo && _path2.default.normalize(repo.getWorkingDirectory()) === workdir;
    });
    return atomGitRepo ? atomGitRepo.refreshStatus() : Promise.resolve();
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'rerender', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'rerender'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'consumeStatusBar', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'consumeStatusBar'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createGitTimingsView', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createGitTimingsView'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createIssueishPaneItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createIssueishPaneItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createGitTabControllerStub', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createGitTabControllerStub'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createGithubTabControllerStub', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createGithubTabControllerStub'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'createRepositoryForProjectPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'createRepositoryForProjectPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cloneRepositoryForProjectPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cloneRepositoryForProjectPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'scheduleActiveContextUpdate', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'scheduleActiveContextUpdate'), _class.prototype)), _class);
exports.default = GithubPackage;


function pathForPaneItem(paneItem) {
  if (!paneItem) {
    return null;
  }

  // Likely GitHub package provided pane item
  if (typeof paneItem.getWorkingDirectory === 'function') {
    return paneItem.getWorkingDirectory();
  }

  // TextEditor-like
  if (typeof paneItem.getPath === 'function') {
    return paneItem.getPath();
  }

  // Oh well
  return null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdGh1Yi1wYWNrYWdlLmpzIl0sIm5hbWVzIjpbImRlZmF1bHRTdGF0ZSIsIkdpdGh1YlBhY2thZ2UiLCJjb25zdHJ1Y3RvciIsIndvcmtzcGFjZSIsInByb2plY3QiLCJjb21tYW5kUmVnaXN0cnkiLCJub3RpZmljYXRpb25NYW5hZ2VyIiwidG9vbHRpcHMiLCJzdHlsZXMiLCJjb25maWciLCJjb25maXJtIiwiY29uZmlnRGlyUGF0aCIsImdldExvYWRTZXR0aW5ncyIsImNvbmZpZ1BhdGgiLCJqb2luIiwic3R5bGVDYWxjdWxhdG9yIiwidXNlTGVnYWN5UGFuZWxzIiwiZ2V0TGVmdERvY2siLCJnZXQiLCJzdGFydE9wZW4iLCJhY3RpdmF0ZWQiLCJjcml0ZXJpYSIsInByb2plY3RQYXRoQ291bnQiLCJnZXRQYXRocyIsImxlbmd0aCIsImluaXRQYXRoQ291bnQiLCJpbml0aWFsUGF0aHMiLCJhY3RpdmVDb250ZXh0UXVldWUiLCJndWVzc2VkQ29udGV4dCIsImd1ZXNzIiwiYWN0aXZlQ29udGV4dCIsIndvcmtkaXJDYWNoZSIsImNvbnRleHRQb29sIiwid2luZG93IiwicHJvbXB0Q2FsbGJhY2siLCJxdWVyeSIsImNvbnRyb2xsZXIiLCJwcm9tcHRGb3JDcmVkZW50aWFscyIsInN3aXRjaGJvYXJkIiwic3Vic2NyaXB0aW9ucyIsIm9uRGlkQ2hhbmdlV29ya2Rpck9ySGVhZCIsImNvbnRleHQiLCJyZWZyZXNoQXRvbUdpdFJlcG9zaXRvcnkiLCJnZXRXb3JraW5nRGlyZWN0b3J5Iiwib25EaWRVcGRhdGVSZXBvc2l0b3J5IiwiZGlkVXBkYXRlUmVwb3NpdG9yeSIsImdldFJlcG9zaXRvcnkiLCJvbkRpZERlc3Ryb3lSZXBvc2l0b3J5Iiwic2V0QWN0aXZlQ29udGV4dCIsImFic2VudCIsInNldHVwWWFyZHN0aWNrIiwic3RhZ2luZ1NlcmllcyIsImFkZCIsIm9uRGlkQmVnaW5TdGFnZU9wZXJhdGlvbiIsInBheWxvYWQiLCJzdGFnZSIsImxpbmUiLCJiZWdpbiIsImh1bmsiLCJ1bnN0YWdlIiwibWFyayIsIm9uRGlkRmluaXNoUmVuZGVyIiwiZmluaXNoIiwib25EaWRTY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUiLCJvbkRpZEJlZ2luQWN0aXZlQ29udGV4dFVwZGF0ZSIsIm9uRGlkRmluaXNoQ29udGV4dENoYW5nZVJlbmRlciIsIm9uRGlkRmluaXNoQWN0aXZlQ29udGV4dFVwZGF0ZSIsImFjdGl2YXRlIiwic3RhdGUiLCJzYXZlZFN0YXRlIiwiZmlyc3RSdW4iLCJhdG9tIiwib25EaWRDaGFuZ2UiLCJuZXdWYWx1ZSIsInJlcmVuZGVyIiwib25EaWRDaGFuZ2VQYXRocyIsInNjaGVkdWxlQWN0aXZlQ29udGV4dFVwZGF0ZSIsImdldENlbnRlciIsIm9uRGlkQ2hhbmdlQWN0aXZlUGFuZUl0ZW0iLCJzdGFydFdhdGNoaW5nIiwiYWRkT3BlbmVyIiwidXJpIiwiY3JlYXRlR2l0VGltaW5nc1ZpZXciLCJvcGVuZXIiLCJzZXJpYWxpemUiLCJhY3RpdmVSZXBvc2l0b3J5IiwiZ2V0QWN0aXZlUmVwb3NpdG9yeSIsImFjdGl2ZVJlcG9zaXRvcnlQYXRoIiwiZ2V0V29ya2luZ0RpcmVjdG9yeVBhdGgiLCJnaXRDb250cm9sbGVyIiwiY2FsbGJhY2siLCJpc0Rlc3Ryb3llZCIsImVsZW1lbnQiLCJkb2N1bWVudCIsImNyZWF0ZUVsZW1lbnQiLCJ1bm1vdW50Q29tcG9uZW50QXROb2RlIiwicmVuZGVyIiwiYyIsImdldEFjdGl2ZVdvcmtkaXIiLCJnZXRBY3RpdmVSZXNvbHV0aW9uUHJvZ3Jlc3MiLCJzdGF0dXNCYXIiLCJjcmVhdGVSZXBvc2l0b3J5Rm9yUHJvamVjdFBhdGgiLCJjbG9uZVJlcG9zaXRvcnlGb3JQcm9qZWN0UGF0aCIsImRlYWN0aXZhdGUiLCJkaXNwb3NlIiwiY2xlYXIiLCJyZXNldCIsImRlc3Ryb3kiLCJmbHVzaCIsImNvbnN1bWVTdGF0dXNCYXIiLCJjcmVhdGVQYW5lSXRlbSIsImNyZWF0ZUlzc3VlaXNoUGFuZUl0ZW0iLCJjcmVhdGVHaXRUYWJDb250cm9sbGVyU3R1YiIsImNyZWF0ZSIsInRpdGxlIiwiY3JlYXRlR2l0aHViVGFiQ29udHJvbGxlclN0dWIiLCJwcm9qZWN0UGF0aCIsInJlcG9zaXRvcnkiLCJpbml0IiwiaW52YWxpZGF0ZSIsImNvbnRhaW5zIiwiYWRkUGF0aCIsInJlbW90ZVVybCIsImdldENvbnRleHQiLCJpc1ByZXNlbnQiLCJjbG9uZSIsImdldFJlc29sdXRpb25Qcm9ncmVzcyIsImdldENvbnRleHRQb29sIiwiZ2V0U3dpdGNoYm9hcmQiLCJkaWRTY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUiLCJwdXNoIiwidXBkYXRlQWN0aXZlQ29udGV4dCIsImJpbmQiLCJwYXJhbGxlbCIsImdldE5leHRDb250ZXh0Iiwid29ya2RpcnMiLCJTZXQiLCJQcm9taXNlIiwiYWxsIiwibWFwIiwid29ya2RpciIsImZpbmQiLCJmcm9tUGFuZUl0ZW0iLCJtYXliZUl0ZW0iLCJpdGVtUGF0aCIsInBhdGhGb3JQYW5lSXRlbSIsIml0ZW1Xb3JrZGlyIiwiYWN0aXZlIiwiZ2V0QWN0aXZlUGFuZUl0ZW0iLCJzZXQiLCJhY3RpdmVXb3JraW5nRGlyIiwiaXNVbmRldGVybWluZWQiLCJzYXZlZFdvcmtpbmdEaXIiLCJuZXh0QWN0aXZlQ29udGV4dCIsImRpZEZpbmlzaENvbnRleHRDaGFuZ2VSZW5kZXIiLCJkaWRGaW5pc2hBY3RpdmVDb250ZXh0VXBkYXRlIiwiZGlkQmVnaW5BY3RpdmVDb250ZXh0VXBkYXRlIiwiYXRvbUdpdFJlcG8iLCJnZXRSZXBvc2l0b3JpZXMiLCJyZXBvIiwibm9ybWFsaXplIiwicmVmcmVzaFN0YXR1cyIsInJlc29sdmUiLCJwYW5lSXRlbSIsImdldFBhdGgiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBQUE7O0FBRUE7Ozs7QUFFQTs7OztBQUNBOzs7O0FBQ0E7O0FBRUE7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUVBLE1BQU1BLGVBQWUsRUFBckI7O0lBR3FCQyxhLGFBQU4sTUFBTUEsYUFBTixDQUFvQjtBQUNqQ0MsY0FBWUMsU0FBWixFQUF1QkMsT0FBdkIsRUFBZ0NDLGVBQWhDLEVBQWlEQyxtQkFBakQsRUFBc0VDLFFBQXRFLEVBQWdGQyxNQUFoRixFQUF3RkMsTUFBeEYsRUFDSUMsT0FESixFQUNhQyxhQURiLEVBQzRCQyxlQUQ1QixFQUM2QztBQUMzQyxTQUFLVCxTQUFMLEdBQWlCQSxTQUFqQjtBQUNBLFNBQUtDLE9BQUwsR0FBZUEsT0FBZjtBQUNBLFNBQUtDLGVBQUwsR0FBdUJBLGVBQXZCO0FBQ0EsU0FBS0MsbUJBQUwsR0FBMkJBLG1CQUEzQjtBQUNBLFNBQUtDLFFBQUwsR0FBZ0JBLFFBQWhCO0FBQ0EsU0FBS0UsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0QsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0ssVUFBTCxHQUFrQixlQUFLQyxJQUFMLENBQVVILGFBQVYsRUFBeUIsYUFBekIsQ0FBbEI7O0FBRUEsU0FBS0ksZUFBTCxHQUF1Qiw4QkFBb0IsS0FBS1AsTUFBekIsRUFBaUMsS0FBS0MsTUFBdEMsQ0FBdkI7QUFDQSxTQUFLQyxPQUFMLEdBQWVBLE9BQWY7QUFDQSxTQUFLTSxlQUFMLEdBQXVCLENBQUMsS0FBS2IsU0FBTCxDQUFlYyxXQUFoQixJQUErQixLQUFLUixNQUFMLENBQVlTLEdBQVosQ0FBZ0Isd0JBQWhCLENBQXREO0FBQ0EsU0FBS0MsU0FBTCxHQUFpQixLQUFqQjtBQUNBLFNBQUtDLFNBQUwsR0FBaUIsS0FBakI7O0FBRUEsVUFBTUMsV0FBVztBQUNmQyx3QkFBa0IsS0FBS2xCLE9BQUwsQ0FBYW1CLFFBQWIsR0FBd0JDLE1BRDNCO0FBRWZDLHFCQUFlLENBQUNiLGtCQUFrQmMsWUFBbEIsSUFBa0MsRUFBbkMsRUFBdUNGO0FBRnZDLEtBQWpCOztBQUtBLFNBQUtHLGtCQUFMLEdBQTBCLDBCQUExQjtBQUNBLFNBQUtDLGNBQUwsR0FBc0IseUJBQWVDLEtBQWYsQ0FBcUJSLFFBQXJCLENBQXRCO0FBQ0EsU0FBS1MsYUFBTCxHQUFxQixLQUFLRixjQUExQjtBQUNBLFNBQUtHLFlBQUwsR0FBb0IsNEJBQXBCO0FBQ0EsU0FBS0MsV0FBTCxHQUFtQixpQ0FBdUI7QUFDeENDLFlBRHdDO0FBRXhDOUIsZUFGd0M7QUFHeEMrQixzQkFBZ0JDLFNBQVMsS0FBS0MsVUFBTCxDQUFnQkMsb0JBQWhCLENBQXFDRixLQUFyQztBQUhlLEtBQXZCLENBQW5COztBQU1BLFNBQUtHLFdBQUwsR0FBbUIsMkJBQW5COztBQUVBO0FBQ0EsU0FBS0MsYUFBTCxHQUFxQixrQ0FDbkIsS0FBS1AsV0FBTCxDQUFpQlEsd0JBQWpCLENBQTBDQyxXQUFXO0FBQ25ELFdBQUtDLHdCQUFMLENBQThCRCxRQUFRRSxtQkFBUixFQUE5QjtBQUNELEtBRkQsQ0FEbUIsRUFJbkIsS0FBS1gsV0FBTCxDQUFpQlkscUJBQWpCLENBQXVDSCxXQUFXO0FBQ2hELFdBQUtILFdBQUwsQ0FBaUJPLG1CQUFqQixDQUFxQ0osUUFBUUssYUFBUixFQUFyQztBQUNELEtBRkQsQ0FKbUIsRUFPbkIsS0FBS2QsV0FBTCxDQUFpQmUsc0JBQWpCLENBQXdDTixXQUFXO0FBQ2pELFVBQUlBLFlBQVksS0FBS1gsYUFBckIsRUFBb0M7QUFDbEMsYUFBS2tCLGdCQUFMLENBQXNCLHlCQUFlQyxNQUFmLEVBQXRCO0FBQ0Q7QUFDRixLQUpELENBUG1CLG1DQUFyQjs7QUFlQSxTQUFLQyxjQUFMO0FBQ0Q7O0FBRURBLG1CQUFpQjtBQUNmLFVBQU1DLGdCQUFnQixDQUFDLFdBQUQsRUFBYyxXQUFkLEVBQTJCLGFBQTNCLEVBQTBDLGFBQTFDLENBQXRCOztBQUVBLFNBQUtaLGFBQUwsQ0FBbUJhLEdBQW5CO0FBQ0U7QUFDQSxTQUFLZCxXQUFMLENBQWlCZSx3QkFBakIsQ0FBMENDLFdBQVc7QUFDbkQsVUFBSUEsUUFBUUMsS0FBUixJQUFpQkQsUUFBUUUsSUFBN0IsRUFBbUM7QUFDakMsNEJBQVVDLEtBQVYsQ0FBZ0IsV0FBaEI7QUFDRCxPQUZELE1BRU8sSUFBSUgsUUFBUUMsS0FBUixJQUFpQkQsUUFBUUksSUFBN0IsRUFBbUM7QUFDeEMsNEJBQVVELEtBQVYsQ0FBZ0IsV0FBaEI7QUFDRCxPQUZNLE1BRUEsSUFBSUgsUUFBUUssT0FBUixJQUFtQkwsUUFBUUUsSUFBL0IsRUFBcUM7QUFDMUMsNEJBQVVDLEtBQVYsQ0FBZ0IsYUFBaEI7QUFDRCxPQUZNLE1BRUEsSUFBSUgsUUFBUUssT0FBUixJQUFtQkwsUUFBUUksSUFBL0IsRUFBcUM7QUFDMUMsNEJBQVVELEtBQVYsQ0FBZ0IsYUFBaEI7QUFDRDtBQUNGLEtBVkQsQ0FGRixFQWFFLEtBQUtuQixXQUFMLENBQWlCTSxxQkFBakIsQ0FBdUMsTUFBTTtBQUMzQywwQkFBVWdCLElBQVYsQ0FBZVQsYUFBZixFQUE4QixtQkFBOUI7QUFDRCxLQUZELENBYkYsRUFnQkUsS0FBS2IsV0FBTCxDQUFpQnVCLGlCQUFqQixDQUFtQ3BCLFdBQVc7QUFDNUMsVUFBSUEsWUFBWSxxQ0FBaEIsRUFBdUQ7QUFDckQsNEJBQVVxQixNQUFWLENBQWlCWCxhQUFqQjtBQUNEO0FBQ0YsS0FKRCxDQWhCRjs7QUFzQkU7QUFDQSxTQUFLYixXQUFMLENBQWlCeUIsZ0NBQWpCLENBQWtELE1BQU07QUFDdEQsMEJBQVVOLEtBQVYsQ0FBZ0IscUJBQWhCO0FBQ0QsS0FGRCxDQXZCRixFQTBCRSxLQUFLbkIsV0FBTCxDQUFpQjBCLDZCQUFqQixDQUErQyxNQUFNO0FBQ25ELDBCQUFVSixJQUFWLENBQWUscUJBQWYsRUFBc0MsWUFBdEM7QUFDRCxLQUZELENBMUJGLEVBNkJFLEtBQUt0QixXQUFMLENBQWlCMkIsOEJBQWpCLENBQWdELE1BQU07QUFDcEQsMEJBQVVMLElBQVYsQ0FBZSxxQkFBZixFQUFzQyxRQUF0QztBQUNELEtBRkQsQ0E3QkYsRUFnQ0UsS0FBS3RCLFdBQUwsQ0FBaUI0Qiw4QkFBakIsQ0FBZ0QsTUFBTTtBQUNwRCwwQkFBVUosTUFBVixDQUFpQixxQkFBakI7QUFDRCxLQUZELENBaENGO0FBb0NEOztBQUVLSyxVQUFOLEdBQTJCO0FBQUE7O0FBQUEsUUFBWkMsS0FBWSx1RUFBSixFQUFJO0FBQUE7QUFDekIsWUFBS0MsVUFBTCxnQkFBc0JyRSxZQUF0QixFQUF1Q29FLEtBQXZDOztBQUVBLFlBQU1FLFdBQVcsRUFBQyxNQUFNLHlCQUFXLE1BQUt6RCxVQUFoQixDQUFQLENBQWpCO0FBQ0EsWUFBS00sU0FBTCxHQUFpQm1ELFlBQVksQ0FBQyxNQUFLN0QsTUFBTCxDQUFZUyxHQUFaLENBQWdCLHVCQUFoQixDQUE5QjtBQUNBLFVBQUlvRCxRQUFKLEVBQWM7QUFDWixjQUFNLHdCQUFVLE1BQUt6RCxVQUFmLEVBQTJCLDZDQUEzQixDQUFOO0FBQ0Q7O0FBRUQsWUFBSzBCLGFBQUwsQ0FBbUJhLEdBQW5CLENBQ0VtQixLQUFLOUQsTUFBTCxDQUFZK0QsV0FBWixDQUF3Qix3QkFBeEIsRUFBa0QsZ0JBQWdCO0FBQUEsWUFBZEMsUUFBYyxRQUFkQSxRQUFjOztBQUNoRSxZQUFJQSxRQUFKLEVBQWM7QUFDWixnQkFBS3pELGVBQUwsR0FBdUIsSUFBdkI7QUFDRCxTQUZELE1BRU87QUFDTDtBQUNBLGdCQUFLQSxlQUFMLEdBQXVCLENBQUMsTUFBS2IsU0FBTCxDQUFlYyxXQUF2QztBQUNEOztBQUVELGNBQUt5RCxRQUFMO0FBQ0QsT0FURCxDQURGLEVBV0UsTUFBS3RFLE9BQUwsQ0FBYXVFLGdCQUFiLENBQThCLE1BQUtDLDJCQUFuQyxDQVhGLEVBWUUsTUFBS3pFLFNBQUwsQ0FBZTBFLFNBQWYsR0FBMkJDLHlCQUEzQixDQUFxRCxNQUFLRiwyQkFBMUQsQ0FaRixFQWFFLE1BQUs3RCxlQUFMLENBQXFCZ0UsYUFBckIsQ0FDRSx1QkFERixFQUVFLENBQUMsaUJBQUQsRUFBb0IsbUJBQXBCLEVBQXlDLG1CQUF6QyxDQUZGLEVBR0U7QUFBQSxlQUFXOzs7Ozs7eUJBTU10RSxPQUFPUyxHQUFQLENBQVcsaUJBQVgsQ0FBOEI7MkJBQzVCVCxPQUFPUyxHQUFQLENBQVcsbUJBQVgsQ0FBZ0M7MkJBQ2hDVCxPQUFPUyxHQUFQLENBQVcsbUJBQVgsQ0FBZ0M7O1NBUm5EO0FBQUEsT0FIRixDQWJGLEVBNEJFLE1BQUtmLFNBQUwsQ0FBZTZFLFNBQWYsQ0FBeUIsZUFBTztBQUM5QixZQUFJQyxRQUFRLDZCQUFaLEVBQTJDO0FBQ3pDLGlCQUFPLE1BQUtDLG9CQUFMLEVBQVA7QUFDRCxTQUZELE1BRU87QUFDTCxpQkFBTyxJQUFQO0FBQ0Q7QUFDRixPQU5ELENBNUJGLEVBbUNFLE1BQUsvRSxTQUFMLENBQWU2RSxTQUFmLENBQXlCLDJCQUFpQkcsTUFBMUMsQ0FuQ0Y7O0FBc0NBLFlBQUsvRCxTQUFMLEdBQWlCLElBQWpCO0FBQ0EsWUFBS3dELDJCQUFMLENBQWlDLE1BQUtQLFVBQXRDO0FBQ0EsWUFBS0ssUUFBTDtBQWpEeUI7QUFrRDFCOztBQUVEVSxjQUFZO0FBQ1YsVUFBTUMsbUJBQW1CLEtBQUtDLG1CQUFMLEVBQXpCO0FBQ0EsVUFBTUMsdUJBQXVCRixtQkFBbUJBLGlCQUFpQkcsdUJBQWpCLEVBQW5CLEdBQWdFLElBQTdGOztBQUVBLFdBQU87QUFDTEQsMEJBREs7QUFFTEUscUJBQWUsS0FBS3JELFVBQUwsQ0FBZ0JnRCxTQUFoQixFQUZWO0FBR0xkLGdCQUFVO0FBSEwsS0FBUDtBQUtEOztBQUdESSxXQUFTZ0IsUUFBVCxFQUFtQjtBQUNqQixRQUFJLEtBQUt2RixTQUFMLENBQWV3RixXQUFmLEVBQUosRUFBa0M7QUFDaEM7QUFDRDs7QUFFRCxRQUFJLENBQUMsS0FBS3ZFLFNBQVYsRUFBcUI7QUFDbkI7QUFDRDs7QUFFRCxRQUFJLENBQUMsS0FBS3dFLE9BQVYsRUFBbUI7QUFDakIsV0FBS0EsT0FBTCxHQUFlQyxTQUFTQyxhQUFULENBQXVCLEtBQXZCLENBQWY7QUFDQSxXQUFLdkQsYUFBTCxDQUFtQmEsR0FBbkIsQ0FBdUIseUJBQWUsTUFBTTtBQUMxQywyQkFBUzJDLHNCQUFULENBQWdDLEtBQUtILE9BQXJDO0FBQ0EsZUFBTyxLQUFLQSxPQUFaO0FBQ0QsT0FIc0IsQ0FBdkI7QUFJRDs7QUFFRCx1QkFBU0ksTUFBVCxDQUNFO0FBQ0UsV0FBS0MsS0FBSztBQUFFLGFBQUs3RCxVQUFMLEdBQWtCNkQsQ0FBbEI7QUFBc0IsT0FEcEM7QUFFRSxpQkFBVyxLQUFLOUYsU0FGbEI7QUFHRSx1QkFBaUIsS0FBS0UsZUFIeEI7QUFJRSwyQkFBcUIsS0FBS0MsbUJBSjVCO0FBS0UsZ0JBQVUsS0FBS0MsUUFMakI7QUFNRSxjQUFRLEtBQUtFLE1BTmY7QUFPRSxlQUFTLEtBQUtDLE9BUGhCO0FBUUUsOEJBQXdCLEtBQUt3RixnQkFBTCxFQVIxQjtBQVNFLGtCQUFZLEtBQUtaLG1CQUFMLEVBVGQ7QUFVRSwwQkFBb0IsS0FBS2EsMkJBQUwsRUFWdEI7QUFXRSxpQkFBVyxLQUFLQyxTQVhsQjtBQVlFLGtCQUFZLEtBQUsvQixVQUFMLENBQWdCb0IsYUFaOUI7QUFhRSxzQ0FBZ0MsS0FBS1ksOEJBYnZDO0FBY0UscUNBQStCLEtBQUtDLDZCQWR0QztBQWVFLG1CQUFhLEtBQUtoRSxXQWZwQjtBQWdCRSx1QkFBaUIsS0FBS3RCLGVBaEJ4QjtBQWlCRSxpQkFBVyxLQUFLRztBQWpCbEIsTUFERixFQW1CTSxLQUFLeUUsT0FuQlgsRUFtQm9CRixRQW5CcEI7QUFxQkQ7O0FBRUthLFlBQU4sR0FBbUI7QUFBQTs7QUFBQTtBQUNqQixhQUFLaEUsYUFBTCxDQUFtQmlFLE9BQW5CO0FBQ0EsYUFBS3hFLFdBQUwsQ0FBaUJ5RSxLQUFqQjtBQUNBLDhCQUFjQyxLQUFkLENBQW9CLElBQXBCO0FBQ0EsVUFBSSxPQUFLOUUsY0FBVCxFQUF5QjtBQUN2QixlQUFLQSxjQUFMLENBQW9CK0UsT0FBcEI7QUFDQSxlQUFLL0UsY0FBTCxHQUFzQixJQUF0QjtBQUNEO0FBQ0QsWUFBTSxvQkFBVWdGLEtBQVYsRUFBTjtBQVJpQjtBQVNsQjs7QUFHREMsbUJBQWlCVCxTQUFqQixFQUE0QjtBQUMxQixTQUFLQSxTQUFMLEdBQWlCQSxTQUFqQjtBQUNBLFNBQUsxQixRQUFMO0FBQ0Q7O0FBR0RRLHlCQUF1QjtBQUNyQixXQUFPLHlCQUFlNEIsY0FBZixFQUFQO0FBQ0Q7O0FBR0RDLGdDQUE4QjtBQUFBLFFBQU45QixHQUFNLFNBQU5BLEdBQU07O0FBQzVCLFdBQU8sMkJBQWlCRSxNQUFqQixDQUF3QkYsR0FBeEIsQ0FBUDtBQUNEOztBQUdEK0IsK0JBQTZCO0FBQzNCLFdBQU8sbUJBQVNDLE1BQVQsQ0FBZ0Isb0JBQWhCLEVBQXNDO0FBQzNDQyxhQUFPO0FBRG9DLEtBQXRDLENBQVA7QUFHRDs7QUFHREMsa0NBQWdDO0FBQzlCLFdBQU8sbUJBQVNGLE1BQVQsQ0FBZ0IsdUJBQWhCLEVBQXlDO0FBQzlDQyxhQUFPO0FBRHVDLEtBQXpDLENBQVA7QUFHRDs7QUFHS2IsZ0NBQU4sQ0FBcUNlLFdBQXJDLEVBQWtEO0FBQUE7O0FBQUE7QUFDaEQsWUFBTSxxQkFBT0EsV0FBUCxDQUFOOztBQUVBLFlBQU1DLGFBQWEsT0FBS3JGLFdBQUwsQ0FBaUJvQixHQUFqQixDQUFxQmdFLFdBQXJCLEVBQWtDdEUsYUFBbEMsRUFBbkI7QUFDQSxZQUFNdUUsV0FBV0MsSUFBWCxFQUFOO0FBQ0EsYUFBS3ZGLFlBQUwsQ0FBa0J3RixVQUFsQixDQUE2QkgsV0FBN0I7O0FBRUEsVUFBSSxDQUFDLE9BQUtoSCxPQUFMLENBQWFvSCxRQUFiLENBQXNCSixXQUF0QixDQUFMLEVBQXlDO0FBQ3ZDLGVBQUtoSCxPQUFMLENBQWFxSCxPQUFiLENBQXFCTCxXQUFyQjtBQUNEOztBQUVELFlBQU0sT0FBS3hDLDJCQUFMLEVBQU47QUFYZ0Q7QUFZakQ7O0FBR0swQiwrQkFBTixDQUFvQ29CLFNBQXBDLEVBQStDTixXQUEvQyxFQUE0RDtBQUFBOztBQUFBO0FBQzFELFlBQU0zRSxVQUFVLE9BQUtULFdBQUwsQ0FBaUIyRixVQUFqQixDQUE0QlAsV0FBNUIsQ0FBaEI7QUFDQSxZQUFNQyxhQUFhNUUsUUFBUW1GLFNBQVIsS0FBc0JuRixRQUFRSyxhQUFSLEVBQXRCLEdBQWdELHlCQUFlc0UsV0FBZixDQUFuRTs7QUFFQSxZQUFNQyxXQUFXUSxLQUFYLENBQWlCSCxTQUFqQixDQUFOO0FBQ0EsYUFBSzNGLFlBQUwsQ0FBa0J3RixVQUFsQixDQUE2QkgsV0FBN0I7O0FBRUEsYUFBS2hILE9BQUwsQ0FBYXFILE9BQWIsQ0FBcUJMLFdBQXJCOztBQUVBLFlBQU0sT0FBS3hDLDJCQUFMLEVBQU47QUFUMEQ7QUFVM0Q7O0FBRURzQixxQkFBbUI7QUFDakIsV0FBTyxLQUFLcEUsYUFBTCxDQUFtQmEsbUJBQW5CLEVBQVA7QUFDRDs7QUFFRDJDLHdCQUFzQjtBQUNwQixXQUFPLEtBQUt4RCxhQUFMLENBQW1CZ0IsYUFBbkIsRUFBUDtBQUNEOztBQUVEcUQsZ0NBQThCO0FBQzVCLFdBQU8sS0FBS3JFLGFBQUwsQ0FBbUJnRyxxQkFBbkIsRUFBUDtBQUNEOztBQUVEQyxtQkFBaUI7QUFDZixXQUFPLEtBQUsvRixXQUFaO0FBQ0Q7O0FBRURnRyxtQkFBaUI7QUFDZixXQUFPLEtBQUsxRixXQUFaO0FBQ0Q7O0FBR0tzQyw2QkFBTixHQUFtRDtBQUFBOztBQUFBLFFBQWpCUCxVQUFpQix1RUFBSixFQUFJO0FBQUE7QUFDakQsYUFBSy9CLFdBQUwsQ0FBaUIyRiw4QkFBakI7QUFDQSxZQUFNLE9BQUt0RyxrQkFBTCxDQUF3QnVHLElBQXhCLENBQTZCLE9BQUtDLG1CQUFMLENBQXlCQyxJQUF6QixTQUFvQy9ELFVBQXBDLENBQTdCLEVBQThFLEVBQUNnRSxVQUFVLEtBQVgsRUFBOUUsQ0FBTjtBQUZpRDtBQUdsRDs7QUFFRDs7Ozs7Ozs7Ozs7OztBQWFNQyxnQkFBTixDQUFxQmpFLFVBQXJCLEVBQWlDO0FBQUE7O0FBQUE7QUFDL0IsWUFBTWtFLFdBQVcsSUFBSUMsR0FBSixFQUNmLE1BQU1DLFFBQVFDLEdBQVIsQ0FDSixPQUFLdEksT0FBTCxDQUFhbUIsUUFBYixHQUF3Qm9ILEdBQXhCO0FBQUEsc0NBQTRCLFdBQU12QixXQUFOLEVBQXFCO0FBQy9DLGdCQUFNd0IsVUFBVSxNQUFNLE9BQUs3RyxZQUFMLENBQWtCOEcsSUFBbEIsQ0FBdUJ6QixXQUF2QixDQUF0QjtBQUNBLGlCQUFPd0IsV0FBV3hCLFdBQWxCO0FBQ0QsU0FIRDs7QUFBQTtBQUFBO0FBQUE7QUFBQSxXQURJLENBRFMsRUFBakI7O0FBU0EsWUFBTTBCO0FBQUEsc0NBQWUsV0FBTUMsU0FBTixFQUFtQjtBQUN0QyxnQkFBTUMsV0FBV0MsZ0JBQWdCRixTQUFoQixDQUFqQjs7QUFFQSxjQUFJLENBQUNDLFFBQUwsRUFBZTtBQUNiLG1CQUFPLEVBQVA7QUFDRDs7QUFFRCxnQkFBTUUsY0FBYyxNQUFNLE9BQUtuSCxZQUFMLENBQWtCOEcsSUFBbEIsQ0FBdUJHLFFBQXZCLENBQTFCOztBQUVBLGNBQUlFLGVBQWUsQ0FBQyxPQUFLOUksT0FBTCxDQUFhb0gsUUFBYixDQUFzQndCLFFBQXRCLENBQXBCLEVBQXFEO0FBQ25EVCxxQkFBU25GLEdBQVQsQ0FBYThGLFdBQWI7QUFDRDs7QUFFRCxpQkFBTyxFQUFDRixRQUFELEVBQVdFLFdBQVgsRUFBUDtBQUNELFNBZEs7O0FBQUE7QUFBQTtBQUFBO0FBQUEsVUFBTjs7QUFnQkEsWUFBTUMsU0FBUyxNQUFNTCxhQUFhLE9BQUszSSxTQUFMLENBQWUwRSxTQUFmLEdBQTJCdUUsaUJBQTNCLEVBQWIsQ0FBckI7O0FBRUEsYUFBS3BILFdBQUwsQ0FBaUJxSCxHQUFqQixDQUFxQmQsUUFBckIsRUFBK0JsRSxVQUEvQjs7QUFFQSxVQUFJOEUsT0FBT0gsUUFBWCxFQUFxQjtBQUNuQjtBQUNBLGVBQU8sT0FBS2hILFdBQUwsQ0FBaUIyRixVQUFqQixDQUE0QndCLE9BQU9ELFdBQVAsSUFBc0JDLE9BQU9ILFFBQXpELENBQVA7QUFDRDs7QUFFRCxVQUFJLE9BQUs1SSxPQUFMLENBQWFtQixRQUFiLEdBQXdCQyxNQUF4QixLQUFtQyxDQUF2QyxFQUEwQztBQUN4QztBQUNBLGNBQU00RixjQUFjLE9BQUtoSCxPQUFMLENBQWFtQixRQUFiLEdBQXdCLENBQXhCLENBQXBCO0FBQ0EsY0FBTStILG1CQUFtQixNQUFNLE9BQUt2SCxZQUFMLENBQWtCOEcsSUFBbEIsQ0FBdUJ6QixXQUF2QixDQUEvQjtBQUNBLGVBQU8sT0FBS3BGLFdBQUwsQ0FBaUIyRixVQUFqQixDQUE0QjJCLG9CQUFvQmxDLFdBQWhELENBQVA7QUFDRDs7QUFFRCxVQUFJLE9BQUtoSCxPQUFMLENBQWFtQixRQUFiLEdBQXdCQyxNQUF4QixLQUFtQyxDQUFuQyxJQUF3QyxDQUFDLE9BQUtNLGFBQUwsQ0FBbUJnQixhQUFuQixHQUFtQ3lHLGNBQW5DLEVBQTdDLEVBQWtHO0FBQ2hHO0FBQ0EsZUFBTyx5QkFBZXRHLE1BQWYsRUFBUDtBQUNEOztBQUVEO0FBQ0E7QUFDQSxZQUFNdUcsa0JBQWtCbkYsV0FBV2tCLG9CQUFuQztBQUNBLFVBQUlpRSxlQUFKLEVBQXFCO0FBQ25CLGVBQU8sT0FBS3hILFdBQUwsQ0FBaUIyRixVQUFqQixDQUE0QjZCLGVBQTVCLENBQVA7QUFDRDs7QUFFRCxhQUFPLE9BQUsxSCxhQUFaO0FBdEQrQjtBQXVEaEM7O0FBRURrQixtQkFBaUJ5RyxpQkFBakIsRUFBb0M7QUFDbEMsUUFBSUEsc0JBQXNCLEtBQUszSCxhQUEvQixFQUE4QztBQUM1QyxVQUFJLEtBQUtBLGFBQUwsS0FBdUIsS0FBS0YsY0FBaEMsRUFBZ0Q7QUFDOUMsYUFBS0EsY0FBTCxDQUFvQitFLE9BQXBCO0FBQ0EsYUFBSy9FLGNBQUwsR0FBc0IsSUFBdEI7QUFDRDtBQUNELFdBQUtFLGFBQUwsR0FBcUIySCxpQkFBckI7QUFDQSxXQUFLL0UsUUFBTCxDQUFjLE1BQU07QUFDbEIsYUFBS3BDLFdBQUwsQ0FBaUJvSCw0QkFBakI7QUFDQSxhQUFLcEgsV0FBTCxDQUFpQnFILDRCQUFqQjtBQUNELE9BSEQ7QUFJRCxLQVZELE1BVU87QUFDTCxXQUFLckgsV0FBTCxDQUFpQnFILDRCQUFqQjtBQUNEO0FBQ0Y7O0FBRUt4QixxQkFBTixHQUEyQztBQUFBOztBQUFBLFFBQWpCOUQsVUFBaUIsdUVBQUosRUFBSTtBQUFBO0FBQ3pDLFVBQUksT0FBS2xFLFNBQUwsQ0FBZXdGLFdBQWYsRUFBSixFQUFrQztBQUNoQztBQUNEOztBQUVELGFBQUtyRCxXQUFMLENBQWlCc0gsMkJBQWpCOztBQUVBLFlBQU1ILG9CQUFvQixNQUFNLE9BQUtuQixjQUFMLENBQW9CakUsVUFBcEIsQ0FBaEM7QUFDQSxhQUFLckIsZ0JBQUwsQ0FBc0J5RyxpQkFBdEI7QUFSeUM7QUFTMUM7O0FBRUQvRywyQkFBeUJrRyxPQUF6QixFQUFrQztBQUNoQyxVQUFNaUIsY0FBYyxLQUFLekosT0FBTCxDQUFhMEosZUFBYixHQUErQmpCLElBQS9CLENBQW9Da0IsUUFBUTtBQUM5RCxhQUFPQSxRQUFRLGVBQUtDLFNBQUwsQ0FBZUQsS0FBS3BILG1CQUFMLEVBQWYsTUFBK0NpRyxPQUE5RDtBQUNELEtBRm1CLENBQXBCO0FBR0EsV0FBT2lCLGNBQWNBLFlBQVlJLGFBQVosRUFBZCxHQUE0Q3hCLFFBQVF5QixPQUFSLEVBQW5EO0FBQ0Q7QUE1WWdDLEM7a0JBQWRqSyxhOzs7QUErWXJCLFNBQVNnSixlQUFULENBQXlCa0IsUUFBekIsRUFBbUM7QUFDakMsTUFBSSxDQUFDQSxRQUFMLEVBQWU7QUFDYixXQUFPLElBQVA7QUFDRDs7QUFFRDtBQUNBLE1BQUksT0FBT0EsU0FBU3hILG1CQUFoQixLQUF3QyxVQUE1QyxFQUF3RDtBQUN0RCxXQUFPd0gsU0FBU3hILG1CQUFULEVBQVA7QUFDRDs7QUFFRDtBQUNBLE1BQUksT0FBT3dILFNBQVNDLE9BQWhCLEtBQTRCLFVBQWhDLEVBQTRDO0FBQzFDLFdBQU9ELFNBQVNDLE9BQVQsRUFBUDtBQUNEOztBQUVEO0FBQ0EsU0FBTyxJQUFQO0FBQ0QiLCJmaWxlIjoiZ2l0aHViLXBhY2thZ2UuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7Q29tcG9zaXRlRGlzcG9zYWJsZSwgRGlzcG9zYWJsZX0gZnJvbSAnZXZlbnQta2l0JztcblxuaW1wb3J0IHBhdGggZnJvbSAncGF0aCc7XG5cbmltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVhY3REb20gZnJvbSAncmVhY3QtZG9tJztcbmltcG9ydCB7YXV0b2JpbmR9IGZyb20gJ2NvcmUtZGVjb3JhdG9ycyc7XG5cbmltcG9ydCB7bWtkaXJzLCBmaWxlRXhpc3RzLCB3cml0ZUZpbGV9IGZyb20gJy4vaGVscGVycyc7XG5pbXBvcnQgV29ya2RpckNhY2hlIGZyb20gJy4vbW9kZWxzL3dvcmtkaXItY2FjaGUnO1xuaW1wb3J0IFdvcmtkaXJDb250ZXh0IGZyb20gJy4vbW9kZWxzL3dvcmtkaXItY29udGV4dCc7XG5pbXBvcnQgV29ya2RpckNvbnRleHRQb29sIGZyb20gJy4vbW9kZWxzL3dvcmtkaXItY29udGV4dC1wb29sJztcbmltcG9ydCBSZXBvc2l0b3J5IGZyb20gJy4vbW9kZWxzL3JlcG9zaXRvcnknO1xuaW1wb3J0IFN0eWxlQ2FsY3VsYXRvciBmcm9tICcuL21vZGVscy9zdHlsZS1jYWxjdWxhdG9yJztcbmltcG9ydCBSb290Q29udHJvbGxlciBmcm9tICcuL2NvbnRyb2xsZXJzL3Jvb3QtY29udHJvbGxlcic7XG5pbXBvcnQgSXNzdWVpc2hQYW5lSXRlbSBmcm9tICcuL2F0b20taXRlbXMvaXNzdWVpc2gtcGFuZS1pdGVtJztcbmltcG9ydCBTdHViSXRlbSBmcm9tICcuL2F0b20taXRlbXMvc3R1Yi1pdGVtJztcbmltcG9ydCBTd2l0Y2hib2FyZCBmcm9tICcuL3N3aXRjaGJvYXJkJztcbmltcG9ydCB5YXJkc3RpY2sgZnJvbSAnLi95YXJkc3RpY2snO1xuaW1wb3J0IEdpdFRpbWluZ3NWaWV3IGZyb20gJy4vdmlld3MvZ2l0LXRpbWluZ3Mtdmlldyc7XG5pbXBvcnQgQ29udGV4dE1lbnVJbnRlcmNlcHRvciBmcm9tICcuL2NvbnRleHQtbWVudS1pbnRlcmNlcHRvcic7XG5pbXBvcnQgQXN5bmNRdWV1ZSBmcm9tICcuL2FzeW5jLXF1ZXVlJztcbmltcG9ydCBXb3JrZXJNYW5hZ2VyIGZyb20gJy4vd29ya2VyLW1hbmFnZXInO1xuXG5jb25zdCBkZWZhdWx0U3RhdGUgPSB7XG59O1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBHaXRodWJQYWNrYWdlIHtcbiAgY29uc3RydWN0b3Iod29ya3NwYWNlLCBwcm9qZWN0LCBjb21tYW5kUmVnaXN0cnksIG5vdGlmaWNhdGlvbk1hbmFnZXIsIHRvb2x0aXBzLCBzdHlsZXMsIGNvbmZpZyxcbiAgICAgIGNvbmZpcm0sIGNvbmZpZ0RpclBhdGgsIGdldExvYWRTZXR0aW5ncykge1xuICAgIHRoaXMud29ya3NwYWNlID0gd29ya3NwYWNlO1xuICAgIHRoaXMucHJvamVjdCA9IHByb2plY3Q7XG4gICAgdGhpcy5jb21tYW5kUmVnaXN0cnkgPSBjb21tYW5kUmVnaXN0cnk7XG4gICAgdGhpcy5ub3RpZmljYXRpb25NYW5hZ2VyID0gbm90aWZpY2F0aW9uTWFuYWdlcjtcbiAgICB0aGlzLnRvb2x0aXBzID0gdG9vbHRpcHM7XG4gICAgdGhpcy5jb25maWcgPSBjb25maWc7XG4gICAgdGhpcy5zdHlsZXMgPSBzdHlsZXM7XG4gICAgdGhpcy5jb25maWdQYXRoID0gcGF0aC5qb2luKGNvbmZpZ0RpclBhdGgsICdnaXRodWIuY3NvbicpO1xuXG4gICAgdGhpcy5zdHlsZUNhbGN1bGF0b3IgPSBuZXcgU3R5bGVDYWxjdWxhdG9yKHRoaXMuc3R5bGVzLCB0aGlzLmNvbmZpZyk7XG4gICAgdGhpcy5jb25maXJtID0gY29uZmlybTtcbiAgICB0aGlzLnVzZUxlZ2FjeVBhbmVscyA9ICF0aGlzLndvcmtzcGFjZS5nZXRMZWZ0RG9jayB8fCB0aGlzLmNvbmZpZy5nZXQoJ2dpdGh1Yi51c2VMZWdhY3lQYW5lbHMnKTtcbiAgICB0aGlzLnN0YXJ0T3BlbiA9IGZhbHNlO1xuICAgIHRoaXMuYWN0aXZhdGVkID0gZmFsc2U7XG5cbiAgICBjb25zdCBjcml0ZXJpYSA9IHtcbiAgICAgIHByb2plY3RQYXRoQ291bnQ6IHRoaXMucHJvamVjdC5nZXRQYXRocygpLmxlbmd0aCxcbiAgICAgIGluaXRQYXRoQ291bnQ6IChnZXRMb2FkU2V0dGluZ3MoKS5pbml0aWFsUGF0aHMgfHwgW10pLmxlbmd0aCxcbiAgICB9O1xuXG4gICAgdGhpcy5hY3RpdmVDb250ZXh0UXVldWUgPSBuZXcgQXN5bmNRdWV1ZSgpO1xuICAgIHRoaXMuZ3Vlc3NlZENvbnRleHQgPSBXb3JrZGlyQ29udGV4dC5ndWVzcyhjcml0ZXJpYSk7XG4gICAgdGhpcy5hY3RpdmVDb250ZXh0ID0gdGhpcy5ndWVzc2VkQ29udGV4dDtcbiAgICB0aGlzLndvcmtkaXJDYWNoZSA9IG5ldyBXb3JrZGlyQ2FjaGUoKTtcbiAgICB0aGlzLmNvbnRleHRQb29sID0gbmV3IFdvcmtkaXJDb250ZXh0UG9vbCh7XG4gICAgICB3aW5kb3csXG4gICAgICB3b3Jrc3BhY2UsXG4gICAgICBwcm9tcHRDYWxsYmFjazogcXVlcnkgPT4gdGhpcy5jb250cm9sbGVyLnByb21wdEZvckNyZWRlbnRpYWxzKHF1ZXJ5KSxcbiAgICB9KTtcblxuICAgIHRoaXMuc3dpdGNoYm9hcmQgPSBuZXcgU3dpdGNoYm9hcmQoKTtcblxuICAgIC8vIEhhbmRsZSBldmVudHMgZnJvbSBhbGwgcmVzaWRlbnQgY29udGV4dHMuXG4gICAgdGhpcy5zdWJzY3JpcHRpb25zID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoXG4gICAgICB0aGlzLmNvbnRleHRQb29sLm9uRGlkQ2hhbmdlV29ya2Rpck9ySGVhZChjb250ZXh0ID0+IHtcbiAgICAgICAgdGhpcy5yZWZyZXNoQXRvbUdpdFJlcG9zaXRvcnkoY29udGV4dC5nZXRXb3JraW5nRGlyZWN0b3J5KCkpO1xuICAgICAgfSksXG4gICAgICB0aGlzLmNvbnRleHRQb29sLm9uRGlkVXBkYXRlUmVwb3NpdG9yeShjb250ZXh0ID0+IHtcbiAgICAgICAgdGhpcy5zd2l0Y2hib2FyZC5kaWRVcGRhdGVSZXBvc2l0b3J5KGNvbnRleHQuZ2V0UmVwb3NpdG9yeSgpKTtcbiAgICAgIH0pLFxuICAgICAgdGhpcy5jb250ZXh0UG9vbC5vbkRpZERlc3Ryb3lSZXBvc2l0b3J5KGNvbnRleHQgPT4ge1xuICAgICAgICBpZiAoY29udGV4dCA9PT0gdGhpcy5hY3RpdmVDb250ZXh0KSB7XG4gICAgICAgICAgdGhpcy5zZXRBY3RpdmVDb250ZXh0KFdvcmtkaXJDb250ZXh0LmFic2VudCgpKTtcbiAgICAgICAgfVxuICAgICAgfSksXG4gICAgICBDb250ZXh0TWVudUludGVyY2VwdG9yLFxuICAgICk7XG5cbiAgICB0aGlzLnNldHVwWWFyZHN0aWNrKCk7XG4gIH1cblxuICBzZXR1cFlhcmRzdGljaygpIHtcbiAgICBjb25zdCBzdGFnaW5nU2VyaWVzID0gWydzdGFnZUxpbmUnLCAnc3RhZ2VIdW5rJywgJ3Vuc3RhZ2VMaW5lJywgJ3Vuc3RhZ2VIdW5rJ107XG5cbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMuYWRkKFxuICAgICAgLy8gU3RhZ2luZyBhbmQgdW5zdGFnaW5nIG9wZXJhdGlvbnNcbiAgICAgIHRoaXMuc3dpdGNoYm9hcmQub25EaWRCZWdpblN0YWdlT3BlcmF0aW9uKHBheWxvYWQgPT4ge1xuICAgICAgICBpZiAocGF5bG9hZC5zdGFnZSAmJiBwYXlsb2FkLmxpbmUpIHtcbiAgICAgICAgICB5YXJkc3RpY2suYmVnaW4oJ3N0YWdlTGluZScpO1xuICAgICAgICB9IGVsc2UgaWYgKHBheWxvYWQuc3RhZ2UgJiYgcGF5bG9hZC5odW5rKSB7XG4gICAgICAgICAgeWFyZHN0aWNrLmJlZ2luKCdzdGFnZUh1bmsnKTtcbiAgICAgICAgfSBlbHNlIGlmIChwYXlsb2FkLnVuc3RhZ2UgJiYgcGF5bG9hZC5saW5lKSB7XG4gICAgICAgICAgeWFyZHN0aWNrLmJlZ2luKCd1bnN0YWdlTGluZScpO1xuICAgICAgICB9IGVsc2UgaWYgKHBheWxvYWQudW5zdGFnZSAmJiBwYXlsb2FkLmh1bmspIHtcbiAgICAgICAgICB5YXJkc3RpY2suYmVnaW4oJ3Vuc3RhZ2VIdW5rJyk7XG4gICAgICAgIH1cbiAgICAgIH0pLFxuICAgICAgdGhpcy5zd2l0Y2hib2FyZC5vbkRpZFVwZGF0ZVJlcG9zaXRvcnkoKCkgPT4ge1xuICAgICAgICB5YXJkc3RpY2subWFyayhzdGFnaW5nU2VyaWVzLCAndXBkYXRlLXJlcG9zaXRvcnknKTtcbiAgICAgIH0pLFxuICAgICAgdGhpcy5zd2l0Y2hib2FyZC5vbkRpZEZpbmlzaFJlbmRlcihjb250ZXh0ID0+IHtcbiAgICAgICAgaWYgKGNvbnRleHQgPT09ICdSb290Q29udHJvbGxlci5zaG93RmlsZVBhdGNoRm9yUGF0aCcpIHtcbiAgICAgICAgICB5YXJkc3RpY2suZmluaXNoKHN0YWdpbmdTZXJpZXMpO1xuICAgICAgICB9XG4gICAgICB9KSxcblxuICAgICAgLy8gQWN0aXZlIGNvbnRleHQgY2hhbmdlc1xuICAgICAgdGhpcy5zd2l0Y2hib2FyZC5vbkRpZFNjaGVkdWxlQWN0aXZlQ29udGV4dFVwZGF0ZSgoKSA9PiB7XG4gICAgICAgIHlhcmRzdGljay5iZWdpbignYWN0aXZlQ29udGV4dENoYW5nZScpO1xuICAgICAgfSksXG4gICAgICB0aGlzLnN3aXRjaGJvYXJkLm9uRGlkQmVnaW5BY3RpdmVDb250ZXh0VXBkYXRlKCgpID0+IHtcbiAgICAgICAgeWFyZHN0aWNrLm1hcmsoJ2FjdGl2ZUNvbnRleHRDaGFuZ2UnLCAncXVldWUtd2FpdCcpO1xuICAgICAgfSksXG4gICAgICB0aGlzLnN3aXRjaGJvYXJkLm9uRGlkRmluaXNoQ29udGV4dENoYW5nZVJlbmRlcigoKSA9PiB7XG4gICAgICAgIHlhcmRzdGljay5tYXJrKCdhY3RpdmVDb250ZXh0Q2hhbmdlJywgJ3JlbmRlcicpO1xuICAgICAgfSksXG4gICAgICB0aGlzLnN3aXRjaGJvYXJkLm9uRGlkRmluaXNoQWN0aXZlQ29udGV4dFVwZGF0ZSgoKSA9PiB7XG4gICAgICAgIHlhcmRzdGljay5maW5pc2goJ2FjdGl2ZUNvbnRleHRDaGFuZ2UnKTtcbiAgICAgIH0pLFxuICAgICk7XG4gIH1cblxuICBhc3luYyBhY3RpdmF0ZShzdGF0ZSA9IHt9KSB7XG4gICAgdGhpcy5zYXZlZFN0YXRlID0gey4uLmRlZmF1bHRTdGF0ZSwgLi4uc3RhdGV9O1xuXG4gICAgY29uc3QgZmlyc3RSdW4gPSAhYXdhaXQgZmlsZUV4aXN0cyh0aGlzLmNvbmZpZ1BhdGgpO1xuICAgIHRoaXMuc3RhcnRPcGVuID0gZmlyc3RSdW4gJiYgIXRoaXMuY29uZmlnLmdldCgnd2VsY29tZS5zaG93T25TdGFydHVwJyk7XG4gICAgaWYgKGZpcnN0UnVuKSB7XG4gICAgICBhd2FpdCB3cml0ZUZpbGUodGhpcy5jb25maWdQYXRoLCAnIyBTdG9yZSBub24tdmlzaWJsZSBHaXRIdWIgcGFja2FnZSBzdGF0ZS5cXG4nKTtcbiAgICB9XG5cbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMuYWRkKFxuICAgICAgYXRvbS5jb25maWcub25EaWRDaGFuZ2UoJ2dpdGh1Yi51c2VMZWdhY3lQYW5lbHMnLCAoe25ld1ZhbHVlfSkgPT4ge1xuICAgICAgICBpZiAobmV3VmFsdWUpIHtcbiAgICAgICAgICB0aGlzLnVzZUxlZ2FjeVBhbmVscyA9IHRydWU7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgLy8gT25seSB1c2UgbmV3IGRvY2tzIGlmIHRoZXkgZXhpc3RcbiAgICAgICAgICB0aGlzLnVzZUxlZ2FjeVBhbmVscyA9ICF0aGlzLndvcmtzcGFjZS5nZXRMZWZ0RG9jaztcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMucmVyZW5kZXIoKTtcbiAgICAgIH0pLFxuICAgICAgdGhpcy5wcm9qZWN0Lm9uRGlkQ2hhbmdlUGF0aHModGhpcy5zY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUpLFxuICAgICAgdGhpcy53b3Jrc3BhY2UuZ2V0Q2VudGVyKCkub25EaWRDaGFuZ2VBY3RpdmVQYW5lSXRlbSh0aGlzLnNjaGVkdWxlQWN0aXZlQ29udGV4dFVwZGF0ZSksXG4gICAgICB0aGlzLnN0eWxlQ2FsY3VsYXRvci5zdGFydFdhdGNoaW5nKFxuICAgICAgICAnZ2l0aHViLXBhY2thZ2Utc3R5bGVzJyxcbiAgICAgICAgWydlZGl0b3IuZm9udFNpemUnLCAnZWRpdG9yLmZvbnRGYW1pbHknLCAnZWRpdG9yLmxpbmVIZWlnaHQnXSxcbiAgICAgICAgY29uZmlnID0+IGBcbiAgICAgICAgICAuZ2l0aHViLUZpbGVQYXRjaFZpZXcge1xuICAgICAgICAgICAgZm9udC1zaXplOiAxLjFlbTtcbiAgICAgICAgICB9XG5cbiAgICAgICAgICAuZ2l0aHViLUh1bmtWaWV3LWxpbmUge1xuICAgICAgICAgICAgZm9udC1zaXplOiAke2NvbmZpZy5nZXQoJ2VkaXRvci5mb250U2l6ZScpfXB4O1xuICAgICAgICAgICAgZm9udC1mYW1pbHk6ICR7Y29uZmlnLmdldCgnZWRpdG9yLmZvbnRGYW1pbHknKX07XG4gICAgICAgICAgICBsaW5lLWhlaWdodDogJHtjb25maWcuZ2V0KCdlZGl0b3IubGluZUhlaWdodCcpfTtcbiAgICAgICAgICB9XG4gICAgICAgIGAsXG4gICAgICApLFxuICAgICAgdGhpcy53b3Jrc3BhY2UuYWRkT3BlbmVyKHVyaSA9PiB7XG4gICAgICAgIGlmICh1cmkgPT09ICdhdG9tLWdpdGh1YjovL2RlYnVnL3RpbWluZ3MnKSB7XG4gICAgICAgICAgcmV0dXJuIHRoaXMuY3JlYXRlR2l0VGltaW5nc1ZpZXcoKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgfVxuICAgICAgfSksXG4gICAgICB0aGlzLndvcmtzcGFjZS5hZGRPcGVuZXIoSXNzdWVpc2hQYW5lSXRlbS5vcGVuZXIpLFxuICAgICk7XG5cbiAgICB0aGlzLmFjdGl2YXRlZCA9IHRydWU7XG4gICAgdGhpcy5zY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUodGhpcy5zYXZlZFN0YXRlKTtcbiAgICB0aGlzLnJlcmVuZGVyKCk7XG4gIH1cblxuICBzZXJpYWxpemUoKSB7XG4gICAgY29uc3QgYWN0aXZlUmVwb3NpdG9yeSA9IHRoaXMuZ2V0QWN0aXZlUmVwb3NpdG9yeSgpO1xuICAgIGNvbnN0IGFjdGl2ZVJlcG9zaXRvcnlQYXRoID0gYWN0aXZlUmVwb3NpdG9yeSA/IGFjdGl2ZVJlcG9zaXRvcnkuZ2V0V29ya2luZ0RpcmVjdG9yeVBhdGgoKSA6IG51bGw7XG5cbiAgICByZXR1cm4ge1xuICAgICAgYWN0aXZlUmVwb3NpdG9yeVBhdGgsXG4gICAgICBnaXRDb250cm9sbGVyOiB0aGlzLmNvbnRyb2xsZXIuc2VyaWFsaXplKCksXG4gICAgICBmaXJzdFJ1bjogZmFsc2UsXG4gICAgfTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICByZXJlbmRlcihjYWxsYmFjaykge1xuICAgIGlmICh0aGlzLndvcmtzcGFjZS5pc0Rlc3Ryb3llZCgpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgaWYgKCF0aGlzLmFjdGl2YXRlZCkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGlmICghdGhpcy5lbGVtZW50KSB7XG4gICAgICB0aGlzLmVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4ge1xuICAgICAgICBSZWFjdERvbS51bm1vdW50Q29tcG9uZW50QXROb2RlKHRoaXMuZWxlbWVudCk7XG4gICAgICAgIGRlbGV0ZSB0aGlzLmVsZW1lbnQ7XG4gICAgICB9KSk7XG4gICAgfVxuXG4gICAgUmVhY3REb20ucmVuZGVyKFxuICAgICAgPFJvb3RDb250cm9sbGVyXG4gICAgICAgIHJlZj17YyA9PiB7IHRoaXMuY29udHJvbGxlciA9IGM7IH19XG4gICAgICAgIHdvcmtzcGFjZT17dGhpcy53b3Jrc3BhY2V9XG4gICAgICAgIGNvbW1hbmRSZWdpc3RyeT17dGhpcy5jb21tYW5kUmVnaXN0cnl9XG4gICAgICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI9e3RoaXMubm90aWZpY2F0aW9uTWFuYWdlcn1cbiAgICAgICAgdG9vbHRpcHM9e3RoaXMudG9vbHRpcHN9XG4gICAgICAgIGNvbmZpZz17dGhpcy5jb25maWd9XG4gICAgICAgIGNvbmZpcm09e3RoaXMuY29uZmlybX1cbiAgICAgICAgYWN0aXZlV29ya2luZ0RpcmVjdG9yeT17dGhpcy5nZXRBY3RpdmVXb3JrZGlyKCl9XG4gICAgICAgIHJlcG9zaXRvcnk9e3RoaXMuZ2V0QWN0aXZlUmVwb3NpdG9yeSgpfVxuICAgICAgICByZXNvbHV0aW9uUHJvZ3Jlc3M9e3RoaXMuZ2V0QWN0aXZlUmVzb2x1dGlvblByb2dyZXNzKCl9XG4gICAgICAgIHN0YXR1c0Jhcj17dGhpcy5zdGF0dXNCYXJ9XG4gICAgICAgIHNhdmVkU3RhdGU9e3RoaXMuc2F2ZWRTdGF0ZS5naXRDb250cm9sbGVyfVxuICAgICAgICBjcmVhdGVSZXBvc2l0b3J5Rm9yUHJvamVjdFBhdGg9e3RoaXMuY3JlYXRlUmVwb3NpdG9yeUZvclByb2plY3RQYXRofVxuICAgICAgICBjbG9uZVJlcG9zaXRvcnlGb3JQcm9qZWN0UGF0aD17dGhpcy5jbG9uZVJlcG9zaXRvcnlGb3JQcm9qZWN0UGF0aH1cbiAgICAgICAgc3dpdGNoYm9hcmQ9e3RoaXMuc3dpdGNoYm9hcmR9XG4gICAgICAgIHVzZUxlZ2FjeVBhbmVscz17dGhpcy51c2VMZWdhY3lQYW5lbHN9XG4gICAgICAgIHN0YXJ0T3Blbj17dGhpcy5zdGFydE9wZW59XG4gICAgICAvPiwgdGhpcy5lbGVtZW50LCBjYWxsYmFjayxcbiAgICApO1xuICB9XG5cbiAgYXN5bmMgZGVhY3RpdmF0ZSgpIHtcbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMuZGlzcG9zZSgpO1xuICAgIHRoaXMuY29udGV4dFBvb2wuY2xlYXIoKTtcbiAgICBXb3JrZXJNYW5hZ2VyLnJlc2V0KHRydWUpO1xuICAgIGlmICh0aGlzLmd1ZXNzZWRDb250ZXh0KSB7XG4gICAgICB0aGlzLmd1ZXNzZWRDb250ZXh0LmRlc3Ryb3koKTtcbiAgICAgIHRoaXMuZ3Vlc3NlZENvbnRleHQgPSBudWxsO1xuICAgIH1cbiAgICBhd2FpdCB5YXJkc3RpY2suZmx1c2goKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBjb25zdW1lU3RhdHVzQmFyKHN0YXR1c0Jhcikge1xuICAgIHRoaXMuc3RhdHVzQmFyID0gc3RhdHVzQmFyO1xuICAgIHRoaXMucmVyZW5kZXIoKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBjcmVhdGVHaXRUaW1pbmdzVmlldygpIHtcbiAgICByZXR1cm4gR2l0VGltaW5nc1ZpZXcuY3JlYXRlUGFuZUl0ZW0oKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBjcmVhdGVJc3N1ZWlzaFBhbmVJdGVtKHt1cml9KSB7XG4gICAgcmV0dXJuIElzc3VlaXNoUGFuZUl0ZW0ub3BlbmVyKHVyaSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgY3JlYXRlR2l0VGFiQ29udHJvbGxlclN0dWIoKSB7XG4gICAgcmV0dXJuIFN0dWJJdGVtLmNyZWF0ZSgnZ2l0LXRhYi1jb250cm9sbGVyJywge1xuICAgICAgdGl0bGU6ICdHaXQnLFxuICAgIH0pO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGNyZWF0ZUdpdGh1YlRhYkNvbnRyb2xsZXJTdHViKCkge1xuICAgIHJldHVybiBTdHViSXRlbS5jcmVhdGUoJ2dpdGh1Yi10YWItY29udHJvbGxlcicsIHtcbiAgICAgIHRpdGxlOiAnR2l0SHViIChwcmV2aWV3KScsXG4gICAgfSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgYXN5bmMgY3JlYXRlUmVwb3NpdG9yeUZvclByb2plY3RQYXRoKHByb2plY3RQYXRoKSB7XG4gICAgYXdhaXQgbWtkaXJzKHByb2plY3RQYXRoKTtcblxuICAgIGNvbnN0IHJlcG9zaXRvcnkgPSB0aGlzLmNvbnRleHRQb29sLmFkZChwcm9qZWN0UGF0aCkuZ2V0UmVwb3NpdG9yeSgpO1xuICAgIGF3YWl0IHJlcG9zaXRvcnkuaW5pdCgpO1xuICAgIHRoaXMud29ya2RpckNhY2hlLmludmFsaWRhdGUocHJvamVjdFBhdGgpO1xuXG4gICAgaWYgKCF0aGlzLnByb2plY3QuY29udGFpbnMocHJvamVjdFBhdGgpKSB7XG4gICAgICB0aGlzLnByb2plY3QuYWRkUGF0aChwcm9qZWN0UGF0aCk7XG4gICAgfVxuXG4gICAgYXdhaXQgdGhpcy5zY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUoKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBhc3luYyBjbG9uZVJlcG9zaXRvcnlGb3JQcm9qZWN0UGF0aChyZW1vdGVVcmwsIHByb2plY3RQYXRoKSB7XG4gICAgY29uc3QgY29udGV4dCA9IHRoaXMuY29udGV4dFBvb2wuZ2V0Q29udGV4dChwcm9qZWN0UGF0aCk7XG4gICAgY29uc3QgcmVwb3NpdG9yeSA9IGNvbnRleHQuaXNQcmVzZW50KCkgPyBjb250ZXh0LmdldFJlcG9zaXRvcnkoKSA6IG5ldyBSZXBvc2l0b3J5KHByb2plY3RQYXRoKTtcblxuICAgIGF3YWl0IHJlcG9zaXRvcnkuY2xvbmUocmVtb3RlVXJsKTtcbiAgICB0aGlzLndvcmtkaXJDYWNoZS5pbnZhbGlkYXRlKHByb2plY3RQYXRoKTtcblxuICAgIHRoaXMucHJvamVjdC5hZGRQYXRoKHByb2plY3RQYXRoKTtcblxuICAgIGF3YWl0IHRoaXMuc2NoZWR1bGVBY3RpdmVDb250ZXh0VXBkYXRlKCk7XG4gIH1cblxuICBnZXRBY3RpdmVXb3JrZGlyKCkge1xuICAgIHJldHVybiB0aGlzLmFjdGl2ZUNvbnRleHQuZ2V0V29ya2luZ0RpcmVjdG9yeSgpO1xuICB9XG5cbiAgZ2V0QWN0aXZlUmVwb3NpdG9yeSgpIHtcbiAgICByZXR1cm4gdGhpcy5hY3RpdmVDb250ZXh0LmdldFJlcG9zaXRvcnkoKTtcbiAgfVxuXG4gIGdldEFjdGl2ZVJlc29sdXRpb25Qcm9ncmVzcygpIHtcbiAgICByZXR1cm4gdGhpcy5hY3RpdmVDb250ZXh0LmdldFJlc29sdXRpb25Qcm9ncmVzcygpO1xuICB9XG5cbiAgZ2V0Q29udGV4dFBvb2woKSB7XG4gICAgcmV0dXJuIHRoaXMuY29udGV4dFBvb2w7XG4gIH1cblxuICBnZXRTd2l0Y2hib2FyZCgpIHtcbiAgICByZXR1cm4gdGhpcy5zd2l0Y2hib2FyZDtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBhc3luYyBzY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUoc2F2ZWRTdGF0ZSA9IHt9KSB7XG4gICAgdGhpcy5zd2l0Y2hib2FyZC5kaWRTY2hlZHVsZUFjdGl2ZUNvbnRleHRVcGRhdGUoKTtcbiAgICBhd2FpdCB0aGlzLmFjdGl2ZUNvbnRleHRRdWV1ZS5wdXNoKHRoaXMudXBkYXRlQWN0aXZlQ29udGV4dC5iaW5kKHRoaXMsIHNhdmVkU3RhdGUpLCB7cGFyYWxsZWw6IGZhbHNlfSk7XG4gIH1cblxuICAvKipcbiAgICogRGVyaXZlIHRoZSBnaXQgd29ya2luZyBkaXJlY3RvcnkgY29udGV4dCB0aGF0IHNob3VsZCBiZSB1c2VkIGZvciB0aGUgcGFja2FnZSdzIGdpdCBvcGVyYXRpb25zIGJhc2VkIG9uIHRoZSBjdXJyZW50XG4gICAqIHN0YXRlIG9mIHRoZSBBdG9tIHdvcmtzcGFjZS4gSW4gcHJpb3JpdHksIHRoaXMgcHJlZmVyczpcbiAgICpcbiAgICogLSBBIGdpdCB3b3JraW5nIGRpcmVjdG9yeSB0aGF0IGNvbnRhaW5zIHRoZSBhY3RpdmUgcGFuZSBpdGVtIGluIHRoZSB3b3Jrc3BhY2UncyBjZW50ZXIuXG4gICAqIC0gQSBnaXQgd29ya2luZyBkaXJlY3RvcnkgY29ycmVzcG9uZGluZyB0byBhIHNpbmdsZSBQcm9qZWN0LlxuICAgKiAtIFdoZW4gaW5pdGlhbGx5IGFjdGl2YXRpbmcgdGhlIHBhY2thZ2UsIHRoZSB3b3JraW5nIGRpcmVjdG9yeSB0aGF0IHdhcyBhY3RpdmUgd2hlbiB0aGUgcGFja2FnZSB3YXMgbGFzdFxuICAgKiAgIHNlcmlhbGl6ZWQuXG4gICAqIC0gVGhlIGN1cnJlbnQgY29udGV4dCwgdW5jaGFuZ2VkLCB3aGljaCBtYXkgYmUgYSBgTnVsbFdvcmtkaXJDb250ZXh0YC5cbiAgICpcbiAgICogRmlyc3QgdXBkYXRlcyB0aGUgcG9vbCBvZiByZXNpZGVudCBjb250ZXh0cyB0byBtYXRjaCBhbGwgZ2l0IHdvcmtpbmcgZGlyZWN0b3JpZXMgdGhhdCBjb3JyZXNwb25kIHRvIG9wZW5cbiAgICogcHJvamVjdHMgYW5kIHBhbmUgaXRlbXMuXG4gICAqL1xuICBhc3luYyBnZXROZXh0Q29udGV4dChzYXZlZFN0YXRlKSB7XG4gICAgY29uc3Qgd29ya2RpcnMgPSBuZXcgU2V0KFxuICAgICAgYXdhaXQgUHJvbWlzZS5hbGwoXG4gICAgICAgIHRoaXMucHJvamVjdC5nZXRQYXRocygpLm1hcChhc3luYyBwcm9qZWN0UGF0aCA9PiB7XG4gICAgICAgICAgY29uc3Qgd29ya2RpciA9IGF3YWl0IHRoaXMud29ya2RpckNhY2hlLmZpbmQocHJvamVjdFBhdGgpO1xuICAgICAgICAgIHJldHVybiB3b3JrZGlyIHx8IHByb2plY3RQYXRoO1xuICAgICAgICB9KSxcbiAgICAgICksXG4gICAgKTtcblxuICAgIGNvbnN0IGZyb21QYW5lSXRlbSA9IGFzeW5jIG1heWJlSXRlbSA9PiB7XG4gICAgICBjb25zdCBpdGVtUGF0aCA9IHBhdGhGb3JQYW5lSXRlbShtYXliZUl0ZW0pO1xuXG4gICAgICBpZiAoIWl0ZW1QYXRoKSB7XG4gICAgICAgIHJldHVybiB7fTtcbiAgICAgIH1cblxuICAgICAgY29uc3QgaXRlbVdvcmtkaXIgPSBhd2FpdCB0aGlzLndvcmtkaXJDYWNoZS5maW5kKGl0ZW1QYXRoKTtcblxuICAgICAgaWYgKGl0ZW1Xb3JrZGlyICYmICF0aGlzLnByb2plY3QuY29udGFpbnMoaXRlbVBhdGgpKSB7XG4gICAgICAgIHdvcmtkaXJzLmFkZChpdGVtV29ya2Rpcik7XG4gICAgICB9XG5cbiAgICAgIHJldHVybiB7aXRlbVBhdGgsIGl0ZW1Xb3JrZGlyfTtcbiAgICB9O1xuXG4gICAgY29uc3QgYWN0aXZlID0gYXdhaXQgZnJvbVBhbmVJdGVtKHRoaXMud29ya3NwYWNlLmdldENlbnRlcigpLmdldEFjdGl2ZVBhbmVJdGVtKCkpO1xuXG4gICAgdGhpcy5jb250ZXh0UG9vbC5zZXQod29ya2RpcnMsIHNhdmVkU3RhdGUpO1xuXG4gICAgaWYgKGFjdGl2ZS5pdGVtUGF0aCkge1xuICAgICAgLy8gUHJlZmVyIGFuIGFjdGl2ZSBpdGVtXG4gICAgICByZXR1cm4gdGhpcy5jb250ZXh0UG9vbC5nZXRDb250ZXh0KGFjdGl2ZS5pdGVtV29ya2RpciB8fCBhY3RpdmUuaXRlbVBhdGgpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb2plY3QuZ2V0UGF0aHMoKS5sZW5ndGggPT09IDEpIHtcbiAgICAgIC8vIFNpbmdsZSBwcm9qZWN0XG4gICAgICBjb25zdCBwcm9qZWN0UGF0aCA9IHRoaXMucHJvamVjdC5nZXRQYXRocygpWzBdO1xuICAgICAgY29uc3QgYWN0aXZlV29ya2luZ0RpciA9IGF3YWl0IHRoaXMud29ya2RpckNhY2hlLmZpbmQocHJvamVjdFBhdGgpO1xuICAgICAgcmV0dXJuIHRoaXMuY29udGV4dFBvb2wuZ2V0Q29udGV4dChhY3RpdmVXb3JraW5nRGlyIHx8IHByb2plY3RQYXRoKTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5wcm9qZWN0LmdldFBhdGhzKCkubGVuZ3RoID09PSAwICYmICF0aGlzLmFjdGl2ZUNvbnRleHQuZ2V0UmVwb3NpdG9yeSgpLmlzVW5kZXRlcm1pbmVkKCkpIHtcbiAgICAgIC8vIE5vIHByb2plY3RzLiBSZXZlcnQgdG8gdGhlIGFic2VudCBjb250ZXh0IHVubGVzcyB3ZSd2ZSBndWVzc2VkIHRoYXQgbW9yZSBwcm9qZWN0cyBhcmUgb24gdGhlIHdheS5cbiAgICAgIHJldHVybiBXb3JrZGlyQ29udGV4dC5hYnNlbnQoKTtcbiAgICB9XG5cbiAgICAvLyBSZXN0b3JlIG1vZGVscyBmcm9tIHNhdmVkIHN0YXRlLiBXaWxsIHJldHVybiBhIE51bGxXb3JrZGlyQ29udGV4dCBpZiB0aGlzIHBhdGggaXMgbm90IHByZXNlbnRseVxuICAgIC8vIHJlc2lkZW50IGluIHRoZSBwb29sLlxuICAgIGNvbnN0IHNhdmVkV29ya2luZ0RpciA9IHNhdmVkU3RhdGUuYWN0aXZlUmVwb3NpdG9yeVBhdGg7XG4gICAgaWYgKHNhdmVkV29ya2luZ0Rpcikge1xuICAgICAgcmV0dXJuIHRoaXMuY29udGV4dFBvb2wuZ2V0Q29udGV4dChzYXZlZFdvcmtpbmdEaXIpO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLmFjdGl2ZUNvbnRleHQ7XG4gIH1cblxuICBzZXRBY3RpdmVDb250ZXh0KG5leHRBY3RpdmVDb250ZXh0KSB7XG4gICAgaWYgKG5leHRBY3RpdmVDb250ZXh0ICE9PSB0aGlzLmFjdGl2ZUNvbnRleHQpIHtcbiAgICAgIGlmICh0aGlzLmFjdGl2ZUNvbnRleHQgPT09IHRoaXMuZ3Vlc3NlZENvbnRleHQpIHtcbiAgICAgICAgdGhpcy5ndWVzc2VkQ29udGV4dC5kZXN0cm95KCk7XG4gICAgICAgIHRoaXMuZ3Vlc3NlZENvbnRleHQgPSBudWxsO1xuICAgICAgfVxuICAgICAgdGhpcy5hY3RpdmVDb250ZXh0ID0gbmV4dEFjdGl2ZUNvbnRleHQ7XG4gICAgICB0aGlzLnJlcmVuZGVyKCgpID0+IHtcbiAgICAgICAgdGhpcy5zd2l0Y2hib2FyZC5kaWRGaW5pc2hDb250ZXh0Q2hhbmdlUmVuZGVyKCk7XG4gICAgICAgIHRoaXMuc3dpdGNoYm9hcmQuZGlkRmluaXNoQWN0aXZlQ29udGV4dFVwZGF0ZSgpO1xuICAgICAgfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuc3dpdGNoYm9hcmQuZGlkRmluaXNoQWN0aXZlQ29udGV4dFVwZGF0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIGFzeW5jIHVwZGF0ZUFjdGl2ZUNvbnRleHQoc2F2ZWRTdGF0ZSA9IHt9KSB7XG4gICAgaWYgKHRoaXMud29ya3NwYWNlLmlzRGVzdHJveWVkKCkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICB0aGlzLnN3aXRjaGJvYXJkLmRpZEJlZ2luQWN0aXZlQ29udGV4dFVwZGF0ZSgpO1xuXG4gICAgY29uc3QgbmV4dEFjdGl2ZUNvbnRleHQgPSBhd2FpdCB0aGlzLmdldE5leHRDb250ZXh0KHNhdmVkU3RhdGUpO1xuICAgIHRoaXMuc2V0QWN0aXZlQ29udGV4dChuZXh0QWN0aXZlQ29udGV4dCk7XG4gIH1cblxuICByZWZyZXNoQXRvbUdpdFJlcG9zaXRvcnkod29ya2Rpcikge1xuICAgIGNvbnN0IGF0b21HaXRSZXBvID0gdGhpcy5wcm9qZWN0LmdldFJlcG9zaXRvcmllcygpLmZpbmQocmVwbyA9PiB7XG4gICAgICByZXR1cm4gcmVwbyAmJiBwYXRoLm5vcm1hbGl6ZShyZXBvLmdldFdvcmtpbmdEaXJlY3RvcnkoKSkgPT09IHdvcmtkaXI7XG4gICAgfSk7XG4gICAgcmV0dXJuIGF0b21HaXRSZXBvID8gYXRvbUdpdFJlcG8ucmVmcmVzaFN0YXR1cygpIDogUHJvbWlzZS5yZXNvbHZlKCk7XG4gIH1cbn1cblxuZnVuY3Rpb24gcGF0aEZvclBhbmVJdGVtKHBhbmVJdGVtKSB7XG4gIGlmICghcGFuZUl0ZW0pIHtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuXG4gIC8vIExpa2VseSBHaXRIdWIgcGFja2FnZSBwcm92aWRlZCBwYW5lIGl0ZW1cbiAgaWYgKHR5cGVvZiBwYW5lSXRlbS5nZXRXb3JraW5nRGlyZWN0b3J5ID09PSAnZnVuY3Rpb24nKSB7XG4gICAgcmV0dXJuIHBhbmVJdGVtLmdldFdvcmtpbmdEaXJlY3RvcnkoKTtcbiAgfVxuXG4gIC8vIFRleHRFZGl0b3ItbGlrZVxuICBpZiAodHlwZW9mIHBhbmVJdGVtLmdldFBhdGggPT09ICdmdW5jdGlvbicpIHtcbiAgICByZXR1cm4gcGFuZUl0ZW0uZ2V0UGF0aCgpO1xuICB9XG5cbiAgLy8gT2ggd2VsbFxuICByZXR1cm4gbnVsbDtcbn1cbiJdfQ==