'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _dec, _class, _desc, _value, _class2, _class3, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _gitShellOutStrategy = require('../git-shell-out-strategy');

var _observeModel = require('../decorators/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _propTypes3 = require('../prop-types');

var _branchView = require('../views/branch-view');

var _branchView2 = _interopRequireDefault(_branchView);

var _branchMenuView = require('../views/branch-menu-view');

var _branchMenuView2 = _interopRequireDefault(_branchMenuView);

var _pushPullView = require('../views/push-pull-view');

var _pushPullView2 = _interopRequireDefault(_pushPullView);

var _pushPullMenuView = require('../views/push-pull-menu-view');

var _pushPullMenuView2 = _interopRequireDefault(_pushPullMenuView);

var _changedFilesCountView = require('../views/changed-files-count-view');

var _changedFilesCountView2 = _interopRequireDefault(_changedFilesCountView);

var _tooltip = require('../views/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _commands = require('../views/commands');

var _commands2 = _interopRequireDefault(_commands);

var _branch = require('../models/branch');

var _remote = require('../models/remote');

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _coreDecorators = require('core-decorators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let StatusBarTileController = (_dec = (0, _observeModel2.default)({
  getModel: props => props.repository,
  fetchData: repository => {
    return (0, _yubikiri2.default)({
      currentBranch: repository.getCurrentBranch(),
      branches: repository.getBranches(),
      statusesForChangedFiles: repository.getStatusesForChangedFiles(),
      currentRemote: (() => {
        var _ref = _asyncToGenerator(function* (query) {
          return repository.getRemoteForBranch((yield query.currentBranch).getName());
        });

        return function currentRemote(_x) {
          return _ref.apply(this, arguments);
        };
      })(),
      aheadCount: (() => {
        var _ref2 = _asyncToGenerator(function* (query) {
          return repository.getAheadCount((yield query.currentBranch).getName());
        });

        return function aheadCount(_x2) {
          return _ref2.apply(this, arguments);
        };
      })(),
      behindCount: (() => {
        var _ref3 = _asyncToGenerator(function* (query) {
          return repository.getBehindCount((yield query.currentBranch).getName());
        });

        return function behindCount(_x3) {
          return _ref3.apply(this, arguments);
        };
      })(),
      originExists: (() => {
        var _ref4 = _asyncToGenerator(function* () {
          const remotes = yield repository.getRemotes();
          return remotes.filter(function (remote) {
            return remote.getName() === 'origin';
          }).length > 0;
        });

        return function originExists() {
          return _ref4.apply(this, arguments);
        };
      })()
    });
  }
}), _dec(_class = (_class2 = (_temp = _class3 = class StatusBarTileController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      inProgress: false,
      pushInProgress: false,
      fetchInProgress: false
    };
  }

  getChangedFilesCount() {
    var _props$statusesForCha = this.props.statusesForChangedFiles;
    const stagedFiles = _props$statusesForCha.stagedFiles,
          unstagedFiles = _props$statusesForCha.unstagedFiles,
          mergeConflictFiles = _props$statusesForCha.mergeConflictFiles;

    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    let changedFilesCount, mergeConflictsPresent;
    if (this.props.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount();
      mergeConflictsPresent = Object.keys(this.props.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    const repoProps = {
      repository: this.props.repository,
      currentBranch: this.props.currentBranch,
      branches: this.props.branches,
      currentRemote: this.props.currentRemote,
      aheadCount: this.props.aheadCount,
      behindCount: this.props.behindCount,
      changedFilesCount,
      mergeConflictsPresent
    };

    return _react2.default.createElement(
      'div',
      { className: 'github-StatusBarTileController' },
      this.renderTiles(repoProps),
      _react2.default.createElement(_changedFilesCountView2.default, _extends({
        didClick: this.props.toggleGitTab
      }, repoProps))
    );
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    return _react2.default.createElement(
      'span',
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:fetch', callback: this.fetch }),
        _react2.default.createElement(_commands.Command, { command: 'github:pull', callback: this.pull }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:push',
          callback: () => this.push({ force: false, setUpstream: !this.props.currentRemote.isPresent() })
        }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:force-push',
          callback: () => this.push({ force: true, setUpstream: !this.props.currentRemote.isPresent() })
        })
      ),
      _react2.default.createElement(_branchView2.default, _extends({
        ref: e => {
          this.branchView = e;
        },
        workspace: this.props.workspace,
        checkout: this.checkout
      }, repoProps)),
      _react2.default.createElement(
        _tooltip2.default,
        {
          manager: this.props.tooltips,
          target: () => this.branchView,
          trigger: 'click',
          className: 'github-StatusBarTileController-tooltipMenu' },
        _react2.default.createElement(_branchMenuView2.default, _extends({
          workspace: this.props.workspace,
          notificationManager: this.props.notificationManager,
          commandRegistry: this.props.commandRegistry,
          checkout: this.checkout
        }, repoProps))
      ),
      _react2.default.createElement(_pushPullView2.default, _extends({
        ref: e => {
          this.pushPullView = e;
        },
        pushInProgress: this.state.pushInProgress,
        fetchInProgress: this.state.fetchInProgress
      }, repoProps)),
      _react2.default.createElement(
        _tooltip2.default,
        {
          manager: this.props.tooltips,
          target: () => this.pushPullView,
          trigger: 'click',
          className: 'github-StatusBarTileController-tooltipMenu' },
        _react2.default.createElement(_pushPullMenuView2.default, _extends({
          onMarkSpecialClick: this.handleOpenGitTimingsView,
          workspace: this.props.workspace,
          inProgress: this.state.inProgress,
          originExists: !!this.props.originExists,
          push: this.push,
          pull: this.pull,
          fetch: this.fetch
        }, repoProps))
      )
    );
  }

  handleOpenGitTimingsView(e) {
    e && e.preventDefault();
    this.props.workspace.open('atom-github://debug/timings');
  }

  setInProgressWhile(block) {
    var _this = this;

    var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { push: false, pull: false, fetch: false };

    let push = _ref5.push,
        pull = _ref5.pull,
        fetch = _ref5.fetch;

    return new Promise((resolve, reject) => {
      if (this.state.inProgress) {
        resolve();
        return;
      }

      this.setState({ inProgress: true, pushInProgress: push, fetchInProgress: pull || fetch }, _asyncToGenerator(function* () {
        try {
          yield block();
        } catch (e) {
          reject(e);
        } finally {
          _this.setState({ inProgress: false, pushInProgress: false, fetchInProgress: false }, resolve);
        }
      }));
    });
  }

  attemptGitOperation(operation) {
    var _this2 = this;

    let errorTransform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (error) {
      return { message: error.stdErr };
    };
    return _asyncToGenerator(function* () {
      const operationPromise = operation();
      try {
        return yield operationPromise;
      } catch (error) {
        if (!(error instanceof _gitShellOutStrategy.GitError)) {
          throw error;
        }

        var _errorTransform = errorTransform(error),
            _errorTransform$notif = _errorTransform.notificationMethod;

        const notificationMethod = _errorTransform$notif === undefined ? 'addError' : _errorTransform$notif,
              message = _errorTransform.message,
              description = _errorTransform.description;

        _this2.props.notificationManager[notificationMethod](message || 'Cannot complete remote interaction', { description, dismissable: true });
        return null;
      }
    })();
  }

  checkout(branchName, options) {
    return this.setInProgressWhile(() => this.props.repository.checkout(branchName, options));
  }

  push(_ref7) {
    var _this3 = this;

    let force = _ref7.force,
        setUpstream = _ref7.setUpstream;
    return _asyncToGenerator(function* () {
      yield _this3.attemptGitOperation(function () {
        return _this3.doPush({ force, setUpstream });
      }, function (error) {
        if (/rejected[\s\S]*failed to push/.test(error.stdErr)) {
          return {
            message: 'Push rejected',
            description: 'The tip of your current branch is behind its remote counterpart.' + ' Try pulling before pushing again. Or, to force push, hold `cmd` or `ctrl` while clicking.'
          };
        }

        return { message: 'Unable to push', description: `<pre>${error.stdErr}</pre>` };
      });
    })();
  }

  doPush(options) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      if (options.force) {
        const choice = _this4.props.confirm({
          message: 'Are you sure you want to force push?',
          detailedMessage: 'This operation could result in losing data on the remote.',
          buttons: ['Force Push', 'Cancel Push']
        });
        if (choice !== 0) {
          return;
        }
      }

      yield _this4.setInProgressWhile(function () {
        return _this4.props.repository.push(_this4.props.currentBranch.getName(), options);
      }, { push: true });
    })();
  }

  pull() {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      yield _this5.attemptGitOperation(function () {
        return _this5.doPull();
      }, function (error) {
        if (/error: Your local changes to the following files would be overwritten by merge/.test(error.stdErr)) {
          const lines = error.stdErr.split('\n');
          const files = lines.slice(3, lines.length - 3).map(function (l) {
            return `\`${l.trim()}\``;
          }).join('<br>');
          return {
            message: 'Pull aborted',
            description: 'Local changes to the following would be overwritten by merge:<br>' + files + '<br>Please commit your changes or stash them before you merge.'
          };
        } else if (/Automatic merge failed; fix conflicts and then commit the result./.test(error.stdOut)) {
          _this5.props.ensureGitTabVisible();
          return {
            notificationMethod: 'addWarning',
            message: 'Merge conflicts',
            description: `Your local changes conflicted with changes made on the remote branch. Resolve the conflicts
              with the Git panel and commit to continue.`
          };
        }

        return { message: 'Unable to pull', description: `<pre>${error.stdErr}</pre>` };
      });
    })();
  }

  doPull() {
    var _this6 = this;

    return _asyncToGenerator(function* () {
      yield _this6.setInProgressWhile(function () {
        return _this6.props.repository.pull(_this6.props.currentBranch.getName());
      }, { pull: true });
    })();
  }

  fetch() {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      yield _this7.attemptGitOperation(function () {
        return _this7.doFetch();
      }, function (error) {
        return {
          message: 'Unable to fetch',
          description: `<pre>${error.stdErr}</pre>`
        };
      });
    })();
  }

  doFetch() {
    var _this8 = this;

    return _asyncToGenerator(function* () {
      yield _this8.setInProgressWhile(function () {
        return _this8.props.repository.fetch(_this8.props.currentBranch.getName());
      }, { fetch: true });
    })();
  }
}, _class3.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  confirm: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.object.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  branches: _propTypes2.default.arrayOf(_propTypes3.BranchPropType).isRequired,
  currentRemote: _propTypes3.RemotePropType.isRequired,
  aheadCount: _propTypes2.default.number,
  behindCount: _propTypes2.default.number,
  statusesForChangedFiles: _propTypes2.default.object,
  originExists: _propTypes2.default.bool,
  toggleGitTab: _propTypes2.default.func,
  ensureGitTabVisible: _propTypes2.default.func
}, _class3.defaultProps = {
  currentBranch: _branch.nullBranch,
  branches: [],
  currentRemote: _remote.nullRemote,
  toggleGitTab: () => {}
}, _temp), (_applyDecoratedDescriptor(_class2.prototype, 'handleOpenGitTimingsView', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleOpenGitTimingsView'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'checkout', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'checkout'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'push', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'push'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'pull', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'pull'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'fetch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'fetch'), _class2.prototype)), _class2)) || _class);
exports.default = StatusBarTileController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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