'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp, _desc2, _value2, _class3;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _eventKit = require('event-kit');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _etchWrapper = require('../views/etch-wrapper');

var _etchWrapper2 = _interopRequireDefault(_etchWrapper);

var _statusBar = require('../views/status-bar');

var _statusBar2 = _interopRequireDefault(_statusBar);

var _panel = require('../views/panel');

var _panel2 = _interopRequireDefault(_panel);

var _paneItem = require('../views/pane-item');

var _paneItem2 = _interopRequireDefault(_paneItem);

var _dockItem = require('../views/dock-item');

var _dockItem2 = _interopRequireDefault(_dockItem);

var _resizer = require('../views/resizer');

var _resizer2 = _interopRequireDefault(_resizer);

var _tabs = require('../views/tabs');

var _tabs2 = _interopRequireDefault(_tabs);

var _cloneDialog = require('../views/clone-dialog');

var _cloneDialog2 = _interopRequireDefault(_cloneDialog);

var _openIssueishDialog = require('../views/open-issueish-dialog');

var _openIssueishDialog2 = _interopRequireDefault(_openIssueishDialog);

var _initDialog = require('../views/init-dialog');

var _initDialog2 = _interopRequireDefault(_initDialog);

var _credentialDialog = require('../views/credential-dialog');

var _credentialDialog2 = _interopRequireDefault(_credentialDialog);

var _commands = require('../views/commands');

var _commands2 = _interopRequireDefault(_commands);

var _githubTabController = require('./github-tab-controller');

var _githubTabController2 = _interopRequireDefault(_githubTabController);

var _filePatchController = require('./file-patch-controller');

var _filePatchController2 = _interopRequireDefault(_filePatchController);

var _gitTabController = require('./git-tab-controller');

var _gitTabController2 = _interopRequireDefault(_gitTabController);

var _statusBarTileController = require('./status-bar-tile-controller');

var _statusBarTileController2 = _interopRequireDefault(_statusBarTileController);

var _repositoryConflictController = require('./repository-conflict-controller');

var _repositoryConflictController2 = _interopRequireDefault(_repositoryConflictController);

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

var _modelStateRegistry = require('../models/model-state-registry');

var _modelStateRegistry2 = _interopRequireDefault(_modelStateRegistry);

var _conflict = require('../models/conflicts/conflict');

var _conflict2 = _interopRequireDefault(_conflict);

var _switchboard = require('../switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

var _helpers = require('../helpers');

var _gitShellOutStrategy = require('../git-shell-out-strategy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const nullFilePatchState = {
  filePath: null,
  filePatch: null,
  stagingStatus: 'unstaged',
  partiallyStaged: false
};

let RootController = (_class = (_temp = _class2 = class RootController extends _react2.default.Component {

  serialize() {
    return {
      gitTabActive: this.state.gitTabActive,
      githubTabActive: this.state.githubTabActive,
      panelSize: this.state.panelSize,
      activeTab: this.state.activeTab
    };
  }

  constructor(props, context) {
    var _this;

    _this = super(props, context);

    const renderGitTab = props.startOpen || (props.savedState.gitTabActive === undefined ? !this.props.useLegacyPanels : this.props.savedState.gitTabActive);
    const renderGitHubTab = props.startOpen || (props.savedState.githubTabActive === undefined ? !this.props.useLegacyPanels : this.props.savedState.githubTabActive);

    this.state = _extends({}, nullFilePatchState, {
      amending: false,
      gitTabActive: renderGitTab,
      githubTabActive: renderGitHubTab,
      panelSize: props.savedState.panelSize || 400,
      activeTab: props.savedState.activeTab || 0,
      cloneDialogActive: false,
      cloneDialogInProgress: false,
      initDialogActive: false,
      credentialDialogQuery: null
    });

    this.repositoryStateRegistry = new _modelStateRegistry2.default(RootController, {
      save: () => {
        return { amending: this.state.amending };
      },
      restore: function () {
        let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _this.setState({ amending: !!state.amending });
      }
    });

    this.subscriptions = new _eventKit.CompositeDisposable();

    this.repositoryObserver = new _modelObserver2.default({
      didUpdate: () => this.onRepoRefresh()
    });
    this.repositoryObserver.setActiveModel(props.repository);
    this.subscriptions.add(new _eventKit.Disposable(() => this.repositoryObserver.destroy()));

    this.gitTabTracker = new TabTracker('git', {
      useLegacyPanels: this.props.useLegacyPanels,
      getState: () => this.state.gitTabActive,
      setState: (value, _ref, callback) => {
        let activateTab = _ref.activateTab;

        const newState = { gitTabActive: value };
        if (activateTab) {
          newState.activeTab = 0;
        }
        this.setState(newState, callback);
      },
      getController: () => this.gitTabController,
      getDockItem: () => this.gitDockItem,
      getWorkspace: () => this.props.workspace
    });

    this.githubTabTracker = new TabTracker('github', {
      useLegacyPanels: this.props.useLegacyPanels,
      getState: () => this.state.githubTabActive,
      setState: (value, _ref2, callback) => {
        let activateTab = _ref2.activateTab;

        const newState = { githubTabActive: value };
        if (activateTab) {
          newState.activeTab = 1;
        }
        this.setState(newState, callback);
      },
      getController: () => this.githubTabController,
      getDockItem: () => this.githubDockItem,
      getWorkspace: () => this.props.workspace
    });
  }

  componentWillMount() {
    this.repositoryStateRegistry.setModel(this.props.repository);
  }

  componentWillReceiveProps(newProps) {
    this.repositoryObserver.setActiveModel(newProps.repository);
    this.repositoryStateRegistry.setModel(newProps.repository);

    this.gitTabTracker.useLegacyPanels = newProps.useLegacyPanels;
    this.githubTabTracker.useLegacyPanels = newProps.useLegacyPanels;
  }

  render() {
    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:show-waterfall-diagnostics', callback: this.showWaterfallDiagnostics }),
        _react2.default.createElement(_commands.Command, { command: 'github:open-issue-or-pull-request', callback: this.showOpenIssueishDialog }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-git-tab', callback: this.gitTabTracker.toggle }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-git-tab-focus', callback: this.gitTabTracker.toggleFocus }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-github-tab', callback: this.githubTabTracker.toggle }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-github-tab-focus', callback: this.githubTabTracker.toggleFocus }),
        _react2.default.createElement(_commands.Command, { command: 'github:clone', callback: this.openCloneDialog }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:view-unstaged-changes-for-current-file',
          callback: this.viewUnstagedChangesForCurrentFile
        }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:view-staged-changes-for-current-file',
          callback: this.viewStagedChangesForCurrentFile
        })
      ),
      this.renderStatusBarTile(),
      this.renderPanels(),
      this.state.filePath && this.state.filePatch ? this.renderFilePatchController() : null,
      this.renderInitDialog(),
      this.renderCloneDialog(),
      this.renderCredentialDialog(),
      this.renderOpenIssueishDialog(),
      this.renderRepositoryConflictController()
    );
  }

  renderStatusBarTile() {
    return _react2.default.createElement(
      _statusBar2.default,
      { statusBar: this.props.statusBar, onConsumeStatusBar: sb => this.onConsumeStatusBar(sb) },
      _react2.default.createElement(_statusBarTileController2.default, {
        workspace: this.props.workspace,
        repository: this.props.repository,
        commandRegistry: this.props.commandRegistry,
        notificationManager: this.props.notificationManager,
        tooltips: this.props.tooltips,
        confirm: this.props.confirm,
        toggleGitTab: this.gitTabTracker.toggle,
        ensureGitTabVisible: this.gitTabTracker.ensureVisible
      })
    );
  }

  renderPanels() {
    if (!this.props.useLegacyPanels) {
      const gitTab = this.state.gitTabActive && _react2.default.createElement(
        _dockItem2.default,
        {
          ref: c => {
            this.gitDockItem = c;
          },
          workspace: this.props.workspace,
          getItem: (_ref3) => {
            let subtree = _ref3.subtree;
            return subtree.getWrappedComponent();
          },
          onDidCloseItem: () => this.setState({ gitTabActive: false }),
          stubItemSelector: 'git-tab-controller',
          activate: this.props.startOpen },
        _react2.default.createElement(
          _etchWrapper2.default,
          {
            ref: c => {
              this.gitTabController = c;
            },
            className: 'github-PanelEtchWrapper',
            reattachDomNode: false },
          _react2.default.createElement(_gitTabController2.default, {
            workspace: this.props.workspace,
            commandRegistry: this.props.commandRegistry,
            notificationManager: this.props.notificationManager,
            repository: this.props.repository,
            initializeRepo: this.initializeRepo,
            resolutionProgress: this.props.resolutionProgress,
            isAmending: this.state.amending,
            didSelectFilePath: this.showFilePatchForPath,
            didDiveIntoFilePath: this.diveIntoFilePatchForPath,
            didSelectMergeConflictFile: this.showMergeConflictFileForPath,
            didDiveIntoMergeConflictPath: this.diveIntoMergeConflictFileForPath,
            showFilePatchForPath: this.showFilePatchForPath,
            didChangeAmending: this.didChangeAmending,
            focusFilePatchView: this.focusFilePatchView,
            ensureGitTab: this.gitTabTracker.ensureVisible,
            openFiles: this.openFiles,
            discardWorkDirChangesForPaths: this.discardWorkDirChangesForPaths,
            undoLastDiscard: this.undoLastDiscard,
            refreshResolutionProgress: this.refreshResolutionProgress
          })
        )
      );

      const githubTab = this.state.githubTabActive && _react2.default.createElement(
        _dockItem2.default,
        {
          ref: c => {
            this.githubDockItem = c;
          },
          workspace: this.props.workspace,
          onDidCloseItem: () => this.setState({ githubTabActive: false }),
          stubItemSelector: 'github-tab-controller' },
        _react2.default.createElement(_githubTabController2.default, {
          ref: c => {
            this.githubTabController = c;
          },
          repository: this.props.repository
        })
      );

      return _react2.default.createElement(
        'div',
        null,
        gitTab,
        githubTab
      );
    }

    return _react2.default.createElement(
      _panel2.default,
      {
        workspace: this.props.workspace,
        location: 'right',
        onDidClosePanel: () => this.setState({ gitTabActive: false, githubTabActive: false }),
        visible: !!this.state.gitTabActive || !!this.state.githubTabActive },
      _react2.default.createElement(
        _resizer2.default,
        {
          size: this.state.panelSize,
          onChange: this.handlePanelResize,
          className: 'github-PanelResizer' },
        _react2.default.createElement(
          _tabs2.default,
          { activeIndex: this.state.activeTab, onChange: this.handleChangeTab, className: 'sidebar-tabs' },
          _react2.default.createElement(
            _tabs2.default.Panel,
            { title: 'Git' },
            _react2.default.createElement(
              _etchWrapper2.default,
              {
                ref: c => {
                  this.gitTabController = c;
                },
                className: 'github-PanelEtchWrapper',
                reattachDomNode: false },
              _react2.default.createElement(_gitTabController2.default, {
                workspace: this.props.workspace,
                commandRegistry: this.props.commandRegistry,
                notificationManager: this.props.notificationManager,
                repository: this.props.repository,
                initializeRepo: this.initializeRepo,
                resolutionProgress: this.props.resolutionProgress,
                isAmending: this.state.amending,
                didSelectFilePath: this.showFilePatchForPath,
                didDiveIntoFilePath: this.diveIntoFilePatchForPath,
                didSelectMergeConflictFile: this.showMergeConflictFileForPath,
                didDiveIntoMergeConflictPath: this.diveIntoMergeConflictFileForPath,
                didChangeAmending: this.didChangeAmending,
                focusFilePatchView: this.focusFilePatchView,
                ensureGitTab: this.gitTabTracker.ensureVisible,
                openFiles: this.openFiles,
                discardWorkDirChangesForPaths: this.discardWorkDirChangesForPaths,
                undoLastDiscard: this.undoLastDiscard,
                refreshResolutionProgress: this.refreshResolutionProgress
              })
            )
          ),
          _react2.default.createElement(
            _tabs2.default.Panel,
            { title: 'GitHub (preview)' },
            _react2.default.createElement(_githubTabController2.default, {
              ref: c => {
                this.githubTabController = c;
              },
              repository: this.props.repository
            })
          )
        )
      )
    );
  }

  renderFilePatchController() {
    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:focus-diff-view', callback: this.focusFilePatchView })
      ),
      _react2.default.createElement(
        _paneItem2.default,
        {
          workspace: this.props.workspace,
          ref: c => {
            this.filePatchControllerPane = c;
          },
          onDidCloseItem: () => {
            this.setState(_extends({}, nullFilePatchState));
          } },
        _react2.default.createElement(_filePatchController2.default, {
          ref: c => {
            this.filePatchController = c;
          },
          activeWorkingDirectory: this.props.activeWorkingDirectory,
          repository: this.props.repository,
          commandRegistry: this.props.commandRegistry,
          tooltips: this.props.tooltips,
          filePatch: this.state.filePatch,
          stagingStatus: this.state.stagingStatus,
          isAmending: this.state.amending,
          isPartiallyStaged: this.state.partiallyStaged,
          onRepoRefresh: this.onRepoRefresh,
          didSurfaceFile: this.surfaceFromFileAtPath,
          didDiveIntoFilePath: this.diveIntoFilePatchForPath,
          quietlySelectItem: this.quietlySelectItem,
          openFiles: this.openFiles,
          discardLines: this.discardLines,
          undoLastDiscard: this.undoLastDiscard,
          switchboard: this.props.switchboard
        })
      )
    );
  }

  renderInitDialog() {
    if (!this.state.initDialogActive) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_initDialog2.default, {
        config: this.props.config,
        commandRegistry: this.props.commandRegistry,
        didAccept: this.acceptInit,
        didCancel: this.cancelInit
      })
    );
  }

  renderCloneDialog() {
    if (!this.state.cloneDialogActive) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_cloneDialog2.default, {
        config: this.props.config,
        commandRegistry: this.props.commandRegistry,
        didAccept: this.acceptClone,
        didCancel: this.cancelClone,
        inProgress: this.state.cloneDialogInProgress
      })
    );
  }

  renderOpenIssueishDialog() {
    if (!this.state.openIssueishDialogActive) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_openIssueishDialog2.default, {
        commandRegistry: this.props.commandRegistry,
        didAccept: this.acceptOpenIssueish,
        didCancel: this.cancelOpenIssueish
      })
    );
  }

  renderCredentialDialog() {
    if (this.state.credentialDialogQuery === null) {
      return null;
    }

    return _react2.default.createElement(
      _panel2.default,
      { workspace: this.props.workspace, location: 'modal' },
      _react2.default.createElement(_credentialDialog2.default, _extends({ commandRegistry: this.props.commandRegistry }, this.state.credentialDialogQuery))
    );
  }

  renderRepositoryConflictController() {
    if (!this.props.repository) {
      return null;
    }

    return _react2.default.createElement(_repositoryConflictController2.default, {
      workspace: this.props.workspace,
      repository: this.props.repository,
      resolutionProgress: this.props.resolutionProgress,
      refreshResolutionProgress: this.refreshResolutionProgress,
      commandRegistry: this.props.commandRegistry
    });
  }

  componentWillUnmount() {
    this.repositoryStateRegistry.save();
    this.subscriptions.dispose();
  }

  onConsumeStatusBar(statusBar) {
    if (statusBar.disableGitInfoTile) {
      statusBar.disableGitInfoTile();
    }
  }

  initializeRepo() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2.props.activeWorkingDirectory) {
        yield _this2.acceptInit(_this2.props.activeWorkingDirectory);
        return;
      }

      _this2.setState({ initDialogActive: true });
    })();
  }

  showOpenIssueishDialog() {
    this.setState({ openIssueishDialogActive: true });
  }

  showWaterfallDiagnostics() {
    this.props.workspace.open('atom-github://debug/timings');
  }

  acceptClone(remoteUrl, projectPath) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      _this3.setState({ cloneDialogInProgress: true });
      try {
        yield _this3.props.cloneRepositoryForProjectPath(remoteUrl, projectPath);
      } catch (e) {
        _this3.props.notificationManager.addError(`Unable to clone ${remoteUrl}`, { detail: e.stdErr, dismissable: true });
      } finally {
        _this3.setState({ cloneDialogInProgress: false, cloneDialogActive: false });
      }
    })();
  }

  cancelClone() {
    this.setState({ cloneDialogActive: false });
  }

  acceptInit(projectPath) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      try {
        yield _this4.props.createRepositoryForProjectPath(projectPath);
      } catch (e) {
        _this4.props.notificationManager.addError(`Unable to initialize git repository in ${projectPath}`, { detail: e.stdErr, dismissable: true });
      } finally {
        _this4.setState({ initDialogActive: false });
      }
    })();
  }

  cancelInit() {
    this.setState({ initDialogActive: false });
  }

  acceptOpenIssueish(_ref4) {
    let repoOwner = _ref4.repoOwner,
        repoName = _ref4.repoName,
        issueishNumber = _ref4.issueishNumber;

    const uri = `atom-github://issueish/https://api.github.com/${repoOwner}/${repoName}/${issueishNumber}`;
    this.setState({ openIssueishDialogActive: false });
    this.props.workspace.open(uri);
  }

  cancelOpenIssueish() {
    this.setState({ openIssueishDialogActive: false });
  }

  showFilePatchForPath(filePath, stagingStatus) {
    var _this5 = this;

    var _ref5 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    let activate = _ref5.activate,
        amending = _ref5.amending,
        lineNumber = _ref5.lineNumber;
    return _asyncToGenerator(function* () {
      if (!filePath) {
        return null;
      }
      const repository = _this5.props.repository;
      if (!repository) {
        return null;
      }

      const staged = stagingStatus === 'staged';
      const filePatch = yield repository.getFilePatchForPath(filePath, { staged, amending: staged && amending });
      const partiallyStaged = yield repository.isPartiallyStaged(filePath);
      return new Promise(function (resolve) {
        if (filePatch) {
          _this5.setState({ filePath, filePatch, stagingStatus, partiallyStaged }, function () {
            // TODO: can be better done w/ a prop?
            if (activate && _this5.filePatchControllerPane) {
              _this5.filePatchControllerPane.activate();
              if (lineNumber) {
                _this5.filePatchController.goToDiffLine(lineNumber);
              }
            }
            _this5.props.switchboard.didFinishRender('RootController.showFilePatchForPath');
            resolve();
          });
        } else {
          _this5.setState(_extends({}, nullFilePatchState), function () {
            _this5.props.switchboard.didFinishRender('RootController.showFilePatchForPath');
            resolve();
          });
        }
      });
    })();
  }

  diveIntoFilePatchForPath(filePath, stagingStatus) {
    var _this6 = this;

    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    return _asyncToGenerator(function* () {
      yield _this6.showFilePatchForPath(filePath, stagingStatus, _extends({}, options, { activate: true }));
      _this6.focusFilePatchView();
    })();
  }

  surfaceFromFileAtPath(filePath, stagingStatus) {
    if (this.gitTabController) {
      this.gitTabController.getWrappedComponent().focusAndSelectStagingItem(filePath, stagingStatus);
    }
  }

  onRepoRefresh() {
    return this.showFilePatchForPath(this.state.filePath, this.state.stagingStatus, { amending: this.state.amending });
  }

  showMergeConflictFileForPath(relativeFilePath) {
    var _this7 = this;

    var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    let focus = _ref6.focus;
    return _asyncToGenerator(function* () {
      const absolutePath = _path2.default.join(_this7.props.repository.getWorkingDirectoryPath(), relativeFilePath);
      if (yield new _atom.File(absolutePath).exists()) {
        return _this7.props.workspace.open(absolutePath, { activatePane: Boolean(focus), pending: true });
      } else {
        _this7.props.notificationManager.addInfo('File has been deleted.');
        return null;
      }
    })();
  }

  diveIntoMergeConflictFileForPath(relativeFilePath) {
    return this.showMergeConflictFileForPath(relativeFilePath, { focus: true });
  }

  didChangeAmending(isAmending) {
    this.setState({ amending: isAmending });
    return this.showFilePatchForPath(this.state.filePath, this.state.stagingStatus, { amending: isAmending });
  }

  openCloneDialog() {
    this.setState({ cloneDialogActive: true });
  }

  handlePanelResize(size) {
    this.setState({
      panelSize: Math.max(size, 300)
    });
  }

  handleChangeTab(activeTab) {
    this.setState({ activeTab });
  }

  quietlySelectItem(filePath, stagingStatus) {
    if (this.gitTabController) {
      return this.gitTabController.getWrappedComponent().quietlySelectItem(filePath, stagingStatus);
    } else {
      return null;
    }
  }

  focusFilePatchView() {
    const item = this.filePatchControllerPane.getPaneItem();
    const viewElement = item.getElement().querySelector('[tabindex]');
    viewElement.focus();
  }

  viewChangesForCurrentFile(stagingStatus) {
    const editor = this.props.workspace.getActiveTextEditor();
    const absFilePath = editor.getPath();
    const repoPath = this.props.repository.getWorkingDirectoryPath();
    if (absFilePath.startsWith(repoPath)) {
      const filePath = absFilePath.slice(repoPath.length + 1);
      this.quietlySelectItem(filePath, stagingStatus);
      const splitDirection = this.props.config.get('github.viewChangesForCurrentFileDiffPaneSplitDirection');
      const pane = atom.workspace.getActivePane();
      if (splitDirection === 'right') {
        pane.splitRight();
      } else if (splitDirection === 'down') {
        pane.splitDown();
      }
      return this.diveIntoFilePatchForPath(filePath, stagingStatus, {
        lineNumber: editor.getCursorBufferPosition().row + 1,
        amending: stagingStatus === 'staged' && this.state.isAmending
      });
    } else {
      throw new Error(`${absFilePath} does not belong to repo ${repoPath}`);
    }
  }

  viewUnstagedChangesForCurrentFile() {
    this.viewChangesForCurrentFile('unstaged');
  }

  viewStagedChangesForCurrentFile() {
    this.viewChangesForCurrentFile('staged');
  }

  goToDiffLine(lineNumber) {
    return this.filePatchController.goToDiffLine(lineNumber);
  }

  openFiles(filePaths) {
    return Promise.all(filePaths.map(filePath => {
      const absolutePath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), filePath);
      return this.props.workspace.open(absolutePath, { pending: filePaths.length === 1 });
    }));
  }

  getUnsavedFiles(filePaths) {
    const isModifiedByPath = new Map();
    this.props.workspace.getTextEditors().forEach(editor => {
      isModifiedByPath.set(editor.getPath(), editor.isModified());
    });
    return filePaths.filter(filePath => {
      const absFilePath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), filePath);
      return isModifiedByPath.get(absFilePath);
    });
  }

  ensureNoUnsavedFiles(filePaths, message) {
    const unsavedFiles = this.getUnsavedFiles(filePaths).map(filePath => `\`${filePath}\``).join('<br>');
    if (unsavedFiles.length) {
      this.props.notificationManager.addError(message, {
        description: `You have unsaved changes in:<br>${unsavedFiles}.`,
        dismissable: true
      });
      return false;
    } else {
      return true;
    }
  }

  discardWorkDirChangesForPaths(filePaths) {
    var _this8 = this;

    return _asyncToGenerator(function* () {
      const destructiveAction = function () {
        return _this8.props.repository.discardWorkDirChangesForPaths(filePaths);
      };
      return yield _this8.props.repository.storeBeforeAndAfterBlobs(filePaths, function () {
        return _this8.ensureNoUnsavedFiles(filePaths, 'Cannot discard changes in selected files.');
      }, destructiveAction);
    })();
  }

  discardLines(lines) {
    var _this9 = this;

    return _asyncToGenerator(function* () {
      const filePath = _this9.state.filePatch.getPath();
      const filePatch = _this9.state.filePatch;
      const destructiveAction = (() => {
        var _ref7 = _asyncToGenerator(function* () {
          const discardFilePatch = filePatch.getUnstagePatchForLines(lines);
          yield _this9.props.repository.applyPatchToWorkdir(discardFilePatch);
        });

        return function destructiveAction() {
          return _ref7.apply(this, arguments);
        };
      })();
      return yield _this9.props.repository.storeBeforeAndAfterBlobs([filePath], function () {
        return _this9.ensureNoUnsavedFiles([filePath], 'Cannot discard lines.');
      }, destructiveAction, filePath);
    })();
  }

  getFilePathsForLastDiscard() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    let lastSnapshots = this.props.repository.getLastHistorySnapshots(partialDiscardFilePath);
    if (partialDiscardFilePath) {
      lastSnapshots = lastSnapshots ? [lastSnapshots] : [];
    }
    return lastSnapshots.map(snapshot => snapshot.filePath);
  }

  undoLastDiscard() {
    var _this10 = this;

    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    return _asyncToGenerator(function* () {
      const filePaths = _this10.getFilePathsForLastDiscard(partialDiscardFilePath);
      try {
        const results = yield _this10.props.repository.restoreLastDiscardInTempFiles(function () {
          return _this10.ensureNoUnsavedFiles(filePaths, 'Cannot undo last discard.');
        }, partialDiscardFilePath);
        if (results.length === 0) {
          return;
        }
        yield _this10.proceedOrPromptBasedOnResults(results, partialDiscardFilePath);
      } catch (e) {
        if (e instanceof _gitShellOutStrategy.GitError && e.stdErr.match(/fatal: Not a valid object name/)) {
          _this10.cleanUpHistoryForFilePaths(filePaths, partialDiscardFilePath);
        } else {
          // eslint-disable-next-line no-console
          console.error(e);
        }
      }
    })();
  }

  proceedOrPromptBasedOnResults(results) {
    var _this11 = this;

    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _asyncToGenerator(function* () {
      const conflicts = results.filter(function (_ref8) {
        let conflict = _ref8.conflict;
        return conflict;
      });
      if (conflicts.length === 0) {
        yield _this11.proceedWithLastDiscardUndo(results, partialDiscardFilePath);
      } else {
        yield _this11.promptAboutConflicts(results, conflicts, partialDiscardFilePath);
      }
    })();
  }

  promptAboutConflicts(results, conflicts) {
    var _this12 = this;

    let partialDiscardFilePath = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    return _asyncToGenerator(function* () {
      const conflictedFiles = conflicts.map(function (_ref9) {
        let filePath = _ref9.filePath;
        return `\t${filePath}`;
      }).join('\n');
      const choice = _this12.props.confirm({
        message: 'Undoing will result in conflicts...',
        detailedMessage: `for the following files:\n${conflictedFiles}\n` + 'Would you like to apply the changes with merge conflict markers, ' + 'or open the text with merge conflict markers in a new file?',
        buttons: ['Merge with conflict markers', 'Open in new file', 'Cancel undo']
      });
      if (choice === 0) {
        yield _this12.proceedWithLastDiscardUndo(results, partialDiscardFilePath);
      } else if (choice === 1) {
        yield _this12.openConflictsInNewEditors(conflicts.map(function (_ref10) {
          let resultPath = _ref10.resultPath;
          return resultPath;
        }));
      }
    })();
  }

  cleanUpHistoryForFilePaths(filePaths) {
    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    this.props.repository.clearDiscardHistory(partialDiscardFilePath);
    const filePathsStr = filePaths.map(filePath => `\`${filePath}\``).join('<br>');
    this.props.notificationManager.addError('Discard history has expired.', {
      description: `Cannot undo discard for<br>${filePathsStr}<br>Stale discard history has been deleted.`,
      dismissable: true
    });
  }

  proceedWithLastDiscardUndo(results) {
    var _this13 = this;

    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _asyncToGenerator(function* () {
      const promises = results.map((() => {
        var _ref11 = _asyncToGenerator(function* (result) {
          const filePath = result.filePath,
                resultPath = result.resultPath,
                deleted = result.deleted,
                conflict = result.conflict,
                theirsSha = result.theirsSha,
                commonBaseSha = result.commonBaseSha,
                currentSha = result.currentSha;

          const absFilePath = _path2.default.join(_this13.props.repository.getWorkingDirectoryPath(), filePath);
          if (deleted && resultPath === null) {
            yield (0, _helpers.deleteFileOrFolder)(absFilePath);
          } else {
            yield (0, _helpers.copyFile)(resultPath, absFilePath);
          }
          if (conflict) {
            yield _this13.props.repository.writeMergeConflictToIndex(filePath, commonBaseSha, currentSha, theirsSha);
          }
        });

        return function (_x11) {
          return _ref11.apply(this, arguments);
        };
      })());
      yield Promise.all(promises);
      yield _this13.props.repository.popDiscardHistory(partialDiscardFilePath);
    })();
  }

  openConflictsInNewEditors(resultPaths) {
    var _this14 = this;

    return _asyncToGenerator(function* () {
      const editorPromises = resultPaths.map(function (resultPath) {
        return _this14.props.workspace.open(resultPath);
      });
      return yield Promise.all(editorPromises);
    })();
  }

  /*
   * Asynchronously count the conflict markers present in a file specified by full path.
   */

  refreshResolutionProgress(fullPath) {
    const readStream = _fs2.default.createReadStream(fullPath, { encoding: 'utf8' });
    return new Promise(resolve => {
      _conflict2.default.countFromStream(readStream).then(count => {
        this.props.resolutionProgress.reportMarkerCount(fullPath, count);
      });
    });
  }

  /*
   * Display the credential entry dialog. Return a Promise that will resolve with the provided credentials on accept
   * or reject on cancel.
   */
  promptForCredentials(query) {
    return new Promise((resolve, reject) => {
      this.setState({
        credentialDialogQuery: _extends({}, query, {
          onSubmit: response => this.setState({ credentialDialogQuery: null }, () => resolve(response)),
          onCancel: () => this.setState({ credentialDialogQuery: null }, reject)
        })
      });
    });
  }
}, _class2.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  confirm: _propTypes2.default.func.isRequired,
  activeWorkingDirectory: _propTypes2.default.string,
  createRepositoryForProjectPath: _propTypes2.default.func,
  cloneRepositoryForProjectPath: _propTypes2.default.func,
  repository: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  statusBar: _propTypes2.default.object,
  switchboard: _propTypes2.default.instanceOf(_switchboard2.default),
  savedState: _propTypes2.default.object,
  useLegacyPanels: _propTypes2.default.bool,
  startOpen: _react2.default.PropTypes.bool
}, _class2.defaultProps = {
  switchboard: new _switchboard2.default(),
  savedState: {},
  useLegacyPanels: false,
  startOpen: true
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'initializeRepo', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'initializeRepo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showOpenIssueishDialog', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showOpenIssueishDialog'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showWaterfallDiagnostics', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showWaterfallDiagnostics'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'acceptClone', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'acceptClone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelClone', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelClone'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'acceptInit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'acceptInit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelInit', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelInit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'acceptOpenIssueish', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'acceptOpenIssueish'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancelOpenIssueish', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancelOpenIssueish'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showFilePatchForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showFilePatchForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoFilePatchForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoFilePatchForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'surfaceFromFileAtPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'surfaceFromFileAtPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'onRepoRefresh', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'onRepoRefresh'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'showMergeConflictFileForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showMergeConflictFileForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoMergeConflictFileForPath', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoMergeConflictFileForPath'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didChangeAmending', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didChangeAmending'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openCloneDialog', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openCloneDialog'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handlePanelResize', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handlePanelResize'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleChangeTab', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleChangeTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'quietlySelectItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'quietlySelectItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'focusFilePatchView', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'focusFilePatchView'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'viewUnstagedChangesForCurrentFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'viewUnstagedChangesForCurrentFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'viewStagedChangesForCurrentFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'viewStagedChangesForCurrentFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'goToDiffLine', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'goToDiffLine'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getUnsavedFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'getUnsavedFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'ensureNoUnsavedFiles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'ensureNoUnsavedFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardWorkDirChangesForPaths', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardWorkDirChangesForPaths'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardLines', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'discardLines'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'undoLastDiscard', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'undoLastDiscard'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'refreshResolutionProgress', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'refreshResolutionProgress'), _class.prototype)), _class);
exports.default = RootController;
let TabTracker = (_class3 = class TabTracker {
  constructor(name, _ref12) {
    let useLegacyPanels = _ref12.useLegacyPanels,
        getState = _ref12.getState,
        setState = _ref12.setState,
        getController = _ref12.getController,
        getDockItem = _ref12.getDockItem,
        getWorkspace = _ref12.getWorkspace;

    this.name = name;

    this.useLegacyPanels = useLegacyPanels;
    this.getState = getState;
    this.getWorkspace = getWorkspace;
    this.getController = getController;
    this.getDockItem = getDockItem;

    this.setStateKey = function (value) {
      let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { activateTab: false };

      return new Promise(resolve => setState(value, options, resolve));
    };
  }

  getControllerComponent() {
    const controller = this.getController();

    if (!controller.getWrappedComponent) {
      return controller;
    }

    return controller.getWrappedComponent();
  }

  toggle() {
    var _this15 = this;

    return _asyncToGenerator(function* () {
      const focusToRestore = document.activeElement;
      let shouldRestoreFocus = false;

      // Rendered => the dock item is being rendered, whether or not the dock is visible or the item
      //   is visible within its dock.
      // Visible => the item is active and the dock item is active within its dock.
      const wasRendered = _this15.getState();
      const wasVisible = _this15.isVisible();

      if (!wasRendered) {
        // Not rendered.
        yield _this15.setStateKey(true, { activateTab: true });
        yield _this15.reveal();
        shouldRestoreFocus = true;
      } else if (!wasVisible) {
        // Rendered, but not an active item in a visible dock.
        yield _this15.reveal();
        shouldRestoreFocus = true;
      } else {
        // Rendered and an active item within a visible dock.
        if (_this15.useLegacyPanels) {
          yield _this15.setStateKey(false);
        } else {
          yield _this15.hide();
        }
        shouldRestoreFocus = false;
      }

      if (shouldRestoreFocus) {
        process.nextTick(function () {
          return focusToRestore.focus();
        });
      }
    })();
  }

  toggleFocus() {
    var _this16 = this;

    return _asyncToGenerator(function* () {
      yield _this16.ensureVisible();

      if (_this16.hasFocus()) {
        let workspace = _this16.getWorkspace();
        if (workspace.getCenter) {
          workspace = workspace.getCenter();
        }
        workspace.getActivePane().activate();
      } else {
        _this16.focus();
      }
    })();
  }

  ensureVisible() {
    var _this17 = this;

    return _asyncToGenerator(function* () {
      if (!_this17.isVisible()) {
        yield _this17.setStateKey(true, { activateTab: true });
        yield _this17.reveal();
        return true;
      }
      return false;
    })();
  }

  reveal() {
    const dockItem = this.getDockItem();
    return dockItem ? dockItem.reveal() : Promise.resolve(null);
  }

  hide() {
    const dockItem = this.getDockItem();
    return dockItem ? dockItem.hide() : Promise.resolve(null);
  }

  focus() {
    this.getControllerComponent().restoreFocus();
  }

  isVisible() {
    if (!this.getState()) {
      return false;
    }

    const item = this.getDockItem();
    if (!item) {
      // Legacy panels active. Use getState(), which is true.
      return true;
    }

    const workspace = this.getWorkspace();
    return workspace.getPaneContainers().filter(container => container === workspace.getCenter() || container.isVisible()).some(container => container.getPanes().some(pane => pane.getActiveItem() === item.getDockItem()));
  }

  hasFocus() {
    return this.getControllerComponent().hasFocus();
  }
}, (_applyDecoratedDescriptor(_class3.prototype, 'toggle', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'toggle'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'toggleFocus', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'toggleFocus'), _class3.prototype), _applyDecoratedDescriptor(_class3.prototype, 'ensureVisible', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class3.prototype, 'ensureVisible'), _class3.prototype)), _class3);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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