'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _dec, _class, _class2, _temp;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _eventKit = require('event-kit');

var _observeModel = require('../decorators/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _resolutionProgress = require('../models/conflicts/resolution-progress');

var _resolutionProgress2 = _interopRequireDefault(_resolutionProgress);

var _editorConflictController = require('./editor-conflict-controller');

var _editorConflictController2 = _interopRequireDefault(_editorConflictController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Render an `EditorConflictController` for each `TextEditor` open on a file that contains git conflict markers.
 */
let RepositoryConflictController = (_dec = (0, _observeModel2.default)({
  getModel: props => props.repository,
  fetchData: (r, props) => {
    return (0, _yubikiri2.default)({
      workingDirectoryPath: r.getWorkingDirectoryPath(),
      mergeConflictPaths: r.getMergeConflicts().then(conflicts => conflicts.map(conflict => conflict.filePath)),
      isRebasing: r.isRebasing()
    });
  }
}), _dec(_class = (_temp = _class2 = class RepositoryConflictController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = { openEditors: this.props.workspace.getTextEditors() };
    this.subscriptions = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    this.subscriptions.add(this.props.workspace.observeTextEditors(() => {
      this.setState({
        openEditors: this.props.workspace.getTextEditors()
      });
    }));
  }

  render() {
    const conflictingEditors = this.getConflictingEditors();

    return _react2.default.createElement(
      'div',
      null,
      conflictingEditors.map(editor => _react2.default.createElement(_editorConflictController2.default, {
        key: editor.id,
        commandRegistry: this.props.commandRegistry,
        resolutionProgress: this.props.resolutionProgress,
        editor: editor,
        isRebase: this.props.isRebasing,
        refreshResolutionProgress: this.props.refreshResolutionProgress
      }))
    );
  }

  getConflictingEditors() {
    if (this.props.mergeConflictPaths.length === 0 || this.state.openEditors.length === 0) {
      return [];
    }

    const commonBasePath = this.props.repository.getWorkingDirectoryPath();
    const fullMergeConflictPaths = new Set(this.props.mergeConflictPaths.map(relativePath => _path2.default.join(commonBasePath, relativePath)));

    return this.state.openEditors.filter(editor => fullMergeConflictPaths.has(editor.getPath()));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }
}, _class2.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object.isRequired,
  mergeConflictPaths: _propTypes2.default.arrayOf(_propTypes2.default.string),
  isRebasing: _propTypes2.default.bool,
  refreshResolutionProgress: _propTypes2.default.func
}, _class2.defaultProps = {
  resolutionProgress: new _resolutionProgress2.default(),
  mergeConflictPaths: [],
  isRebasing: false,
  refreshResolutionProgress: () => {}
}, _temp)) || _class);
exports.default = RepositoryConflictController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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