'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _coreDecorators = require('core-decorators');

var _source = require('../models/conflicts/source');

var _decoration = require('../views/decoration');

var _decoration2 = _interopRequireDefault(_decoration);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const Menu = _electron.remote.Menu,
      MenuItem = _electron.remote.MenuItem;
let ConflictController = (_class = (_temp = _class2 = class ConflictController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      chosenSide: this.props.conflict.getChosenSide()
    };
  }

  resolveAsSequence(sources) {
    this.props.resolveAsSequence(sources);

    this.setState({
      chosenSide: this.props.conflict.getChosenSide()
    });
  }

  revert(side) {
    side.isModified() && side.revert();
    side.isBannerModified() && side.revertBanner();
  }

  showResolveMenu(event) {
    event.preventDefault();

    const menu = new Menu();

    menu.append(new MenuItem({
      label: 'Resolve as Ours',
      click: this.resolveAsSequence.bind(this, [_source.OURS])
    }));

    if (this.props.conflict.getSide(_source.BASE)) {
      menu.append(new MenuItem({
        label: 'Resolve as Base',
        click: this.resolveAsSequence.bind(this, [_source.BASE])
      }));
    }

    menu.append(new MenuItem({
      label: 'Resolve as Theirs',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS])
    }));

    menu.append(new MenuItem({ type: 'separator' }));

    menu.append(new MenuItem({
      label: 'Resolve as Ours Then Theirs',
      click: this.resolveAsSequence.bind(this, [_source.OURS, _source.THEIRS])
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Theirs Then Ours',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS, _source.OURS])
    }));

    menu.append(new MenuItem({ type: 'separator' }));

    menu.append(new MenuItem({
      label: 'Dismiss',
      click: this.props.dismiss
    }));

    menu.popup(_electron.remote.getCurrentWindow());
  }

  render() {
    if (!this.state.chosenSide) {
      const ours = this.props.conflict.getSide(_source.OURS);
      const base = this.props.conflict.getSide(_source.BASE);
      const theirs = this.props.conflict.getSide(_source.THEIRS);

      return _react2.default.createElement(
        'div',
        null,
        this.renderSide(ours),
        base && this.renderSide(base),
        _react2.default.createElement(_decoration2.default, {
          key: this.props.conflict.getSeparator().getMarker().id,
          editor: this.props.editor,
          marker: this.props.conflict.getSeparator().getMarker(),
          type: 'line',
          className: 'github-ConflictSeparator'
        }),
        this.renderSide(theirs)
      );
    } else if (!this.state.chosenSide.isEmpty()) {
      return _react2.default.createElement(_decoration2.default, {
        editor: this.props.editor,
        marker: this.state.chosenSide.getMarker(),
        type: 'line',
        className: 'github-ResolvedLines'
      });
    } else {
      return null;
    }
  }

  renderSide(side) {
    const source = side.getSource();

    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(_decoration2.default, {
        key: side.banner.marker.id,
        editor: this.props.editor,
        marker: side.getBannerMarker(),
        type: 'line',
        className: side.getBannerCSSClass()
      }),
      side.isBannerModified() || _react2.default.createElement(_decoration2.default, {
        key: 'banner-modified-' + side.banner.marker.id,
        editor: this.props.editor,
        marker: side.getBannerMarker(),
        type: 'line',
        className: 'github-ConflictUnmodifiedBanner'
      }),
      _react2.default.createElement(_decoration2.default, {
        key: side.marker.id,
        editor: this.props.editor,
        marker: side.getMarker(),
        type: 'line',
        className: side.getLineCSSClass()
      }),
      _react2.default.createElement(
        _decoration2.default,
        {
          key: 'block-' + side.marker.id,
          editor: this.props.editor,
          marker: side.getBlockMarker(),
          type: 'block',
          position: side.getBlockPosition() },
        _react2.default.createElement(
          'div',
          { className: side.getBlockCSSClasses() },
          _react2.default.createElement(
            'span',
            { className: 'github-ResolutionControls' },
            _react2.default.createElement(
              'button',
              { className: 'btn btn-sm inline-block', onClick: () => this.resolveAsSequence([source]) },
              'Use me'
            ),
            (side.isModified() || side.isBannerModified()) && _react2.default.createElement(
              'button',
              { className: 'btn btn-sm inline-block', onClick: () => this.revert(side) },
              'Revert'
            ),
            _react2.default.createElement(_octicon2.default, { icon: 'ellipses', className: 'inline-block', onClick: this.showResolveMenu })
          ),
          _react2.default.createElement(
            'span',
            { className: 'github-SideDescription' },
            source.toUIString()
          )
        )
      )
    );
  }
}, _class2.propTypes = {
  editor: _propTypes2.default.object.isRequired,
  conflict: _propTypes2.default.object.isRequired,
  resolveAsSequence: _propTypes2.default.func,
  dismiss: _propTypes2.default.func
}, _class2.defaultProps = {
  resolveAsSequence: sources => {},
  dismiss: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'showResolveMenu', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'showResolveMenu'), _class.prototype)), _class);
exports.default = ConflictController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbmZsaWN0LWNvbnRyb2xsZXIuanMiXSwibmFtZXMiOlsiTWVudSIsIk1lbnVJdGVtIiwiQ29uZmxpY3RDb250cm9sbGVyIiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJwcm9wcyIsImNvbnRleHQiLCJzdGF0ZSIsImNob3NlblNpZGUiLCJjb25mbGljdCIsImdldENob3NlblNpZGUiLCJyZXNvbHZlQXNTZXF1ZW5jZSIsInNvdXJjZXMiLCJzZXRTdGF0ZSIsInJldmVydCIsInNpZGUiLCJpc01vZGlmaWVkIiwiaXNCYW5uZXJNb2RpZmllZCIsInJldmVydEJhbm5lciIsInNob3dSZXNvbHZlTWVudSIsImV2ZW50IiwicHJldmVudERlZmF1bHQiLCJtZW51IiwiYXBwZW5kIiwibGFiZWwiLCJjbGljayIsImJpbmQiLCJnZXRTaWRlIiwidHlwZSIsImRpc21pc3MiLCJwb3B1cCIsImdldEN1cnJlbnRXaW5kb3ciLCJyZW5kZXIiLCJvdXJzIiwiYmFzZSIsInRoZWlycyIsInJlbmRlclNpZGUiLCJnZXRTZXBhcmF0b3IiLCJnZXRNYXJrZXIiLCJpZCIsImVkaXRvciIsImlzRW1wdHkiLCJzb3VyY2UiLCJnZXRTb3VyY2UiLCJiYW5uZXIiLCJtYXJrZXIiLCJnZXRCYW5uZXJNYXJrZXIiLCJnZXRCYW5uZXJDU1NDbGFzcyIsImdldExpbmVDU1NDbGFzcyIsImdldEJsb2NrTWFya2VyIiwiZ2V0QmxvY2tQb3NpdGlvbiIsImdldEJsb2NrQ1NTQ2xhc3NlcyIsInRvVUlTdHJpbmciLCJwcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwiZnVuYyIsImRlZmF1bHRQcm9wcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7Ozs7QUFDQTs7OztBQUNBOztBQUdBOztBQUNBOztBQUNBOzs7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O01BTE9BLEksb0JBQUFBLEk7TUFBTUMsUSxvQkFBQUEsUTtJQU9RQyxrQixnQ0FBTixNQUFNQSxrQkFBTixTQUFpQyxnQkFBTUMsU0FBdkMsQ0FBaUQ7O0FBYTlEQyxjQUFZQyxLQUFaLEVBQW1CQyxPQUFuQixFQUE0QjtBQUMxQixVQUFNRCxLQUFOLEVBQWFDLE9BQWI7O0FBRUEsU0FBS0MsS0FBTCxHQUFhO0FBQ1hDLGtCQUFZLEtBQUtILEtBQUwsQ0FBV0ksUUFBWCxDQUFvQkMsYUFBcEI7QUFERCxLQUFiO0FBR0Q7O0FBRURDLG9CQUFrQkMsT0FBbEIsRUFBMkI7QUFDekIsU0FBS1AsS0FBTCxDQUFXTSxpQkFBWCxDQUE2QkMsT0FBN0I7O0FBRUEsU0FBS0MsUUFBTCxDQUFjO0FBQ1pMLGtCQUFZLEtBQUtILEtBQUwsQ0FBV0ksUUFBWCxDQUFvQkMsYUFBcEI7QUFEQSxLQUFkO0FBR0Q7O0FBRURJLFNBQU9DLElBQVAsRUFBYTtBQUNYQSxTQUFLQyxVQUFMLE1BQXFCRCxLQUFLRCxNQUFMLEVBQXJCO0FBQ0FDLFNBQUtFLGdCQUFMLE1BQTJCRixLQUFLRyxZQUFMLEVBQTNCO0FBQ0Q7O0FBR0RDLGtCQUFnQkMsS0FBaEIsRUFBdUI7QUFDckJBLFVBQU1DLGNBQU47O0FBRUEsVUFBTUMsT0FBTyxJQUFJdEIsSUFBSixFQUFiOztBQUVBc0IsU0FBS0MsTUFBTCxDQUFZLElBQUl0QixRQUFKLENBQWE7QUFDdkJ1QixhQUFPLGlCQURnQjtBQUV2QkMsYUFBTyxLQUFLZCxpQkFBTCxDQUF1QmUsSUFBdkIsQ0FBNEIsSUFBNUIsRUFBa0MsY0FBbEM7QUFGZ0IsS0FBYixDQUFaOztBQUtBLFFBQUksS0FBS3JCLEtBQUwsQ0FBV0ksUUFBWCxDQUFvQmtCLE9BQXBCLGNBQUosRUFBdUM7QUFDckNMLFdBQUtDLE1BQUwsQ0FBWSxJQUFJdEIsUUFBSixDQUFhO0FBQ3ZCdUIsZUFBTyxpQkFEZ0I7QUFFdkJDLGVBQU8sS0FBS2QsaUJBQUwsQ0FBdUJlLElBQXZCLENBQTRCLElBQTVCLEVBQWtDLGNBQWxDO0FBRmdCLE9BQWIsQ0FBWjtBQUlEOztBQUVESixTQUFLQyxNQUFMLENBQVksSUFBSXRCLFFBQUosQ0FBYTtBQUN2QnVCLGFBQU8sbUJBRGdCO0FBRXZCQyxhQUFPLEtBQUtkLGlCQUFMLENBQXVCZSxJQUF2QixDQUE0QixJQUE1QixFQUFrQyxnQkFBbEM7QUFGZ0IsS0FBYixDQUFaOztBQUtBSixTQUFLQyxNQUFMLENBQVksSUFBSXRCLFFBQUosQ0FBYSxFQUFDMkIsTUFBTSxXQUFQLEVBQWIsQ0FBWjs7QUFFQU4sU0FBS0MsTUFBTCxDQUFZLElBQUl0QixRQUFKLENBQWE7QUFDdkJ1QixhQUFPLDZCQURnQjtBQUV2QkMsYUFBTyxLQUFLZCxpQkFBTCxDQUF1QmUsSUFBdkIsQ0FBNEIsSUFBNUIsRUFBa0MsOEJBQWxDO0FBRmdCLEtBQWIsQ0FBWjtBQUlBSixTQUFLQyxNQUFMLENBQVksSUFBSXRCLFFBQUosQ0FBYTtBQUN2QnVCLGFBQU8sNkJBRGdCO0FBRXZCQyxhQUFPLEtBQUtkLGlCQUFMLENBQXVCZSxJQUF2QixDQUE0QixJQUE1QixFQUFrQyw4QkFBbEM7QUFGZ0IsS0FBYixDQUFaOztBQUtBSixTQUFLQyxNQUFMLENBQVksSUFBSXRCLFFBQUosQ0FBYSxFQUFDMkIsTUFBTSxXQUFQLEVBQWIsQ0FBWjs7QUFFQU4sU0FBS0MsTUFBTCxDQUFZLElBQUl0QixRQUFKLENBQWE7QUFDdkJ1QixhQUFPLFNBRGdCO0FBRXZCQyxhQUFPLEtBQUtwQixLQUFMLENBQVd3QjtBQUZLLEtBQWIsQ0FBWjs7QUFLQVAsU0FBS1EsS0FBTCxDQUFXLGlCQUFPQyxnQkFBUCxFQUFYO0FBQ0Q7O0FBRURDLFdBQVM7QUFDUCxRQUFJLENBQUMsS0FBS3pCLEtBQUwsQ0FBV0MsVUFBaEIsRUFBNEI7QUFDMUIsWUFBTXlCLE9BQU8sS0FBSzVCLEtBQUwsQ0FBV0ksUUFBWCxDQUFvQmtCLE9BQXBCLGNBQWI7QUFDQSxZQUFNTyxPQUFPLEtBQUs3QixLQUFMLENBQVdJLFFBQVgsQ0FBb0JrQixPQUFwQixjQUFiO0FBQ0EsWUFBTVEsU0FBUyxLQUFLOUIsS0FBTCxDQUFXSSxRQUFYLENBQW9Ca0IsT0FBcEIsZ0JBQWY7O0FBRUEsYUFDRTtBQUFBO0FBQUE7QUFDRyxhQUFLUyxVQUFMLENBQWdCSCxJQUFoQixDQURIO0FBRUdDLGdCQUFRLEtBQUtFLFVBQUwsQ0FBZ0JGLElBQWhCLENBRlg7QUFHRTtBQUNFLGVBQUssS0FBSzdCLEtBQUwsQ0FBV0ksUUFBWCxDQUFvQjRCLFlBQXBCLEdBQW1DQyxTQUFuQyxHQUErQ0MsRUFEdEQ7QUFFRSxrQkFBUSxLQUFLbEMsS0FBTCxDQUFXbUMsTUFGckI7QUFHRSxrQkFBUSxLQUFLbkMsS0FBTCxDQUFXSSxRQUFYLENBQW9CNEIsWUFBcEIsR0FBbUNDLFNBQW5DLEVBSFY7QUFJRSxnQkFBSyxNQUpQO0FBS0UscUJBQVU7QUFMWixVQUhGO0FBVUcsYUFBS0YsVUFBTCxDQUFnQkQsTUFBaEI7QUFWSCxPQURGO0FBY0QsS0FuQkQsTUFtQk8sSUFBSSxDQUFDLEtBQUs1QixLQUFMLENBQVdDLFVBQVgsQ0FBc0JpQyxPQUF0QixFQUFMLEVBQXNDO0FBQzNDLGFBQ0U7QUFDRSxnQkFBUSxLQUFLcEMsS0FBTCxDQUFXbUMsTUFEckI7QUFFRSxnQkFBUSxLQUFLakMsS0FBTCxDQUFXQyxVQUFYLENBQXNCOEIsU0FBdEIsRUFGVjtBQUdFLGNBQUssTUFIUDtBQUlFLG1CQUFVO0FBSlosUUFERjtBQVFELEtBVE0sTUFTQTtBQUNMLGFBQU8sSUFBUDtBQUNEO0FBQ0Y7O0FBRURGLGFBQVdyQixJQUFYLEVBQWlCO0FBQ2YsVUFBTTJCLFNBQVMzQixLQUFLNEIsU0FBTCxFQUFmOztBQUVBLFdBQ0U7QUFBQTtBQUFBO0FBQ0U7QUFDRSxhQUFLNUIsS0FBSzZCLE1BQUwsQ0FBWUMsTUFBWixDQUFtQk4sRUFEMUI7QUFFRSxnQkFBUSxLQUFLbEMsS0FBTCxDQUFXbUMsTUFGckI7QUFHRSxnQkFBUXpCLEtBQUsrQixlQUFMLEVBSFY7QUFJRSxjQUFLLE1BSlA7QUFLRSxtQkFBVy9CLEtBQUtnQyxpQkFBTDtBQUxiLFFBREY7QUFRR2hDLFdBQUtFLGdCQUFMLE1BQ0M7QUFDRSxhQUFLLHFCQUFxQkYsS0FBSzZCLE1BQUwsQ0FBWUMsTUFBWixDQUFtQk4sRUFEL0M7QUFFRSxnQkFBUSxLQUFLbEMsS0FBTCxDQUFXbUMsTUFGckI7QUFHRSxnQkFBUXpCLEtBQUsrQixlQUFMLEVBSFY7QUFJRSxjQUFLLE1BSlA7QUFLRSxtQkFBVTtBQUxaLFFBVEo7QUFpQkU7QUFDRSxhQUFLL0IsS0FBSzhCLE1BQUwsQ0FBWU4sRUFEbkI7QUFFRSxnQkFBUSxLQUFLbEMsS0FBTCxDQUFXbUMsTUFGckI7QUFHRSxnQkFBUXpCLEtBQUt1QixTQUFMLEVBSFY7QUFJRSxjQUFLLE1BSlA7QUFLRSxtQkFBV3ZCLEtBQUtpQyxlQUFMO0FBTGIsUUFqQkY7QUF3QkU7QUFBQTtBQUFBO0FBQ0UsZUFBSyxXQUFXakMsS0FBSzhCLE1BQUwsQ0FBWU4sRUFEOUI7QUFFRSxrQkFBUSxLQUFLbEMsS0FBTCxDQUFXbUMsTUFGckI7QUFHRSxrQkFBUXpCLEtBQUtrQyxjQUFMLEVBSFY7QUFJRSxnQkFBSyxPQUpQO0FBS0Usb0JBQVVsQyxLQUFLbUMsZ0JBQUwsRUFMWjtBQU1FO0FBQUE7QUFBQSxZQUFLLFdBQVduQyxLQUFLb0Msa0JBQUwsRUFBaEI7QUFDRTtBQUFBO0FBQUEsY0FBTSxXQUFVLDJCQUFoQjtBQUNFO0FBQUE7QUFBQSxnQkFBUSxXQUFVLHlCQUFsQixFQUE0QyxTQUFTLE1BQU0sS0FBS3hDLGlCQUFMLENBQXVCLENBQUMrQixNQUFELENBQXZCLENBQTNEO0FBQUE7QUFBQSxhQURGO0FBSUcsYUFBQzNCLEtBQUtDLFVBQUwsTUFBcUJELEtBQUtFLGdCQUFMLEVBQXRCLEtBQ0M7QUFBQTtBQUFBLGdCQUFRLFdBQVUseUJBQWxCLEVBQTRDLFNBQVMsTUFBTSxLQUFLSCxNQUFMLENBQVlDLElBQVosQ0FBM0Q7QUFBQTtBQUFBLGFBTEo7QUFTRSwrREFBUyxNQUFLLFVBQWQsRUFBeUIsV0FBVSxjQUFuQyxFQUFrRCxTQUFTLEtBQUtJLGVBQWhFO0FBVEYsV0FERjtBQVlFO0FBQUE7QUFBQSxjQUFNLFdBQVUsd0JBQWhCO0FBQTBDdUIsbUJBQU9VLFVBQVA7QUFBMUM7QUFaRjtBQU5GO0FBeEJGLEtBREY7QUFnREQ7QUFuSzZELEMsVUFDdkRDLFMsR0FBWTtBQUNqQmIsVUFBUSxvQkFBVWMsTUFBVixDQUFpQkMsVUFEUjtBQUVqQjlDLFlBQVUsb0JBQVU2QyxNQUFWLENBQWlCQyxVQUZWO0FBR2pCNUMscUJBQW1CLG9CQUFVNkMsSUFIWjtBQUlqQjNCLFdBQVMsb0JBQVUyQjtBQUpGLEMsVUFPWkMsWSxHQUFlO0FBQ3BCOUMscUJBQW1CQyxXQUFXLENBQUUsQ0FEWjtBQUVwQmlCLFdBQVMsTUFBTSxDQUFFO0FBRkcsQztrQkFSSDNCLGtCIiwiZmlsZSI6ImNvbmZsaWN0LWNvbnRyb2xsZXIuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtyZW1vdGV9IGZyb20gJ2VsZWN0cm9uJztcbmNvbnN0IHtNZW51LCBNZW51SXRlbX0gPSByZW1vdGU7XG5cbmltcG9ydCB7YXV0b2JpbmR9IGZyb20gJ2NvcmUtZGVjb3JhdG9ycyc7XG5pbXBvcnQge09VUlMsIEJBU0UsIFRIRUlSU30gZnJvbSAnLi4vbW9kZWxzL2NvbmZsaWN0cy9zb3VyY2UnO1xuaW1wb3J0IERlY29yYXRpb24gZnJvbSAnLi4vdmlld3MvZGVjb3JhdGlvbic7XG5pbXBvcnQgT2N0aWNvbiBmcm9tICcuLi92aWV3cy9vY3RpY29uJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ29uZmxpY3RDb250cm9sbGVyIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBlZGl0b3I6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb25mbGljdDogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHJlc29sdmVBc1NlcXVlbmNlOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBkaXNtaXNzOiBQcm9wVHlwZXMuZnVuYyxcbiAgfTtcblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIHJlc29sdmVBc1NlcXVlbmNlOiBzb3VyY2VzID0+IHt9LFxuICAgIGRpc21pc3M6ICgpID0+IHt9LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG5cbiAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgY2hvc2VuU2lkZTogdGhpcy5wcm9wcy5jb25mbGljdC5nZXRDaG9zZW5TaWRlKCksXG4gICAgfTtcbiAgfVxuXG4gIHJlc29sdmVBc1NlcXVlbmNlKHNvdXJjZXMpIHtcbiAgICB0aGlzLnByb3BzLnJlc29sdmVBc1NlcXVlbmNlKHNvdXJjZXMpO1xuXG4gICAgdGhpcy5zZXRTdGF0ZSh7XG4gICAgICBjaG9zZW5TaWRlOiB0aGlzLnByb3BzLmNvbmZsaWN0LmdldENob3NlblNpZGUoKSxcbiAgICB9KTtcbiAgfVxuXG4gIHJldmVydChzaWRlKSB7XG4gICAgc2lkZS5pc01vZGlmaWVkKCkgJiYgc2lkZS5yZXZlcnQoKTtcbiAgICBzaWRlLmlzQmFubmVyTW9kaWZpZWQoKSAmJiBzaWRlLnJldmVydEJhbm5lcigpO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIHNob3dSZXNvbHZlTWVudShldmVudCkge1xuICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KCk7XG5cbiAgICBjb25zdCBtZW51ID0gbmV3IE1lbnUoKTtcblxuICAgIG1lbnUuYXBwZW5kKG5ldyBNZW51SXRlbSh7XG4gICAgICBsYWJlbDogJ1Jlc29sdmUgYXMgT3VycycsXG4gICAgICBjbGljazogdGhpcy5yZXNvbHZlQXNTZXF1ZW5jZS5iaW5kKHRoaXMsIFtPVVJTXSksXG4gICAgfSkpO1xuXG4gICAgaWYgKHRoaXMucHJvcHMuY29uZmxpY3QuZ2V0U2lkZShCQVNFKSkge1xuICAgICAgbWVudS5hcHBlbmQobmV3IE1lbnVJdGVtKHtcbiAgICAgICAgbGFiZWw6ICdSZXNvbHZlIGFzIEJhc2UnLFxuICAgICAgICBjbGljazogdGhpcy5yZXNvbHZlQXNTZXF1ZW5jZS5iaW5kKHRoaXMsIFtCQVNFXSksXG4gICAgICB9KSk7XG4gICAgfVxuXG4gICAgbWVudS5hcHBlbmQobmV3IE1lbnVJdGVtKHtcbiAgICAgIGxhYmVsOiAnUmVzb2x2ZSBhcyBUaGVpcnMnLFxuICAgICAgY2xpY2s6IHRoaXMucmVzb2x2ZUFzU2VxdWVuY2UuYmluZCh0aGlzLCBbVEhFSVJTXSksXG4gICAgfSkpO1xuXG4gICAgbWVudS5hcHBlbmQobmV3IE1lbnVJdGVtKHt0eXBlOiAnc2VwYXJhdG9yJ30pKTtcblxuICAgIG1lbnUuYXBwZW5kKG5ldyBNZW51SXRlbSh7XG4gICAgICBsYWJlbDogJ1Jlc29sdmUgYXMgT3VycyBUaGVuIFRoZWlycycsXG4gICAgICBjbGljazogdGhpcy5yZXNvbHZlQXNTZXF1ZW5jZS5iaW5kKHRoaXMsIFtPVVJTLCBUSEVJUlNdKSxcbiAgICB9KSk7XG4gICAgbWVudS5hcHBlbmQobmV3IE1lbnVJdGVtKHtcbiAgICAgIGxhYmVsOiAnUmVzb2x2ZSBhcyBUaGVpcnMgVGhlbiBPdXJzJyxcbiAgICAgIGNsaWNrOiB0aGlzLnJlc29sdmVBc1NlcXVlbmNlLmJpbmQodGhpcywgW1RIRUlSUywgT1VSU10pLFxuICAgIH0pKTtcblxuICAgIG1lbnUuYXBwZW5kKG5ldyBNZW51SXRlbSh7dHlwZTogJ3NlcGFyYXRvcid9KSk7XG5cbiAgICBtZW51LmFwcGVuZChuZXcgTWVudUl0ZW0oe1xuICAgICAgbGFiZWw6ICdEaXNtaXNzJyxcbiAgICAgIGNsaWNrOiB0aGlzLnByb3BzLmRpc21pc3MsXG4gICAgfSkpO1xuXG4gICAgbWVudS5wb3B1cChyZW1vdGUuZ2V0Q3VycmVudFdpbmRvdygpKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBpZiAoIXRoaXMuc3RhdGUuY2hvc2VuU2lkZSkge1xuICAgICAgY29uc3Qgb3VycyA9IHRoaXMucHJvcHMuY29uZmxpY3QuZ2V0U2lkZShPVVJTKTtcbiAgICAgIGNvbnN0IGJhc2UgPSB0aGlzLnByb3BzLmNvbmZsaWN0LmdldFNpZGUoQkFTRSk7XG4gICAgICBjb25zdCB0aGVpcnMgPSB0aGlzLnByb3BzLmNvbmZsaWN0LmdldFNpZGUoVEhFSVJTKTtcblxuICAgICAgcmV0dXJuIChcbiAgICAgICAgPGRpdj5cbiAgICAgICAgICB7dGhpcy5yZW5kZXJTaWRlKG91cnMpfVxuICAgICAgICAgIHtiYXNlICYmIHRoaXMucmVuZGVyU2lkZShiYXNlKX1cbiAgICAgICAgICA8RGVjb3JhdGlvblxuICAgICAgICAgICAga2V5PXt0aGlzLnByb3BzLmNvbmZsaWN0LmdldFNlcGFyYXRvcigpLmdldE1hcmtlcigpLmlkfVxuICAgICAgICAgICAgZWRpdG9yPXt0aGlzLnByb3BzLmVkaXRvcn1cbiAgICAgICAgICAgIG1hcmtlcj17dGhpcy5wcm9wcy5jb25mbGljdC5nZXRTZXBhcmF0b3IoKS5nZXRNYXJrZXIoKX1cbiAgICAgICAgICAgIHR5cGU9XCJsaW5lXCJcbiAgICAgICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1Db25mbGljdFNlcGFyYXRvclwiXG4gICAgICAgICAgLz5cbiAgICAgICAgICB7dGhpcy5yZW5kZXJTaWRlKHRoZWlycyl9XG4gICAgICAgIDwvZGl2PlxuICAgICAgKTtcbiAgICB9IGVsc2UgaWYgKCF0aGlzLnN0YXRlLmNob3NlblNpZGUuaXNFbXB0eSgpKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8RGVjb3JhdGlvblxuICAgICAgICAgIGVkaXRvcj17dGhpcy5wcm9wcy5lZGl0b3J9XG4gICAgICAgICAgbWFya2VyPXt0aGlzLnN0YXRlLmNob3NlblNpZGUuZ2V0TWFya2VyKCl9XG4gICAgICAgICAgdHlwZT1cImxpbmVcIlxuICAgICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXNvbHZlZExpbmVzXCJcbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlclNpZGUoc2lkZSkge1xuICAgIGNvbnN0IHNvdXJjZSA9IHNpZGUuZ2V0U291cmNlKCk7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRpdj5cbiAgICAgICAgPERlY29yYXRpb25cbiAgICAgICAgICBrZXk9e3NpZGUuYmFubmVyLm1hcmtlci5pZH1cbiAgICAgICAgICBlZGl0b3I9e3RoaXMucHJvcHMuZWRpdG9yfVxuICAgICAgICAgIG1hcmtlcj17c2lkZS5nZXRCYW5uZXJNYXJrZXIoKX1cbiAgICAgICAgICB0eXBlPVwibGluZVwiXG4gICAgICAgICAgY2xhc3NOYW1lPXtzaWRlLmdldEJhbm5lckNTU0NsYXNzKCl9XG4gICAgICAgIC8+XG4gICAgICAgIHtzaWRlLmlzQmFubmVyTW9kaWZpZWQoKSB8fFxuICAgICAgICAgIDxEZWNvcmF0aW9uXG4gICAgICAgICAgICBrZXk9eydiYW5uZXItbW9kaWZpZWQtJyArIHNpZGUuYmFubmVyLm1hcmtlci5pZH1cbiAgICAgICAgICAgIGVkaXRvcj17dGhpcy5wcm9wcy5lZGl0b3J9XG4gICAgICAgICAgICBtYXJrZXI9e3NpZGUuZ2V0QmFubmVyTWFya2VyKCl9XG4gICAgICAgICAgICB0eXBlPVwibGluZVwiXG4gICAgICAgICAgICBjbGFzc05hbWU9XCJnaXRodWItQ29uZmxpY3RVbm1vZGlmaWVkQmFubmVyXCJcbiAgICAgICAgICAvPlxuICAgICAgICB9XG4gICAgICAgIDxEZWNvcmF0aW9uXG4gICAgICAgICAga2V5PXtzaWRlLm1hcmtlci5pZH1cbiAgICAgICAgICBlZGl0b3I9e3RoaXMucHJvcHMuZWRpdG9yfVxuICAgICAgICAgIG1hcmtlcj17c2lkZS5nZXRNYXJrZXIoKX1cbiAgICAgICAgICB0eXBlPVwibGluZVwiXG4gICAgICAgICAgY2xhc3NOYW1lPXtzaWRlLmdldExpbmVDU1NDbGFzcygpfVxuICAgICAgICAvPlxuICAgICAgICA8RGVjb3JhdGlvblxuICAgICAgICAgIGtleT17J2Jsb2NrLScgKyBzaWRlLm1hcmtlci5pZH1cbiAgICAgICAgICBlZGl0b3I9e3RoaXMucHJvcHMuZWRpdG9yfVxuICAgICAgICAgIG1hcmtlcj17c2lkZS5nZXRCbG9ja01hcmtlcigpfVxuICAgICAgICAgIHR5cGU9XCJibG9ja1wiXG4gICAgICAgICAgcG9zaXRpb249e3NpZGUuZ2V0QmxvY2tQb3NpdGlvbigpfT5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT17c2lkZS5nZXRCbG9ja0NTU0NsYXNzZXMoKX0+XG4gICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUmVzb2x1dGlvbkNvbnRyb2xzXCI+XG4gICAgICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPVwiYnRuIGJ0bi1zbSBpbmxpbmUtYmxvY2tcIiBvbkNsaWNrPXsoKSA9PiB0aGlzLnJlc29sdmVBc1NlcXVlbmNlKFtzb3VyY2VdKX0+XG4gICAgICAgICAgICAgICAgVXNlIG1lXG4gICAgICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICAgICAgICB7KHNpZGUuaXNNb2RpZmllZCgpIHx8IHNpZGUuaXNCYW5uZXJNb2RpZmllZCgpKSAmJlxuICAgICAgICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPVwiYnRuIGJ0bi1zbSBpbmxpbmUtYmxvY2tcIiBvbkNsaWNrPXsoKSA9PiB0aGlzLnJldmVydChzaWRlKX0+XG4gICAgICAgICAgICAgICAgICBSZXZlcnRcbiAgICAgICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICA8T2N0aWNvbiBpY29uPVwiZWxsaXBzZXNcIiBjbGFzc05hbWU9XCJpbmxpbmUtYmxvY2tcIiBvbkNsaWNrPXt0aGlzLnNob3dSZXNvbHZlTWVudX0gLz5cbiAgICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1TaWRlRGVzY3JpcHRpb25cIj57c291cmNlLnRvVUlTdHJpbmcoKX08L3NwYW4+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvRGVjb3JhdGlvbj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cbn1cbiJdfQ==