'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let ContextMenuInterceptor = (_temp = _class = class ContextMenuInterceptor extends _react2.default.Component {

  static handle(event) {
    for (const _ref of ContextMenuInterceptor.registration) {
      var _ref2 = _slicedToArray(_ref, 2);

      const element = _ref2[0];
      const callback = _ref2[1];

      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }

  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, { capture: true });
  }

  componentDidMount() {
    var _this = this;

    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, { capture: true });
    ContextMenuInterceptor.registration.set(this.element, function () {
      return _this.props.onWillShowContextMenu(...arguments);
    });
  }

  render() {
    return _react2.default.createElement(
      'div',
      { ref: e => {
          this.element = e;
        } },
      this.props.children
    );
  }

  componentWillUnmount() {
    ContextMenuInterceptor.registration.delete(this.element);
  }
}, _class.propTypes = {
  onWillShowContextMenu: _propTypes2.default.func.isRequired,
  children: _propTypes2.default.element.isRequired
}, _class.registration = new Map(), _temp);
exports.default = ContextMenuInterceptor;


function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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