'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MergedEvent = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../../views/timeago');

var _timeago2 = _interopRequireDefault(_timeago);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let MergedEvent = exports.MergedEvent = (_temp = _class = class MergedEvent extends _react2.default.Component {

  render() {
    var _props$item = this.props.item;
    const actor = _props$item.actor,
          commit = _props$item.commit,
          mergeRef = _props$item.mergeRef,
          createdAt = _props$item.createdAt;

    return _react2.default.createElement(
      'div',
      { className: 'merged-event' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-merge' }),
      _react2.default.createElement('img', { className: 'author-avatar', src: actor.avatarUrl, title: actor.login }),
      _react2.default.createElement(
        'span',
        { className: 'merged-event-header' },
        _react2.default.createElement(
          'span',
          { className: 'username' },
          actor.login
        ),
        ' merged commit ',
        _react2.default.createElement(
          'span',
          { className: 'sha' },
          commit.oid.slice(0, 8)
        ),
        ' into',
        ' ',
        _react2.default.createElement(
          'span',
          { className: 'merge-ref' },
          mergeRef.name
        ),
        ' on ',
        _react2.default.createElement(_timeago2.default, { time: createdAt })
      )
    );
  }
}, _class.propTypes = {
  item: _propTypes2.default.object.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(MergedEvent, {
  fragments: {
    item: () => function () {
      return {
        children: [{
          children: [{
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'actor',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'Actor'
        }, {
          children: [{
            fieldName: 'oid',
            kind: 'Field',
            metadata: {},
            type: 'GitObjectID'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'commit',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Commit'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'mergeRef',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Ref'
        }, {
          fieldName: 'createdAt',
          kind: 'Field',
          metadata: {},
          type: 'DateTime'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Merged_ItemRelayQL',
        type: 'MergedEvent'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1lcmdlZC1ldmVudC1jb250YWluZXIuanMiXSwibmFtZXMiOlsiTWVyZ2VkRXZlbnQiLCJDb21wb25lbnQiLCJyZW5kZXIiLCJwcm9wcyIsIml0ZW0iLCJhY3RvciIsImNvbW1pdCIsIm1lcmdlUmVmIiwiY3JlYXRlZEF0IiwiYXZhdGFyVXJsIiwibG9naW4iLCJvaWQiLCJzbGljZSIsIm5hbWUiLCJwcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwiY3JlYXRlQ29udGFpbmVyIiwiZnJhZ21lbnRzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFFQTs7OztBQUNBOzs7Ozs7SUFFYUEsVyxXQUFBQSxXLHFCQUFOLE1BQU1BLFdBQU4sU0FBMEIsZ0JBQU1DLFNBQWhDLENBQTBDOztBQUsvQ0MsV0FBUztBQUFBLHNCQUNzQyxLQUFLQyxLQUFMLENBQVdDLElBRGpEO0FBQUEsVUFDQUMsS0FEQSxlQUNBQSxLQURBO0FBQUEsVUFDT0MsTUFEUCxlQUNPQSxNQURQO0FBQUEsVUFDZUMsUUFEZixlQUNlQSxRQURmO0FBQUEsVUFDeUJDLFNBRHpCLGVBQ3lCQSxTQUR6Qjs7QUFFUCxXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsY0FBZjtBQUNFLHlEQUFTLFdBQVUsd0JBQW5CLEVBQTRDLE1BQUssV0FBakQsR0FERjtBQUVFLDZDQUFLLFdBQVUsZUFBZixFQUErQixLQUFLSCxNQUFNSSxTQUExQyxFQUFxRCxPQUFPSixNQUFNSyxLQUFsRSxHQUZGO0FBR0U7QUFBQTtBQUFBLFVBQU0sV0FBVSxxQkFBaEI7QUFDRTtBQUFBO0FBQUEsWUFBTSxXQUFVLFVBQWhCO0FBQTRCTCxnQkFBTUs7QUFBbEMsU0FERjtBQUFBO0FBRVM7QUFBQTtBQUFBLFlBQU0sV0FBVSxLQUFoQjtBQUF1QkosaUJBQU9LLEdBQVAsQ0FBV0MsS0FBWCxDQUFpQixDQUFqQixFQUFvQixDQUFwQjtBQUF2QixTQUZUO0FBQUE7QUFHRyxXQUhIO0FBR087QUFBQTtBQUFBLFlBQU0sV0FBVSxXQUFoQjtBQUE2QkwsbUJBQVNNO0FBQXRDLFNBSFA7QUFBQTtBQUc2RCwyREFBUyxNQUFNTCxTQUFmO0FBSDdEO0FBSEYsS0FERjtBQVdEO0FBbEI4QyxDLFNBQ3hDTSxTLEdBQVk7QUFDakJWLFFBQU0sb0JBQVVXLE1BQVYsQ0FBaUJDO0FBRE4sQztrQkFvQk4scUJBQU1DLGVBQU4sQ0FBc0JqQixXQUF0QixFQUFtQztBQUNoRGtCLGFBQVc7QUFDVGQsVUFBTTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFERztBQURxQyxDQUFuQyxDIiwiZmlsZSI6Im1lcmdlZC1ldmVudC1jb250YWluZXIuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVsYXkgZnJvbSAncmVhY3QtcmVsYXknO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IE9jdGljb24gZnJvbSAnLi4vLi4vdmlld3Mvb2N0aWNvbic7XG5pbXBvcnQgVGltZWFnbyBmcm9tICcuLi8uLi92aWV3cy90aW1lYWdvJztcblxuZXhwb3J0IGNsYXNzIE1lcmdlZEV2ZW50IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBpdGVtOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3Qge2FjdG9yLCBjb21taXQsIG1lcmdlUmVmLCBjcmVhdGVkQXR9ID0gdGhpcy5wcm9wcy5pdGVtO1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cIm1lcmdlZC1ldmVudFwiPlxuICAgICAgICA8T2N0aWNvbiBjbGFzc05hbWU9XCJwcmUtdGltZWxpbmUtaXRlbS1pY29uXCIgaWNvbj1cImdpdC1tZXJnZVwiIC8+XG4gICAgICAgIDxpbWcgY2xhc3NOYW1lPVwiYXV0aG9yLWF2YXRhclwiIHNyYz17YWN0b3IuYXZhdGFyVXJsfSB0aXRsZT17YWN0b3IubG9naW59IC8+XG4gICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cIm1lcmdlZC1ldmVudC1oZWFkZXJcIj5cbiAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJ1c2VybmFtZVwiPnthY3Rvci5sb2dpbn08L3NwYW4+IG1lcmdlZFxuICAgICAgICAgIGNvbW1pdCA8c3BhbiBjbGFzc05hbWU9XCJzaGFcIj57Y29tbWl0Lm9pZC5zbGljZSgwLCA4KX08L3NwYW4+IGludG9cbiAgICAgICAgICB7JyAnfTxzcGFuIGNsYXNzTmFtZT1cIm1lcmdlLXJlZlwiPnttZXJnZVJlZi5uYW1lfTwvc3Bhbj4gb24gPFRpbWVhZ28gdGltZT17Y3JlYXRlZEF0fSAvPlxuICAgICAgICA8L3NwYW4+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IFJlbGF5LmNyZWF0ZUNvbnRhaW5lcihNZXJnZWRFdmVudCwge1xuICBmcmFnbWVudHM6IHtcbiAgICBpdGVtOiAoKSA9PiBSZWxheS5RTGBcbiAgICAgIGZyYWdtZW50IG9uIE1lcmdlZEV2ZW50IHtcbiAgICAgICAgYWN0b3Ige1xuICAgICAgICAgIGF2YXRhclVybCBsb2dpblxuICAgICAgICB9XG4gICAgICAgIGNvbW1pdCB7IG9pZCB9XG4gICAgICAgIG1lcmdlUmVmIHsgbmFtZSB9XG4gICAgICAgIGNyZWF0ZWRBdFxuICAgICAgfVxuICAgIGAsXG4gIH0sXG59KTtcbiJdfQ==