'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueComment = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _timeago = require('../../views/timeago');

var _timeago2 = _interopRequireDefault(_timeago);

var _githubDotcomMarkdown = require('../../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let IssueComment = exports.IssueComment = (_temp = _class = class IssueComment extends _react2.default.Component {

  render() {
    const comment = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'issue' },
      _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'comment' }),
        _react2.default.createElement('img', { className: 'author-avatar', src: comment.author.avatarUrl, title: comment.author.login }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          comment.author.login,
          ' commented on ',
          _react2.default.createElement(_timeago2.default, { time: comment.createdAt })
        )
      ),
      _react2.default.createElement(_githubDotcomMarkdown2.default, { html: comment.bodyHTML, switchToIssueish: this.props.switchToIssueish })
    );
  }
}, _class.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  item: _propTypes2.default.object.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueComment, {
  fragments: {
    item: () => function () {
      return {
        children: [{
          children: [{
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'Actor'
        }, {
          fieldName: 'bodyHTML',
          kind: 'Field',
          metadata: {},
          type: 'HTML'
        }, {
          fieldName: 'createdAt',
          kind: 'Field',
          metadata: {},
          type: 'DateTime'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issue_ItemRelayQL',
        type: 'IssueComment'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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