'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Commits = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _commitContainer = require('./commit-container');

var _commitContainer2 = _interopRequireDefault(_commitContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Commits = exports.Commits = (_temp = _class = class Commits extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'commits' },
      this.renderSummary(),
      this.renderCommits()
    );
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.props.nodes);
      return _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'repo-push' }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          namesString,
          ' added some commits...'
        )
      );
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.props.nodes.map(node => {
      return _react2.default.createElement(_commitContainer2.default, { key: node.id, item: node });
    });
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;
      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });

    names = Array.from(names);
    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }

}, _class.propTypes = {
  nodes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    author: _propTypes2.default.shape({
      name: _propTypes2.default.string,
      user: _propTypes2.default.shape({
        login: _propTypes2.default.string.isRequired
      })
    }).isRequired
  }).isRequired).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(Commits, {
  fragments: {
    nodes: () => function (RQL_0) {
      return {
        children: [].concat.apply([], [{
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isRequisite: true
          },
          type: 'ID'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'user',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'User'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true
          },
          type: 'GitActor'
        }, _reactRelay2.default.QL.__frag(RQL_0)]),
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          plural: true
        },
        name: 'Commits_NodesRelayQL',
        type: 'Commit'
      };
    }(_commitContainer2.default.getFragment('item'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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