'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Commit = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Commit = exports.Commit = (_temp = _class = class Commit extends _react2.default.Component {

  authoredByCommitter(commit) {
    if (commit.authoredByCommitter) {
      return true;
    }
    // If you commit on GitHub online the committer details would be:
    //
    //    name: "GitHub"
    //    email: "noreply@github.com"
    //    user: null
    //
    if (commit.committer.email === 'noreply@github.com') {
      return true;
    }
    if (commit.committer.name === 'GitHub' && commit.committer.user === null) {
      return true;
    }

    return false;
  }

  renderCommitter(commit) {
    if (!this.authoredByCommitter(commit)) {
      return _react2.default.createElement('img', {
        className: 'author-avatar', src: commit.committer.avatarUrl,
        title: commit.committer.user ? commit.committer.user.login : commit.committer.name
      });
    } else {
      return null;
    }
  }
  render() {
    const commit = this.props.item;
    return _react2.default.createElement(
      'div',
      { className: 'commit' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-commit' }),
      _react2.default.createElement(
        'span',
        { className: 'commit-author' },
        _react2.default.createElement('img', {
          className: 'author-avatar', src: commit.author.avatarUrl,
          title: commit.author.user ? commit.author.user.login : commit.author.name
        }),
        this.renderCommitter(commit)
      ),
      _react2.default.createElement('span', {
        className: 'commit-message-headline',
        title: commit.message,
        dangerouslySetInnerHTML: { __html: commit.messageHeadlineHTML }
      }),
      _react2.default.createElement(
        'span',
        { className: 'commit-sha' },
        commit.oid.slice(0, 8)
      )
    );
  }
}, _class.propTypes = {
  item: _propTypes2.default.object.isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(Commit, {
  fragments: {
    item: () => function () {
      return {
        children: [{
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'user',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'User'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true
          },
          type: 'GitActor'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'user',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'User'
          }],
          fieldName: 'committer',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true
          },
          type: 'GitActor'
        }, {
          fieldName: 'authoredByCommitter',
          kind: 'Field',
          metadata: {},
          type: 'Boolean'
        }, {
          fieldName: 'oid',
          kind: 'Field',
          metadata: {},
          type: 'GitObjectID'
        }, {
          fieldName: 'message',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          fieldName: 'messageHeadlineHTML',
          kind: 'Field',
          metadata: {},
          type: 'HTML'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Commit_ItemRelayQL',
        type: 'Commit'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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