'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrSelectionByBranch = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _prInfoContainer = require('./pr-info-container');

var _prInfoContainer2 = _interopRequireDefault(_prInfoContainer);

var _prUrlInputBox = require('../views/pr-url-input-box');

var _prUrlInputBox2 = _interopRequireDefault(_prUrlInputBox);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let PrSelectionByBranch = exports.PrSelectionByBranch = (_class = (_temp = _class2 = class PrSelectionByBranch extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = { displayInputBox: false };
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-PrSelectionByBranch' },
      this.renderSubview()
    );
  }

  renderSubview() {
    const repo = this.props.query.repository;
    const variables = this.props.relay.variables;

    if (!repo || !repo.pullRequests.edges.length) {
      return _react2.default.createElement(
        'div',
        { className: 'github-PrUrlInputBox-Container' },
        _react2.default.createElement(
          _prUrlInputBox2.default,
          { onSubmit: this.props.onSelectPr },
          _react2.default.createElement('p', { className: 'icon icon-git-pull-request' }),
          _react2.default.createElement(
            'p',
            null,
            'No pull request could be found for the branch ',
            _react2.default.createElement(
              'span',
              { className: 'highlight' },
              variables.branchName
            ),
            'on the repository ',
            _react2.default.createElement(
              'span',
              { className: 'highlight' },
              variables.repoOwner,
              '/',
              variables.repoName
            ),
            '.'
          ),
          _react2.default.createElement(
            'p',
            null,
            'You can manually pin a GitHub pull request to the current branch by entering its URL:'
          )
        )
      );
    }

    const edges = repo.pullRequests.edges;
    if (edges.length === 1) {
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(
            'div',
            { className: 'github-PrUrlInputBox-pinButton', onClick: this.toggleInputBoxVisibility },
            _react2.default.createElement(_octicon2.default, {
              title: 'Click here to select another PR.',
              icon: 'pin',
              className: 'pinned-by-url'
            }),
            'Specify Pull Request URL to pin'
          ),
          this.state.displayInputBox && _react2.default.createElement(
            _prUrlInputBox2.default,
            { onSubmit: this.props.onSelectPr },
            _react2.default.createElement(
              'p',
              null,
              'We found a pull request associated with the branch ',
              variables.branchName,
              ' on the repository ',
              variables.repoOwner,
              '/',
              variables.repoName,
              '.'
            ),
            _react2.default.createElement(
              'p',
              null,
              'You can manually pin a different GitHub pull request to the current branch by entering its URL:'
            )
          )
        ),
        _react2.default.createElement(_prInfoContainer2.default, { pullRequest: edges[0].node })
      );
    }

    return this.renderPrSelectionList(edges, repo.pullRequests.totalCount);
  }

  toggleInputBoxVisibility() {
    this.setState({ displayInputBox: !this.state.displayInputBox });
  }

  renderPrSelectionList(edges, totalCount) {
    const variables = this.props.relay.variables;

    return _react2.default.createElement(
      'div',
      { className: 'github-PrSelectionByBranch-listContainer' },
      _react2.default.createElement(
        'div',
        { className: 'github-PrSelectionByBranch-message' },
        'We found ',
        totalCount,
        ' pull requests associated with a branch named ',
        _react2.default.createElement(
          'span',
          { className: 'highlight' },
          variables.branchName
        ),
        ' on the repository ',
        _react2.default.createElement(
          'span',
          { className: 'highlight' },
          variables.repoOwner,
          '/',
          variables.repoName
        ),
        '. Select a pull request below to display it, or specify any pull request URL to pin it manually:'
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-PrSelectionByBranch-input' },
        _react2.default.createElement(_prUrlInputBox2.default, { onSubmit: this.props.onSelectPr })
      ),
      _react2.default.createElement(
        'ul',
        { className: 'github-PrSelectionByBranch-list' },
        edges.map(this.displayPullRequestItem)
      )
    );
  }

  displayPullRequestItem(_ref) {
    let node = _ref.node;

    return _react2.default.createElement(
      'li',
      { key: node.id, onClick: e => this.selectPullRequest(e, node) },
      '#',
      node.number,
      ': ',
      node.title
    );
  }

  setPr(prLink) {
    this.props.onSelectPr(prLink);
  }

  selectPullRequest(event, node) {
    event.preventDefault();
    this.setPr(node.url);
  }
}, _class2.propTypes = {
  query: _propTypes2.default.shape({
    repository: _propTypes2.default.shape({
      pullRequests: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number
      })
    })
  }),
  relay: _propTypes2.default.shape({
    variables: _propTypes2.default.object
  }),
  onSelectPr: _propTypes2.default.func.isRequired,
  onUnpinPr: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'toggleInputBoxVisibility', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'toggleInputBoxVisibility'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'displayPullRequestItem', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'displayPullRequestItem'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setPr', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'setPr'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'selectPullRequest', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'selectPullRequest'), _class.prototype)), _class);
exports.default = _reactRelay2.default.createContainer(PrSelectionByBranch, {
  initialVariables: {
    repoOwner: null,
    repoName: null,
    branchName: null
  },

  fragments: {
    query: () => function (RQL_0) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'owner',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoOwner'
            }
          }, {
            kind: 'Call',
            metadata: {},
            name: 'name',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoName'
            }
          }],
          children: [{
            calls: [{
              kind: 'Call',
              metadata: {},
              name: 'first',
              value: {
                kind: 'CallValue',
                callValue: 30
              }
            }, {
              kind: 'Call',
              metadata: {},
              name: 'headRefName',
              value: {
                kind: 'CallVariable',
                callVariableName: 'branchName'
              }
            }],
            children: [{
              fieldName: 'totalCount',
              kind: 'Field',
              metadata: {},
              type: 'Int'
            }, {
              children: [{
                children: [].concat.apply([], [{
                  fieldName: 'id',
                  kind: 'Field',
                  metadata: {
                    isRequisite: true
                  },
                  type: 'ID'
                }, {
                  fieldName: 'number',
                  kind: 'Field',
                  metadata: {},
                  type: 'Int'
                }, {
                  fieldName: 'title',
                  kind: 'Field',
                  metadata: {},
                  type: 'String'
                }, {
                  fieldName: 'url',
                  kind: 'Field',
                  metadata: {},
                  type: 'URI'
                }, _reactRelay2.default.QL.__frag(RQL_0)]),
                fieldName: 'node',
                kind: 'Field',
                metadata: {
                  canHaveSubselections: true,
                  inferredRootCallName: 'node',
                  inferredPrimaryKey: 'id',
                  isRequisite: true
                },
                type: 'PullRequest'
              }, {
                fieldName: 'cursor',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              fieldName: 'edges',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                isPlural: true
              },
              type: 'PullRequestEdge'
            }, {
              children: [{
                fieldName: 'hasNextPage',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'Boolean'
              }, {
                fieldName: 'hasPreviousPage',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'Boolean'
              }],
              fieldName: 'pageInfo',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                isGenerated: true,
                isRequisite: true
              },
              type: 'PageInfo'
            }],
            fieldName: 'pullRequests',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isConnection: true
            },
            type: 'PullRequestConnection'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'repository',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Repository'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Pr_QueryRelayQL',
        type: 'Query'
      };
    }(_prInfoContainer2.default.getFragment('pullRequest'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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