'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrInfo = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️'
};

const prStateToIcon = {
  OPEN: 'git-pull-request',
  CLOSED: 'git-pull-request',
  MERGED: 'git-merge'
};

let PrInfo = exports.PrInfo = (_class = (_temp = _class2 = class PrInfo extends _react2.default.Component {

  render() {
    const pr = this.props.pullRequest;
    const repo = pr.repository;
    return _react2.default.createElement(
      'div',
      { className: 'github-PrInfo' },
      this.props.pinnedByUrl && this.renderPinnedPr(),
      _react2.default.createElement(
        'div',
        { className: 'pr-badge-and-link' },
        _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)('pr-badge', 'badge', pr.state.toLowerCase()) },
          _react2.default.createElement(_octicon2.default, { icon: prStateToIcon[pr.state] }),
          pr.state.toLowerCase()
        ),
        _react2.default.createElement(
          'span',
          { className: 'pr-link' },
          _react2.default.createElement(
            'a',
            { className: 'pane-item-link', href: pr.url },
            repo.owner.login,
            '/',
            repo.name,
            '#',
            pr.number
          )
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'pr-avatar-and-title' },
        _react2.default.createElement(
          'a',
          { className: 'author-avatar-link', href: pr.author.url },
          _react2.default.createElement('img', { className: 'author-avatar', src: pr.author.avatarUrl, title: pr.author.login })
        ),
        _react2.default.createElement(
          'h3',
          { className: 'pr-title' },
          pr.title
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'conversation', onClick: this.handleClickPrLink },
        _react2.default.createElement(_octicon2.default, { icon: 'comment-discussion' }),
        'Conversation'
      ),
      _react2.default.createElement(
        'div',
        { className: 'commit-count' },
        _react2.default.createElement(_octicon2.default, { icon: 'git-commit' }),
        'Commits ',
        _react2.default.createElement(
          'span',
          { className: 'count-number' },
          pr.commits.totalCount
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'labels' },
        pr.labels.edges.map((_ref) => {
          let node = _ref.node;
          const name = node.name,
                color = node.color;

          const hex = `#${color}`;
          return _react2.default.createElement(
            'span',
            { key: name, className: 'label', style: { background: hex } },
            name
          );
        })
      ),
      _react2.default.createElement(
        'div',
        { className: 'reactions' },
        pr.reactionGroups.map(group => group.users.totalCount > 0 ? _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)('reaction-group', group.content.toLowerCase()), key: group.content },
          reactionTypeToEmoji[group.content],
          ' \xA0 ',
          group.users.totalCount
        ) : null)
      )
    );
  }

  renderPinnedPr() {
    return _react2.default.createElement(
      'div',
      { className: 'pinned-pr-info' },
      _react2.default.createElement(_octicon2.default, {
        title: 'This pull request has been manually pinned to this branch. Click here to select another PR.',
        icon: 'pin',
        className: 'pinned-by-url',
        onClick: this.handleUnpinClick
      }),
      _react2.default.createElement(
        'span',
        null,
        'This pull request has been manually pinned to the current branch. You may ',
        _react2.default.createElement(
          'a',
          { href: '#', onClick: this.handleUnpinClick },
          'unpin it'
        ),
        '.'
      )
    );
  }

  handleClickPrLink(event) {
    event.nativeEvent.preventDefault();
    event.nativeEvent.stopPropagation();
    const pr = this.props.pullRequest;
    const repo = pr.repository;
    atom.workspace.open(`atom-github://issueish/https://api.github.com/${repo.owner.login}/${repo.name}/${pr.number}`);
  }

  handleUnpinClick(event) {
    event.preventDefault();
    this.props.onUnpinPr && this.props.onUnpinPr();
  }
}, _class2.propTypes = {
  pinnedByUrl: _propTypes2.default.bool,
  onUnpinPr: _propTypes2.default.func,
  pullRequest: _propTypes2.default.shape({
    title: _propTypes2.default.string,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    repository: _propTypes2.default.shape({
      name: _propTypes2.default.string.isRequired,
      owner: _propTypes2.default.shape({
        login: _propTypes2.default.string
      })
    }),
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleClickPrLink', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleClickPrLink'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleUnpinClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleUnpinClick'), _class.prototype)), _class);
exports.default = _reactRelay2.default.createContainer(PrInfo, {
  fragments: {
    pullRequest: () => function () {
      return {
        children: [{
          fieldName: 'url',
          kind: 'Field',
          metadata: {},
          type: 'URI'
        }, {
          fieldName: 'number',
          kind: 'Field',
          metadata: {},
          type: 'Int'
        }, {
          fieldName: 'title',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          fieldName: 'state',
          kind: 'Field',
          metadata: {},
          type: 'PullRequestState'
        }, {
          fieldName: 'createdAt',
          kind: 'Field',
          metadata: {},
          type: 'DateTime'
        }, {
          children: [{
            fieldName: 'login',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'avatarUrl',
            kind: 'Field',
            metadata: {},
            type: 'URI'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }, {
            children: [{
              fieldName: 'url',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {},
            name: 'User',
            type: 'User'
          }, {
            children: [{
              fieldName: 'url',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {},
            name: 'Bot',
            type: 'Bot'
          }, {
            children: [{
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            id: _reactRelay2.default.QL.__id(),
            kind: 'Fragment',
            metadata: {
              isAbstract: true
            },
            name: 'IdFragment',
            type: 'Node'
          }],
          fieldName: 'author',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id',
            isAbstract: true
          },
          type: 'Actor'
        }, {
          children: [{
            fieldName: 'name',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            fieldName: 'owner',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'RepositoryOwner'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          fieldName: 'repository',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Repository'
        }, {
          children: [{
            fieldName: 'content',
            kind: 'Field',
            metadata: {},
            type: 'ReactionContent'
          }, {
            children: [{
              fieldName: 'totalCount',
              kind: 'Field',
              metadata: {},
              type: 'Int'
            }],
            fieldName: 'users',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isConnection: true
            },
            type: 'ReactingUserConnection'
          }],
          fieldName: 'reactionGroups',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isPlural: true
          },
          type: 'ReactionGroup'
        }, {
          children: [{
            fieldName: 'totalCount',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }],
          fieldName: 'commits',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'PullRequestCommitConnection'
        }, {
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'first',
            value: {
              kind: 'CallValue',
              callValue: 100
            }
          }],
          children: [{
            children: [{
              children: [{
                fieldName: 'name',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'color',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }],
              fieldName: 'node',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isRequisite: true
              },
              type: 'Label'
            }, {
              fieldName: 'cursor',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }],
            fieldName: 'edges',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'LabelEdge'
          }, {
            children: [{
              fieldName: 'hasNextPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }, {
              fieldName: 'hasPreviousPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }],
            fieldName: 'pageInfo',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isGenerated: true,
              isRequisite: true
            },
            type: 'PageInfo'
          }],
          fieldName: 'labels',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'LabelConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Pr_PullRequestRelayQL',
        type: 'PullRequest'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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