'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueishLookupByNumber = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _issueishPaneItemContainer = require('./issueish-pane-item-container');

var _issueishPaneItemContainer2 = _interopRequireDefault(_issueishPaneItemContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let IssueishLookupByNumber = exports.IssueishLookupByNumber = (_class = (_temp = _class2 = class IssueishLookupByNumber extends _react2.default.Component {

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const repository = this.props.query.repository;

    if (repository && repository.issueish) {
      var _props$relay$variable = this.props.relay.variables;
      const repoOwner = _props$relay$variable.repoOwner,
            repoName = _props$relay$variable.repoName,
            issueishNumber = _props$relay$variable.issueishNumber;
      // eslint-disable-next-line no-irregular-whitespace

      let title = `${repoOwner}/${repoName}#${issueishNumber} — ${repository.issueish.title}`;
      if (repository.issueish.__typename === 'Issue') {
        title = 'Issue: ' + title;
      } else {
        title = 'PR: ' + title;
      }
      this.props.onTitleChange(title);
    }
  }

  render() {
    const repo = this.props.query.repository;
    if (!repo || !repo.issueish) {
      return _react2.default.createElement(
        'div',
        null,
        'Issue/PR #',
        this.props.relay.variables.issueishNumber,
        ' not found'
      ); // TODO: no PRs
    }
    return _react2.default.createElement(_issueishPaneItemContainer2.default, { repository: repo, issueish: repo.issueish, switchToIssueish: this.switchToIssueish });
  }

  switchToIssueish(repoOwner, repoName, issueishNumber) {
    this.props.relay.setVariables({ repoOwner, repoName, issueishNumber });
  }
}, _class2.propTypes = {
  onTitleChange: _propTypes2.default.func.isRequired,
  query: _propTypes2.default.shape({
    repository: _propTypes2.default.object
  }),
  relay: _propTypes2.default.shape({
    setVariables: _propTypes2.default.func.isRequired,
    variables: _propTypes2.default.shape({
      repoOwner: _propTypes2.default.string.isRequired,
      repoName: _propTypes2.default.string.isRequired,
      issueishNumber: _propTypes2.default.number.isRequired
    }).isRequired
  }).isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'switchToIssueish', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'switchToIssueish'), _class.prototype)), _class);
exports.default = _reactRelay2.default.createContainer(IssueishLookupByNumber, {
  initialVariables: {
    repoOwner: null,
    repoName: null,
    issueishNumber: null
  },

  // TOOD: remove issueish/PR hack once GraphQL is fixed
  fragments: {
    query: () => function (RQL_0, RQL_1, RQL_2) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'owner',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoOwner'
            }
          }, {
            kind: 'Call',
            metadata: {},
            name: 'name',
            value: {
              kind: 'CallVariable',
              callVariableName: 'repoName'
            }
          }],
          children: [].concat.apply([], [{
            alias: 'issueish',
            calls: [{
              kind: 'Call',
              metadata: {},
              name: 'number',
              value: {
                kind: 'CallVariable',
                callVariableName: 'issueishNumber'
              }
            }],
            children: [{
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [].concat.apply([], [{
                fieldName: 'title',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, _reactRelay2.default.QL.__frag(RQL_1)]),
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'Issue',
              type: 'Issue'
            }, {
              children: [].concat.apply([], [{
                fieldName: 'title',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, _reactRelay2.default.QL.__frag(RQL_2)]),
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {},
              name: 'PullRequest',
              type: 'PullRequest'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'issueOrPullRequest',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'IssueOrPullRequest'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, _reactRelay2.default.QL.__frag(RQL_0)]),
          fieldName: 'repository',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            inferredRootCallName: 'node',
            inferredPrimaryKey: 'id'
          },
          type: 'Repository'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_QueryRelayQL',
        type: 'Query'
      };
    }(_issueishPaneItemContainer2.default.getFragment('repository'), _issueishPaneItemContainer2.default.getFragment('issueish'), _issueishPaneItemContainer2.default.getFragment('issueish'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLWxvb2t1cC1ieS1udW1iZXItY29udGFpbmVyLmpzIl0sIm5hbWVzIjpbIklzc3VlaXNoTG9va3VwQnlOdW1iZXIiLCJDb21wb25lbnQiLCJjb21wb25lbnREaWRNb3VudCIsInVwZGF0ZVRpdGxlIiwiY29tcG9uZW50RGlkVXBkYXRlIiwicmVwb3NpdG9yeSIsInByb3BzIiwicXVlcnkiLCJpc3N1ZWlzaCIsInJlbGF5IiwidmFyaWFibGVzIiwicmVwb093bmVyIiwicmVwb05hbWUiLCJpc3N1ZWlzaE51bWJlciIsInRpdGxlIiwiX190eXBlbmFtZSIsIm9uVGl0bGVDaGFuZ2UiLCJyZW5kZXIiLCJyZXBvIiwic3dpdGNoVG9Jc3N1ZWlzaCIsInNldFZhcmlhYmxlcyIsInByb3BUeXBlcyIsImZ1bmMiLCJpc1JlcXVpcmVkIiwic2hhcGUiLCJvYmplY3QiLCJzdHJpbmciLCJudW1iZXIiLCJjcmVhdGVDb250YWluZXIiLCJpbml0aWFsVmFyaWFibGVzIiwiZnJhZ21lbnRzIiwiZ2V0RnJhZ21lbnQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOztBQUVBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztJQUVhQSxzQixXQUFBQSxzQixnQ0FBTixNQUFNQSxzQkFBTixTQUFxQyxnQkFBTUMsU0FBM0MsQ0FBcUQ7O0FBZ0IxREMsc0JBQW9CO0FBQ2xCLFNBQUtDLFdBQUw7QUFDRDs7QUFFREMsdUJBQXFCO0FBQ25CLFNBQUtELFdBQUw7QUFDRDs7QUFFREEsZ0JBQWM7QUFBQSxVQUNMRSxVQURLLEdBQ1MsS0FBS0MsS0FBTCxDQUFXQyxLQURwQixDQUNMRixVQURLOztBQUVaLFFBQUlBLGNBQWNBLFdBQVdHLFFBQTdCLEVBQXVDO0FBQUEsa0NBQ1MsS0FBS0YsS0FBTCxDQUFXRyxLQUFYLENBQWlCQyxTQUQxQjtBQUFBLFlBQzlCQyxTQUQ4Qix5QkFDOUJBLFNBRDhCO0FBQUEsWUFDbkJDLFFBRG1CLHlCQUNuQkEsUUFEbUI7QUFBQSxZQUNUQyxjQURTLHlCQUNUQSxjQURTO0FBRXJDOztBQUNBLFVBQUlDLFFBQVMsR0FBRUgsU0FBVSxJQUFHQyxRQUFTLElBQUdDLGNBQWUsTUFBS1IsV0FBV0csUUFBWCxDQUFvQk0sS0FBTSxFQUF0RjtBQUNBLFVBQUlULFdBQVdHLFFBQVgsQ0FBb0JPLFVBQXBCLEtBQW1DLE9BQXZDLEVBQWdEO0FBQzlDRCxnQkFBUSxZQUFZQSxLQUFwQjtBQUNELE9BRkQsTUFFTztBQUNMQSxnQkFBUSxTQUFTQSxLQUFqQjtBQUNEO0FBQ0QsV0FBS1IsS0FBTCxDQUFXVSxhQUFYLENBQXlCRixLQUF6QjtBQUNEO0FBQ0Y7O0FBRURHLFdBQVM7QUFDUCxVQUFNQyxPQUFPLEtBQUtaLEtBQUwsQ0FBV0MsS0FBWCxDQUFpQkYsVUFBOUI7QUFDQSxRQUFJLENBQUNhLElBQUQsSUFBUyxDQUFDQSxLQUFLVixRQUFuQixFQUE2QjtBQUMzQixhQUFPO0FBQUE7QUFBQTtBQUFBO0FBQWdCLGFBQUtGLEtBQUwsQ0FBV0csS0FBWCxDQUFpQkMsU0FBakIsQ0FBMkJHLGNBQTNDO0FBQUE7QUFBQSxPQUFQLENBRDJCLENBQ3dEO0FBQ3BGO0FBQ0QsV0FDRSxxRUFBMkIsWUFBWUssSUFBdkMsRUFBNkMsVUFBVUEsS0FBS1YsUUFBNUQsRUFBc0Usa0JBQWtCLEtBQUtXLGdCQUE3RixHQURGO0FBR0Q7O0FBR0RBLG1CQUFpQlIsU0FBakIsRUFBNEJDLFFBQTVCLEVBQXNDQyxjQUF0QyxFQUFzRDtBQUNwRCxTQUFLUCxLQUFMLENBQVdHLEtBQVgsQ0FBaUJXLFlBQWpCLENBQThCLEVBQUNULFNBQUQsRUFBWUMsUUFBWixFQUFzQkMsY0FBdEIsRUFBOUI7QUFDRDtBQXBEeUQsQyxVQUNuRFEsUyxHQUFZO0FBQ2pCTCxpQkFBZSxvQkFBVU0sSUFBVixDQUFlQyxVQURiO0FBRWpCaEIsU0FBTyxvQkFBVWlCLEtBQVYsQ0FBZ0I7QUFDckJuQixnQkFBWSxvQkFBVW9CO0FBREQsR0FBaEIsQ0FGVTtBQUtqQmhCLFNBQU8sb0JBQVVlLEtBQVYsQ0FBZ0I7QUFDckJKLGtCQUFjLG9CQUFVRSxJQUFWLENBQWVDLFVBRFI7QUFFckJiLGVBQVcsb0JBQVVjLEtBQVYsQ0FBZ0I7QUFDekJiLGlCQUFXLG9CQUFVZSxNQUFWLENBQWlCSCxVQURIO0FBRXpCWCxnQkFBVSxvQkFBVWMsTUFBVixDQUFpQkgsVUFGRjtBQUd6QlYsc0JBQWdCLG9CQUFVYyxNQUFWLENBQWlCSjtBQUhSLEtBQWhCLEVBSVJBO0FBTmtCLEdBQWhCLEVBT0pBO0FBWmMsQztrQkFzRE4scUJBQU1LLGVBQU4sQ0FBc0I1QixzQkFBdEIsRUFBOEM7QUFDM0Q2QixvQkFBa0I7QUFDaEJsQixlQUFXLElBREs7QUFFaEJDLGNBQVUsSUFGTTtBQUdoQkMsb0JBQWdCO0FBSEEsR0FEeUM7O0FBTzNEO0FBQ0FpQixhQUFXO0FBQ1R2QixXQUFPO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQSxNQUdDLG9DQUEwQndCLFdBQTFCLENBQXNDLFlBQXRDLENBSEQsRUFRSyxvQ0FBMEJBLFdBQTFCLENBQXNDLFVBQXRDLENBUkwsRUFZSyxvQ0FBMEJBLFdBQTFCLENBQXNDLFVBQXRDLENBWkw7QUFERTtBQVJnRCxDQUE5QyxDIiwiZmlsZSI6Imlzc3VlaXNoLWxvb2t1cC1ieS1udW1iZXItY29udGFpbmVyLmpzIiwic291cmNlUm9vdCI6Ii9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFJlbGF5IGZyb20gJ3JlYWN0LXJlbGF5JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICdjb3JlLWRlY29yYXRvcnMnO1xuXG5pbXBvcnQgSXNzdWVpc2hQYW5lSXRlbUNvbnRhaW5lciBmcm9tICcuL2lzc3VlaXNoLXBhbmUtaXRlbS1jb250YWluZXInO1xuXG5leHBvcnQgY2xhc3MgSXNzdWVpc2hMb29rdXBCeU51bWJlciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgb25UaXRsZUNoYW5nZTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBxdWVyeTogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIHJlcG9zaXRvcnk6IFByb3BUeXBlcy5vYmplY3QsXG4gICAgfSksXG4gICAgcmVsYXk6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBzZXRWYXJpYWJsZXM6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgICB2YXJpYWJsZXM6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIHJlcG9Pd25lcjogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICByZXBvTmFtZTogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgICBpc3N1ZWlzaE51bWJlcjogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuICAgICAgfSkuaXNSZXF1aXJlZCxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgdGhpcy51cGRhdGVUaXRsZSgpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKCkge1xuICAgIHRoaXMudXBkYXRlVGl0bGUoKTtcbiAgfVxuXG4gIHVwZGF0ZVRpdGxlKCkge1xuICAgIGNvbnN0IHtyZXBvc2l0b3J5fSA9IHRoaXMucHJvcHMucXVlcnk7XG4gICAgaWYgKHJlcG9zaXRvcnkgJiYgcmVwb3NpdG9yeS5pc3N1ZWlzaCkge1xuICAgICAgY29uc3Qge3JlcG9Pd25lciwgcmVwb05hbWUsIGlzc3VlaXNoTnVtYmVyfSA9IHRoaXMucHJvcHMucmVsYXkudmFyaWFibGVzO1xuICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWlycmVndWxhci13aGl0ZXNwYWNlXG4gICAgICBsZXQgdGl0bGUgPSBgJHtyZXBvT3duZXJ9LyR7cmVwb05hbWV9IyR7aXNzdWVpc2hOdW1iZXJ9IOKAlMKgJHtyZXBvc2l0b3J5Lmlzc3VlaXNoLnRpdGxlfWA7XG4gICAgICBpZiAocmVwb3NpdG9yeS5pc3N1ZWlzaC5fX3R5cGVuYW1lID09PSAnSXNzdWUnKSB7XG4gICAgICAgIHRpdGxlID0gJ0lzc3VlOiAnICsgdGl0bGU7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aXRsZSA9ICdQUjogJyArIHRpdGxlO1xuICAgICAgfVxuICAgICAgdGhpcy5wcm9wcy5vblRpdGxlQ2hhbmdlKHRpdGxlKTtcbiAgICB9XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3QgcmVwbyA9IHRoaXMucHJvcHMucXVlcnkucmVwb3NpdG9yeTtcbiAgICBpZiAoIXJlcG8gfHwgIXJlcG8uaXNzdWVpc2gpIHtcbiAgICAgIHJldHVybiA8ZGl2Pklzc3VlL1BSICN7dGhpcy5wcm9wcy5yZWxheS52YXJpYWJsZXMuaXNzdWVpc2hOdW1iZXJ9IG5vdCBmb3VuZDwvZGl2PjsgLy8gVE9ETzogbm8gUFJzXG4gICAgfVxuICAgIHJldHVybiAoXG4gICAgICA8SXNzdWVpc2hQYW5lSXRlbUNvbnRhaW5lciByZXBvc2l0b3J5PXtyZXBvfSBpc3N1ZWlzaD17cmVwby5pc3N1ZWlzaH0gc3dpdGNoVG9Jc3N1ZWlzaD17dGhpcy5zd2l0Y2hUb0lzc3VlaXNofSAvPlxuICAgICk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgc3dpdGNoVG9Jc3N1ZWlzaChyZXBvT3duZXIsIHJlcG9OYW1lLCBpc3N1ZWlzaE51bWJlcikge1xuICAgIHRoaXMucHJvcHMucmVsYXkuc2V0VmFyaWFibGVzKHtyZXBvT3duZXIsIHJlcG9OYW1lLCBpc3N1ZWlzaE51bWJlcn0pO1xuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IFJlbGF5LmNyZWF0ZUNvbnRhaW5lcihJc3N1ZWlzaExvb2t1cEJ5TnVtYmVyLCB7XG4gIGluaXRpYWxWYXJpYWJsZXM6IHtcbiAgICByZXBvT3duZXI6IG51bGwsXG4gICAgcmVwb05hbWU6IG51bGwsXG4gICAgaXNzdWVpc2hOdW1iZXI6IG51bGwsXG4gIH0sXG5cbiAgLy8gVE9PRDogcmVtb3ZlIGlzc3VlaXNoL1BSIGhhY2sgb25jZSBHcmFwaFFMIGlzIGZpeGVkXG4gIGZyYWdtZW50czoge1xuICAgIHF1ZXJ5OiAoKSA9PiBSZWxheS5RTGBcbiAgICAgIGZyYWdtZW50IG9uIFF1ZXJ5IHtcbiAgICAgICAgcmVwb3NpdG9yeShvd25lcjogJHJlcG9Pd25lciwgbmFtZTogJHJlcG9OYW1lKSB7XG4gICAgICAgICAgJHtJc3N1ZWlzaFBhbmVJdGVtQ29udGFpbmVyLmdldEZyYWdtZW50KCdyZXBvc2l0b3J5Jyl9XG4gICAgICAgICAgaXNzdWVpc2g6aXNzdWVPclB1bGxSZXF1ZXN0KG51bWJlcjogJGlzc3VlaXNoTnVtYmVyKSB7XG4gICAgICAgICAgICBfX3R5cGVuYW1lXG4gICAgICAgICAgICAuLi4gb24gSXNzdWUge1xuICAgICAgICAgICAgICB0aXRsZVxuICAgICAgICAgICAgICAke0lzc3VlaXNoUGFuZUl0ZW1Db250YWluZXIuZ2V0RnJhZ21lbnQoJ2lzc3VlaXNoJyl9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICAuLi4gb24gUHVsbFJlcXVlc3Qge1xuICAgICAgICAgICAgICB0aXRsZVxuICAgICAgICAgICAgICAke0lzc3VlaXNoUGFuZUl0ZW1Db250YWluZXIuZ2V0RnJhZ21lbnQoJ2lzc3VlaXNoJyl9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgYCxcbiAgfSxcbn0pO1xuIl19