'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _eventKit = require('event-kit');

let StubItem = (_temp = _class = class StubItem {

  // StubItems should only be created by `create` and never constructed directly.
  static create(selector, props) {
    const stub = new StubItem(selector, props);
    const override = {
      _getStub: () => stub,
      getElement: () => stub.getElement(),
      destroy: stub.destroy.bind(stub)
    };
    const proxy = new Proxy(override, {
      get(target, name) {
        const item = stub.getRealItem();
        if (Reflect.has(target, name)) {
          return target[name];
        } else if (item && Reflect.has(item, name)) {
          let val = item[name];
          if (typeof val === 'function') {
            val = val.bind(item);
          }
          return val;
        } else {
          let val = stub[name];
          if (typeof val === 'function') {
            val = val.bind(stub);
          }
          return val;
        }
      }
    });
    this.stubsBySelector.set(selector, proxy);
    return proxy;
  }

  static getBySelector(selector) {
    return this.stubsBySelector.get(selector);
  }

  static getElementBySelector(selector) {
    const stub = this.getBySelector(selector);
    if (stub) {
      return stub.getElement();
    } else {
      return null;
    }
  }

  constructor(selector) {
    let props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    this.emitter = new _eventKit.Emitter();
    this.subscriptions = new _eventKit.CompositeDisposable();

    this.selector = selector;
    this.props = props;
    this.element = document.createElement('div');
    this.element.classList.add(`github-StubItem-${selector}`);
    this.realItem = null;
  }

  setRealItem(item) {
    var _this = this;

    this.realItem = item;
    this.emitter.emit('did-change-title');
    this.emitter.emit('did-change-icon');

    if (item.onDidChangeTitle) {
      this.subscriptions.add(item.onDidChangeTitle(function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return _this.emitter.emit('did-change-title', ...args);
      }));
    }

    if (item.onDidChangeIcon) {
      this.subscriptions.add(item.onDidChangeIcon(function () {
        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        return _this.emitter.emit('did-change-icon', ...args);
      }));
    }

    if (item.onDidDestroy) {
      this.subscriptions.add(item.onDidDestroy(function () {
        for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
          args[_key3] = arguments[_key3];
        }

        _this.realItem = null;
        _this.emitter.emit('did-destroy', ...args);
      }));
    }
  }

  getRealItem() {
    return this.realItem;
  }

  getTitle() {
    return this.props.title || null;
  }

  getIconName() {
    return this.props.iconName || null;
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  onDidChangeIcon(cb) {
    return this.emitter.on('did-change-icon', cb);
  }

  getElement() {
    return this.element;
  }

  onDidDestroy(cb) {
    return this.emitter.on('did-destroy', cb);
  }

  destroy() {
    this.subscriptions.dispose();
    this.emitter.dispose();
    StubItem.stubsBySelector.delete(this.selector);
    if (this.actualItem) {
      this.actualItem.destroy && this.actualItem.destroy();
    }
  }
}, _class.stubsBySelector = new Map(), _temp);
exports.default = StubItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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