'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _issueishTooltipRoute = require('../routes/issueish-tooltip-route');

var _issueishTooltipRoute2 = _interopRequireDefault(_issueishTooltipRoute);

var _issueishTooltipContainer = require('../containers/issueish-tooltip-container');

var _issueishTooltipContainer2 = _interopRequireDefault(_issueishTooltipContainer);

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let IssueishTooltipItem = class IssueishTooltipItem {
  constructor(issueishUrl, relayEnvironment) {
    this.issueishUrl = issueishUrl;
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      const route = new _issueishTooltipRoute2.default({ issueishUrl: this.issueishUrl });
      this._element = document.createElement('div');
      const rootContainer = _react2.default.createElement(_relayRootContainer2.default, {
        Component: _issueishTooltipContainer2.default,
        route: route,
        environment: this.relayEnvironment,
        renderLoading: () => {
          // TODO: adjust min width/height
          return _react2.default.createElement(
            'div',
            { className: 'github-Loader' },
            _react2.default.createElement('span', { className: 'github-Spinner' })
          );
        },
        renderFailure: () => _react2.default.createElement(
          'div',
          null,
          'Could not load information'
        )
      });
      this._component = _reactDom2.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom2.default.unmountComponentAtNode(this._element);
      delete this._element;
    }
  }
};
exports.default = IssueishTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLXRvb2x0aXAtaXRlbS5qcyJdLCJuYW1lcyI6WyJJc3N1ZWlzaFRvb2x0aXBJdGVtIiwiY29uc3RydWN0b3IiLCJpc3N1ZWlzaFVybCIsInJlbGF5RW52aXJvbm1lbnQiLCJnZXRFbGVtZW50IiwiZWxlbWVudCIsIl9lbGVtZW50Iiwicm91dGUiLCJkb2N1bWVudCIsImNyZWF0ZUVsZW1lbnQiLCJyb290Q29udGFpbmVyIiwiX2NvbXBvbmVudCIsInJlbmRlciIsImRlc3Ryb3kiLCJ1bm1vdW50Q29tcG9uZW50QXROb2RlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7QUFDQTs7OztBQUVBOzs7O0FBQ0E7Ozs7QUFDQTs7Ozs7O0lBRXFCQSxtQixHQUFOLE1BQU1BLG1CQUFOLENBQTBCO0FBQ3ZDQyxjQUFZQyxXQUFaLEVBQXlCQyxnQkFBekIsRUFBMkM7QUFDekMsU0FBS0QsV0FBTCxHQUFtQkEsV0FBbkI7QUFDQSxTQUFLQyxnQkFBTCxHQUF3QkEsZ0JBQXhCO0FBQ0Q7O0FBRURDLGVBQWE7QUFDWCxXQUFPLEtBQUtDLE9BQVo7QUFDRDs7QUFFRCxNQUFJQSxPQUFKLEdBQWM7QUFDWixRQUFJLENBQUMsS0FBS0MsUUFBVixFQUFvQjtBQUNsQixZQUFNQyxRQUFRLG1DQUF5QixFQUFDTCxhQUFhLEtBQUtBLFdBQW5CLEVBQXpCLENBQWQ7QUFDQSxXQUFLSSxRQUFMLEdBQWdCRSxTQUFTQyxhQUFULENBQXVCLEtBQXZCLENBQWhCO0FBQ0EsWUFBTUMsZ0JBQ0o7QUFDRSxxREFERjtBQUVFLGVBQU9ILEtBRlQ7QUFHRSxxQkFBYSxLQUFLSixnQkFIcEI7QUFJRSx1QkFBZSxNQUFNO0FBQ25CO0FBQ0EsaUJBQ0U7QUFBQTtBQUFBLGNBQUssV0FBVSxlQUFmO0FBQ0Usb0RBQU0sV0FBVSxnQkFBaEI7QUFERixXQURGO0FBS0QsU0FYSDtBQVlFLHVCQUFlLE1BQU07QUFBQTtBQUFBO0FBQUE7QUFBQTtBQVp2QixRQURGO0FBZ0JBLFdBQUtRLFVBQUwsR0FBa0IsbUJBQVNDLE1BQVQsQ0FBZ0JGLGFBQWhCLEVBQStCLEtBQUtKLFFBQXBDLENBQWxCO0FBQ0Q7O0FBRUQsV0FBTyxLQUFLQSxRQUFaO0FBQ0Q7O0FBRURPLFlBQVU7QUFDUixRQUFJLEtBQUtQLFFBQVQsRUFBbUI7QUFDakIseUJBQVNRLHNCQUFULENBQWdDLEtBQUtSLFFBQXJDO0FBQ0EsYUFBTyxLQUFLQSxRQUFaO0FBQ0Q7QUFDRjtBQXpDc0MsQztrQkFBcEJOLG1CIiwiZmlsZSI6Imlzc3VlaXNoLXRvb2x0aXAtaXRlbS5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS9hbmRyZWkvYXRvbS0xLjE5LjIvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBSZWFjdERvbSBmcm9tICdyZWFjdC1kb20nO1xuXG5pbXBvcnQgSXNzdWVpc2hUb29sdGlwUm91dGUgZnJvbSAnLi4vcm91dGVzL2lzc3VlaXNoLXRvb2x0aXAtcm91dGUnO1xuaW1wb3J0IElzc3VlaXNoQ29udGFpbmVyIGZyb20gJy4uL2NvbnRhaW5lcnMvaXNzdWVpc2gtdG9vbHRpcC1jb250YWluZXInO1xuaW1wb3J0IFJlbGF5Um9vdENvbnRhaW5lciBmcm9tICcuLi9jb250YWluZXJzL3JlbGF5LXJvb3QtY29udGFpbmVyJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgSXNzdWVpc2hUb29sdGlwSXRlbSB7XG4gIGNvbnN0cnVjdG9yKGlzc3VlaXNoVXJsLCByZWxheUVudmlyb25tZW50KSB7XG4gICAgdGhpcy5pc3N1ZWlzaFVybCA9IGlzc3VlaXNoVXJsO1xuICAgIHRoaXMucmVsYXlFbnZpcm9ubWVudCA9IHJlbGF5RW52aXJvbm1lbnQ7XG4gIH1cblxuICBnZXRFbGVtZW50KCkge1xuICAgIHJldHVybiB0aGlzLmVsZW1lbnQ7XG4gIH1cblxuICBnZXQgZWxlbWVudCgpIHtcbiAgICBpZiAoIXRoaXMuX2VsZW1lbnQpIHtcbiAgICAgIGNvbnN0IHJvdXRlID0gbmV3IElzc3VlaXNoVG9vbHRpcFJvdXRlKHtpc3N1ZWlzaFVybDogdGhpcy5pc3N1ZWlzaFVybH0pO1xuICAgICAgdGhpcy5fZWxlbWVudCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpO1xuICAgICAgY29uc3Qgcm9vdENvbnRhaW5lciA9IChcbiAgICAgICAgPFJlbGF5Um9vdENvbnRhaW5lclxuICAgICAgICAgIENvbXBvbmVudD17SXNzdWVpc2hDb250YWluZXJ9XG4gICAgICAgICAgcm91dGU9e3JvdXRlfVxuICAgICAgICAgIGVudmlyb25tZW50PXt0aGlzLnJlbGF5RW52aXJvbm1lbnR9XG4gICAgICAgICAgcmVuZGVyTG9hZGluZz17KCkgPT4ge1xuICAgICAgICAgICAgLy8gVE9ETzogYWRqdXN0IG1pbiB3aWR0aC9oZWlnaHRcbiAgICAgICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLUxvYWRlclwiPlxuICAgICAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1TcGlubmVyXCIgLz5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICApO1xuICAgICAgICAgIH19XG4gICAgICAgICAgcmVuZGVyRmFpbHVyZT17KCkgPT4gPGRpdj5Db3VsZCBub3QgbG9hZCBpbmZvcm1hdGlvbjwvZGl2Pn1cbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgICB0aGlzLl9jb21wb25lbnQgPSBSZWFjdERvbS5yZW5kZXIocm9vdENvbnRhaW5lciwgdGhpcy5fZWxlbWVudCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuX2VsZW1lbnQ7XG4gIH1cblxuICBkZXN0cm95KCkge1xuICAgIGlmICh0aGlzLl9lbGVtZW50KSB7XG4gICAgICBSZWFjdERvbS51bm1vdW50Q29tcG9uZW50QXROb2RlKHRoaXMuX2VsZW1lbnQpO1xuICAgICAgZGVsZXRlIHRoaXMuX2VsZW1lbnQ7XG4gICAgfVxuICB9XG59XG4iXX0=