'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _eventKit = require('event-kit');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _coreDecorators = require('core-decorators');

var _issueishPaneItemController = require('../controllers/issueish-pane-item-controller');

var _issueishPaneItemController2 = _interopRequireDefault(_issueishPaneItemController);

var _githubLoginModel = require('../models/github-login-model');

var _githubLoginModel2 = _interopRequireDefault(_githubLoginModel);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function getPropsFromUri(uri) {
  // atom-github://issueish/https://github-host.tld/owner/repo/issueishNumber
  var _url$parse = _url2.default.parse(uri);

  const protocol = _url$parse.protocol,
        hostname = _url$parse.hostname,
        pathname = _url$parse.pathname;

  if (protocol === 'atom-github:' && hostname === 'issueish') {
    var _pathname$split$filte = pathname.split('/').filter(s => s),
        _pathname$split$filte2 = _slicedToArray(_pathname$split$filte, 5);

    const scheme = _pathname$split$filte2[0],
          host = _pathname$split$filte2[1],
          owner = _pathname$split$filte2[2],
          repo = _pathname$split$filte2[3],
          issueishNum = _pathname$split$filte2[4];

    if (!scheme || !host || !owner || !repo || !issueishNum) {
      return null;
    }
    const issueishNumber = parseInt(issueishNum, 10);
    if (isNaN(issueishNumber)) {
      return null;
    }
    return { owner, repo, issueishNumber, host: `${scheme}//${host}` };
  }
  return null;
}

let IssueishPaneItem = (_class = class IssueishPaneItem {
  static opener(uri) {
    const props = getPropsFromUri(uri);
    if (props) {
      return IssueishPaneItem.create(props, uri);
    } else {
      return null;
    }
  }

  static create(_ref, uri) {
    let owner = _ref.owner,
        repo = _ref.repo,
        issueishNumber = _ref.issueishNumber,
        host = _ref.host;

    return new IssueishPaneItem({ owner, repo, issueishNumber, host }, uri);
  }

  constructor(_ref2, uri) {
    let owner = _ref2.owner,
        repo = _ref2.repo,
        issueishNumber = _ref2.issueishNumber,
        host = _ref2.host;

    this.emitter = new _eventKit.Emitter();

    this.owner = owner;
    this.repo = repo;
    this.issueishNumber = issueishNumber;
    this.host = host;
    this.uri = uri;
    this.title = `${this.owner}/${this.repo}#${this.issueishNumber}`;

    this.createComponent();
  }

  createComponent() {
    this.element = document.createElement('div');
    const loginModel = _githubLoginModel2.default.get();
    const props = {
      owner: this.owner,
      repo: this.repo,
      issueishNumber: this.issueishNumber,
      host: this.host,
      onTitleChange: this.handleTitleChanged,
      loginModel
    };
    this.component = _reactDom2.default.render(_react2.default.createElement(_issueishPaneItemController2.default, props), this.element);
  }

  handleTitleChanged(title) {
    if (this.title !== title) {
      this.title = title;
      this.emitter.emit('did-change-title', title);
    }
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  getElement() {
    return this.element;
  }

  serialize() {
    return {
      uri: this.uri,
      deserializer: 'IssueishPaneItem'
    };
  }

  getURI() {
    return this.uri;
  }

  getTitle() {
    return this.title;
  }

  destroy() {
    // TODO: is this right?
    this.emitter.dispose();
    _reactDom2.default.unmountComponentAtNode(this.getElement());
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'handleTitleChanged', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleTitleChanged'), _class.prototype)), _class);
exports.default = IssueishPaneItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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