"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

let Task = class Task {
  constructor(fn) {
    let parallel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

    this.fn = fn;
    this.parallel = parallel;
    this.promise = new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    });
  }

  execute() {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        const value = yield _this.fn.call(undefined);
        _this.resolve(value);
      } catch (err) {
        _this.reject(err);
      }
    })();
  }

  runsInParallel() {
    return this.parallel;
  }

  runsInSerial() {
    return !this.parallel;
  }

  getPromise() {
    return this.promise;
  }
};
let AsyncQueue = class AsyncQueue {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    this.parallelism = options.parallelism || 1;
    this.nonParallelizableOperation = false;
    this.tasksInProgress = 0;
    this.queue = [];
  }

  push(fn) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { parallel: true };

    let parallel = _ref.parallel;

    const task = new Task(fn, parallel);
    this.queue.push(task);
    this.processQueue();
    return task.getPromise();
  }

  processQueue() {
    if (!this.queue.length || this.nonParallelizableOperation || this.disposed) {
      return;
    }

    const task = this.queue[0];
    const canRunParallelOp = task.runsInParallel() && this.tasksInProgress < this.parallelism;
    const canRunSerialOp = task.runsInSerial() && this.tasksInProgress === 0;
    if (canRunSerialOp || canRunParallelOp) {
      this.processTask(task, task.runsInParallel());
      this.queue.shift();
      this.processQueue();
    }
  }

  processTask(task, runsInParallel) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2.disposed) {
        return;
      }

      _this2.tasksInProgress++;
      if (!runsInParallel) {
        _this2.nonParallelizableOperation = true;
      }

      try {
        yield task.execute();
      } finally {
        _this2.tasksInProgress--;
        _this2.nonParallelizableOperation = false;
        _this2.processQueue();
      }
    })();
  }

  dispose() {
    this.queue = [];
    this.disposed = true;
  }
};
exports.default = AsyncQueue;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzeW5jLXF1ZXVlLmpzIl0sIm5hbWVzIjpbIlRhc2siLCJjb25zdHJ1Y3RvciIsImZuIiwicGFyYWxsZWwiLCJwcm9taXNlIiwiUHJvbWlzZSIsInJlc29sdmUiLCJyZWplY3QiLCJleGVjdXRlIiwidmFsdWUiLCJjYWxsIiwidW5kZWZpbmVkIiwiZXJyIiwicnVuc0luUGFyYWxsZWwiLCJydW5zSW5TZXJpYWwiLCJnZXRQcm9taXNlIiwiQXN5bmNRdWV1ZSIsIm9wdGlvbnMiLCJwYXJhbGxlbGlzbSIsIm5vblBhcmFsbGVsaXphYmxlT3BlcmF0aW9uIiwidGFza3NJblByb2dyZXNzIiwicXVldWUiLCJwdXNoIiwidGFzayIsInByb2Nlc3NRdWV1ZSIsImxlbmd0aCIsImRpc3Bvc2VkIiwiY2FuUnVuUGFyYWxsZWxPcCIsImNhblJ1blNlcmlhbE9wIiwicHJvY2Vzc1Rhc2siLCJzaGlmdCIsImRpc3Bvc2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0lBQU1BLEksR0FBTixNQUFNQSxJQUFOLENBQVc7QUFDVEMsY0FBWUMsRUFBWixFQUFpQztBQUFBLFFBQWpCQyxRQUFpQix1RUFBTixJQUFNOztBQUMvQixTQUFLRCxFQUFMLEdBQVVBLEVBQVY7QUFDQSxTQUFLQyxRQUFMLEdBQWdCQSxRQUFoQjtBQUNBLFNBQUtDLE9BQUwsR0FBZSxJQUFJQyxPQUFKLENBQVksQ0FBQ0MsT0FBRCxFQUFVQyxNQUFWLEtBQXFCO0FBQzlDLFdBQUtELE9BQUwsR0FBZUEsT0FBZjtBQUNBLFdBQUtDLE1BQUwsR0FBY0EsTUFBZDtBQUNELEtBSGMsQ0FBZjtBQUlEOztBQUVLQyxTQUFOLEdBQWdCO0FBQUE7O0FBQUE7QUFDZCxVQUFJO0FBQ0YsY0FBTUMsUUFBUSxNQUFNLE1BQUtQLEVBQUwsQ0FBUVEsSUFBUixDQUFhQyxTQUFiLENBQXBCO0FBQ0EsY0FBS0wsT0FBTCxDQUFhRyxLQUFiO0FBQ0QsT0FIRCxDQUdFLE9BQU9HLEdBQVAsRUFBWTtBQUNaLGNBQUtMLE1BQUwsQ0FBWUssR0FBWjtBQUNEO0FBTmE7QUFPZjs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxLQUFLVixRQUFaO0FBQ0Q7O0FBRURXLGlCQUFlO0FBQ2IsV0FBTyxDQUFDLEtBQUtYLFFBQWI7QUFDRDs7QUFFRFksZUFBYTtBQUNYLFdBQU8sS0FBS1gsT0FBWjtBQUNEO0FBN0JRLEM7SUFnQ1VZLFUsR0FBTixNQUFNQSxVQUFOLENBQWlCO0FBQzlCZixnQkFBMEI7QUFBQSxRQUFkZ0IsT0FBYyx1RUFBSixFQUFJOztBQUN4QixTQUFLQyxXQUFMLEdBQW1CRCxRQUFRQyxXQUFSLElBQXVCLENBQTFDO0FBQ0EsU0FBS0MsMEJBQUwsR0FBa0MsS0FBbEM7QUFDQSxTQUFLQyxlQUFMLEdBQXVCLENBQXZCO0FBQ0EsU0FBS0MsS0FBTCxHQUFhLEVBQWI7QUFDRDs7QUFFREMsT0FBS3BCLEVBQUwsRUFBd0M7QUFBQSxtRkFBbEIsRUFBQ0MsVUFBVSxJQUFYLEVBQWtCOztBQUFBLFFBQTlCQSxRQUE4QixRQUE5QkEsUUFBOEI7O0FBQ3RDLFVBQU1vQixPQUFPLElBQUl2QixJQUFKLENBQVNFLEVBQVQsRUFBYUMsUUFBYixDQUFiO0FBQ0EsU0FBS2tCLEtBQUwsQ0FBV0MsSUFBWCxDQUFnQkMsSUFBaEI7QUFDQSxTQUFLQyxZQUFMO0FBQ0EsV0FBT0QsS0FBS1IsVUFBTCxFQUFQO0FBQ0Q7O0FBRURTLGlCQUFlO0FBQ2IsUUFBSSxDQUFDLEtBQUtILEtBQUwsQ0FBV0ksTUFBWixJQUFzQixLQUFLTiwwQkFBM0IsSUFBeUQsS0FBS08sUUFBbEUsRUFBNEU7QUFBRTtBQUFTOztBQUV2RixVQUFNSCxPQUFPLEtBQUtGLEtBQUwsQ0FBVyxDQUFYLENBQWI7QUFDQSxVQUFNTSxtQkFBbUJKLEtBQUtWLGNBQUwsTUFBeUIsS0FBS08sZUFBTCxHQUF1QixLQUFLRixXQUE5RTtBQUNBLFVBQU1VLGlCQUFpQkwsS0FBS1QsWUFBTCxNQUF1QixLQUFLTSxlQUFMLEtBQXlCLENBQXZFO0FBQ0EsUUFBSVEsa0JBQWtCRCxnQkFBdEIsRUFBd0M7QUFDdEMsV0FBS0UsV0FBTCxDQUFpQk4sSUFBakIsRUFBdUJBLEtBQUtWLGNBQUwsRUFBdkI7QUFDQSxXQUFLUSxLQUFMLENBQVdTLEtBQVg7QUFDQSxXQUFLTixZQUFMO0FBQ0Q7QUFDRjs7QUFFS0ssYUFBTixDQUFrQk4sSUFBbEIsRUFBd0JWLGNBQXhCLEVBQXdDO0FBQUE7O0FBQUE7QUFDdEMsVUFBSSxPQUFLYSxRQUFULEVBQW1CO0FBQUU7QUFBUzs7QUFFOUIsYUFBS04sZUFBTDtBQUNBLFVBQUksQ0FBQ1AsY0FBTCxFQUFxQjtBQUNuQixlQUFLTSwwQkFBTCxHQUFrQyxJQUFsQztBQUNEOztBQUVELFVBQUk7QUFDRixjQUFNSSxLQUFLZixPQUFMLEVBQU47QUFDRCxPQUZELFNBRVU7QUFDUixlQUFLWSxlQUFMO0FBQ0EsZUFBS0QsMEJBQUwsR0FBa0MsS0FBbEM7QUFDQSxlQUFLSyxZQUFMO0FBQ0Q7QUFkcUM7QUFldkM7O0FBRURPLFlBQVU7QUFDUixTQUFLVixLQUFMLEdBQWEsRUFBYjtBQUNBLFNBQUtLLFFBQUwsR0FBZ0IsSUFBaEI7QUFDRDtBQWhENkIsQztrQkFBWFYsVSIsImZpbGUiOiJhc3luYy1xdWV1ZS5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS9hbmRyZWkvYXRvbS0xLjE5LjIvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiY2xhc3MgVGFzayB7XG4gIGNvbnN0cnVjdG9yKGZuLCBwYXJhbGxlbCA9IHRydWUpIHtcbiAgICB0aGlzLmZuID0gZm47XG4gICAgdGhpcy5wYXJhbGxlbCA9IHBhcmFsbGVsO1xuICAgIHRoaXMucHJvbWlzZSA9IG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgIHRoaXMucmVzb2x2ZSA9IHJlc29sdmU7XG4gICAgICB0aGlzLnJlamVjdCA9IHJlamVjdDtcbiAgICB9KTtcbiAgfVxuXG4gIGFzeW5jIGV4ZWN1dGUoKSB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHZhbHVlID0gYXdhaXQgdGhpcy5mbi5jYWxsKHVuZGVmaW5lZCk7XG4gICAgICB0aGlzLnJlc29sdmUodmFsdWUpO1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgdGhpcy5yZWplY3QoZXJyKTtcbiAgICB9XG4gIH1cblxuICBydW5zSW5QYXJhbGxlbCgpIHtcbiAgICByZXR1cm4gdGhpcy5wYXJhbGxlbDtcbiAgfVxuXG4gIHJ1bnNJblNlcmlhbCgpIHtcbiAgICByZXR1cm4gIXRoaXMucGFyYWxsZWw7XG4gIH1cblxuICBnZXRQcm9taXNlKCkge1xuICAgIHJldHVybiB0aGlzLnByb21pc2U7XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQXN5bmNRdWV1ZSB7XG4gIGNvbnN0cnVjdG9yKG9wdGlvbnMgPSB7fSkge1xuICAgIHRoaXMucGFyYWxsZWxpc20gPSBvcHRpb25zLnBhcmFsbGVsaXNtIHx8IDE7XG4gICAgdGhpcy5ub25QYXJhbGxlbGl6YWJsZU9wZXJhdGlvbiA9IGZhbHNlO1xuICAgIHRoaXMudGFza3NJblByb2dyZXNzID0gMDtcbiAgICB0aGlzLnF1ZXVlID0gW107XG4gIH1cblxuICBwdXNoKGZuLCB7cGFyYWxsZWx9ID0ge3BhcmFsbGVsOiB0cnVlfSkge1xuICAgIGNvbnN0IHRhc2sgPSBuZXcgVGFzayhmbiwgcGFyYWxsZWwpO1xuICAgIHRoaXMucXVldWUucHVzaCh0YXNrKTtcbiAgICB0aGlzLnByb2Nlc3NRdWV1ZSgpO1xuICAgIHJldHVybiB0YXNrLmdldFByb21pc2UoKTtcbiAgfVxuXG4gIHByb2Nlc3NRdWV1ZSgpIHtcbiAgICBpZiAoIXRoaXMucXVldWUubGVuZ3RoIHx8IHRoaXMubm9uUGFyYWxsZWxpemFibGVPcGVyYXRpb24gfHwgdGhpcy5kaXNwb3NlZCkgeyByZXR1cm47IH1cblxuICAgIGNvbnN0IHRhc2sgPSB0aGlzLnF1ZXVlWzBdO1xuICAgIGNvbnN0IGNhblJ1blBhcmFsbGVsT3AgPSB0YXNrLnJ1bnNJblBhcmFsbGVsKCkgJiYgdGhpcy50YXNrc0luUHJvZ3Jlc3MgPCB0aGlzLnBhcmFsbGVsaXNtO1xuICAgIGNvbnN0IGNhblJ1blNlcmlhbE9wID0gdGFzay5ydW5zSW5TZXJpYWwoKSAmJiB0aGlzLnRhc2tzSW5Qcm9ncmVzcyA9PT0gMDtcbiAgICBpZiAoY2FuUnVuU2VyaWFsT3AgfHwgY2FuUnVuUGFyYWxsZWxPcCkge1xuICAgICAgdGhpcy5wcm9jZXNzVGFzayh0YXNrLCB0YXNrLnJ1bnNJblBhcmFsbGVsKCkpO1xuICAgICAgdGhpcy5xdWV1ZS5zaGlmdCgpO1xuICAgICAgdGhpcy5wcm9jZXNzUXVldWUoKTtcbiAgICB9XG4gIH1cblxuICBhc3luYyBwcm9jZXNzVGFzayh0YXNrLCBydW5zSW5QYXJhbGxlbCkge1xuICAgIGlmICh0aGlzLmRpc3Bvc2VkKSB7IHJldHVybjsgfVxuXG4gICAgdGhpcy50YXNrc0luUHJvZ3Jlc3MrKztcbiAgICBpZiAoIXJ1bnNJblBhcmFsbGVsKSB7XG4gICAgICB0aGlzLm5vblBhcmFsbGVsaXphYmxlT3BlcmF0aW9uID0gdHJ1ZTtcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgYXdhaXQgdGFzay5leGVjdXRlKCk7XG4gICAgfSBmaW5hbGx5IHtcbiAgICAgIHRoaXMudGFza3NJblByb2dyZXNzLS07XG4gICAgICB0aGlzLm5vblBhcmFsbGVsaXphYmxlT3BlcmF0aW9uID0gZmFsc2U7XG4gICAgICB0aGlzLnByb2Nlc3NRdWV1ZSgpO1xuICAgIH1cbiAgfVxuXG4gIGRpc3Bvc2UoKSB7XG4gICAgdGhpcy5xdWV1ZSA9IFtdO1xuICAgIHRoaXMuZGlzcG9zZWQgPSB0cnVlO1xuICB9XG59XG4iXX0=