Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _helpers = require('./helpers');

var DiffListView = (function () {
  function DiffListView() {
    var _this = this;

    _classCallCheck(this, DiffListView);

    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No diffs in file',
      items: [],
      filterKeyForItem: function filterKeyForItem(diff) {
        return diff.lineText;
      },
      elementForItem: function elementForItem(diff) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = diff.lineText;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = '-' + diff.oldStart + ',' + diff.oldLines + ' +' + diff.newStart + ',' + diff.newLines;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(diff) {
        _this.cancel();
        var bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
        _this.editor.setCursorBufferPosition([bufferRow, 0], { autoscroll: true });
        _this.editor.moveToFirstCharacterOfLine();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('diff-list-view');
    this.panel = atom.workspace.addModalPanel({ item: this.selectListView, visible: false });
  }

  _createClass(DiffListView, [{
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.selectListView.reset();
      this.panel.show();
      this.selectListView.focus();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      this.panel.destroy();
      return this.selectListView.destroy();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      var editor = atom.workspace.getActiveTextEditor();
      if (this.panel.isVisible()) {
        this.cancel();
      } else if (editor) {
        this.editor = editor;
        var repository = (0, _helpers.repositoryForPath)(this.editor.getPath());
        var diffs = repository ? repository.getLineDiffs(this.editor.getPath(), this.editor.getText()) : [];
        if (!diffs) {
          diffs = [];
        }
        for (var diff of diffs) {
          var bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
          var lineText = this.editor.lineTextForBufferRow(bufferRow);
          diff.lineText = lineText ? lineText.trim() : '';
        }

        yield this.selectListView.update({ items: diffs });
        this.attach();
      }
    })
  }]);

  return DiffListView;
})();

exports['default'] = DiffListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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