Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

var _atom = require('atom');

var reporter = undefined;

function getReporter() {
  if (!reporter) {
    var Reporter = require('./reporter');
    reporter = new Reporter();
  }
  return reporter;
}

exports['default'] = {
  activate: function activate() {
    this.subscriptions = new _atom.CompositeDisposable();

    if (!atom.config.get('exception-reporting.userId')) {
      atom.config.set('exception-reporting.userId', require('node-uuid').v4());
    }

    this.subscriptions.add(atom.onDidThrowError(function (_ref) {
      var message = _ref.message;
      var url = _ref.url;
      var line = _ref.line;
      var column = _ref.column;
      var originalError = _ref.originalError;

      try {
        getReporter().reportUncaughtException(originalError);
      } catch (secondaryException) {
        try {
          console.error("Error reporting uncaught exception", secondaryException);
          getReporter().reportUncaughtException(secondaryException);
        } catch (error) {}
      }
    }));

    if (atom.onDidFailAssertion != null) {
      this.subscriptions.add(atom.onDidFailAssertion(function (error) {
        try {
          getReporter().reportFailedAssertion(error);
        } catch (secondaryException) {
          try {
            console.error("Error reporting assertion failure", secondaryException);
            getReporter().reportUncaughtException(secondaryException);
          } catch (error) {}
        }
      }));
    }
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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