Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var EncodingStatusView = (function () {
  function EncodingStatusView(statusBar, encodings) {
    var _this = this;

    _classCallCheck(this, EncodingStatusView);

    this.statusBar = statusBar;
    this.encodings = encodings;
    this.element = document.createElement('encoding-selector-status');
    this.element.classList.add('encoding-status', 'inline-block');
    this.encodingLink = document.createElement('a');
    this.encodingLink.classList.add('inline-block');
    this.encodingLink.href = '#';
    this.element.appendChild(this.encodingLink);

    // TODO[v1.19]: Remove conditional once atom.workspace.observeActiveTextEditor ships in Atom v1.19
    if (atom.workspace.observeActiveTextEditor) {
      this.activeItemSubscription = atom.workspace.observeActiveTextEditor(this.subscribeToActiveTextEditor.bind(this));
    } else {
      this.activeItemSubscription = atom.workspace.observeActivePaneItem(this.subscribeToActiveTextEditor.bind(this));
    }

    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      atom.commands.dispatch(atom.workspace.getActiveTextEditor().element, 'encoding-selector:show');
    };
    this.element.addEventListener('click', clickHandler);
    this.clickSubscription = new _atom.Disposable(function () {
      return _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(EncodingStatusView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.activeItemSubscription) {
        this.activeItemSubscription.dispose();
      }

      if (this.encodingSubscription) {
        this.encodingSubscription.dispose();
      }

      if (this.clickSubscription) {
        this.clickSubscription.dispose();
      }

      if (this.tile) {
        this.tile.destroy();
      }

      if (this.tooltip) {
        this.tooltip.dispose();
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.tile = this.statusBar.addRightTile({ priority: 11, item: this.element });
    }
  }, {
    key: 'subscribeToActiveTextEditor',
    value: function subscribeToActiveTextEditor() {
      if (this.encodingSubscription) {
        this.encodingSubscription.dispose();
      }

      var editor = atom.workspace.getActiveTextEditor();
      if (editor) {
        this.encodingSubscription = editor.onDidChangeEncoding(this.updateEncodingText.bind(this));
      }
      this.updateEncodingText();
    }
  }, {
    key: 'updateEncodingText',
    value: function updateEncodingText() {
      var _this2 = this;

      atom.views.updateDocument(function () {
        var editor = atom.workspace.getActiveTextEditor();
        if (editor && editor.getEncoding()) {
          var editorEncoding = editor.getEncoding().toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, '');
          var encodingLabel = _this2.encodings[editorEncoding] || { status: editorEncoding };
          _this2.encodingLink.textContent = encodingLabel.status;
          _this2.encodingLink.dataset.encoding = editorEncoding;
          _this2.element.style.display = '';

          if (_this2.tooltip) {
            _this2.tooltip.dispose();
          }
          _this2.tooltip = atom.tooltips.add(_this2.encodingLink, { title: 'This file uses ' + encodingLabel.list + ' encoding' });
        } else {
          _this2.element.style.display = 'none';
        }
      });
    }
  }]);

  return EncodingStatusView;
})();

exports['default'] = EncodingStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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