var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var fs = require('fs');
var path = require('path');

module.exports = {
  enumerate: _asyncToGenerator(function* () {
    var resourcePath = atom.getLoadSettings().resourcePath;
    if (atom.inDevMode()) {
      return [];
    }

    var paths = atom.packages.getAvailablePackagePaths();
    var countsByPackageName = new Map();
    for (var i = 0; i < paths.length; i++) {
      var packagePath = paths[i];
      var realPath = yield this.realpath(packagePath);
      if (packagePath.includes(resourcePath) || realPath === packagePath) {
        var packageName = path.basename(packagePath);
        var counts = countsByPackageName.get(packageName) || 0;
        countsByPackageName.set(packageName, counts + 1);
      }
    }

    var duplicatePackages = [];
    for (var _ref3 of countsByPackageName) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageName = _ref2[0];
      var count = _ref2[1];

      if (count > 1) {
        duplicatePackages.push(packageName);
      }
    }
    return duplicatePackages;
  }),

  realpath: function realpath(path) {
    return new Promise(function (resolve, reject) {
      fs.realpath(path, function (error, realpath) {
        if (error) {
          reject(error);
        } else {
          resolve(realpath);
        }
      });
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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