(function() {
  var CompositeDisposable, MatchManager, _,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = MatchManager = (function() {
    MatchManager.prototype.appendPair = function(pairList, arg) {
      var itemLeft, itemRight, newPair;
      itemLeft = arg[0], itemRight = arg[1];
      newPair = {};
      newPair[itemLeft] = itemRight;
      return pairList = _.extend(pairList, newPair);
    };

    MatchManager.prototype.processAutoPairs = function(autocompletePairs, pairedList, dataFun) {
      var autocompletePair, i, len, pairArray, results;
      if (autocompletePairs.length) {
        results = [];
        for (i = 0, len = autocompletePairs.length; i < len; i++) {
          autocompletePair = autocompletePairs[i];
          pairArray = autocompletePair.split('');
          results.push(this.appendPair(pairedList, dataFun(pairArray)));
        }
        return results;
      }
    };

    MatchManager.prototype.updateConfig = function() {
      var endPair, ref, results, startPair;
      this.pairedCharacters = {};
      this.pairedCharactersInverse = {};
      this.pairRegexes = {};
      this.pairsWithExtraNewline = {};
      this.processAutoPairs(this.getScopedSetting('bracket-matcher.autocompleteCharacters'), this.pairedCharacters, (function(x) {
        return [x[0], x[1]];
      }));
      this.processAutoPairs(this.getScopedSetting('bracket-matcher.autocompleteCharacters'), this.pairedCharactersInverse, (function(x) {
        return [x[1], x[0]];
      }));
      this.processAutoPairs(this.getScopedSetting('bracket-matcher.pairsWithExtraNewline'), this.pairsWithExtraNewline, (function(x) {
        return [x[0], x[1]];
      }));
      ref = this.pairedCharacters;
      results = [];
      for (startPair in ref) {
        endPair = ref[startPair];
        results.push(this.pairRegexes[startPair] = new RegExp("[" + (_.escapeRegExp(startPair + endPair)) + "]", 'g'));
      }
      return results;
    };

    MatchManager.prototype.getScopedSetting = function(key) {
      return atom.config.get(key, {
        scope: this.editor.getRootScopeDescriptor()
      });
    };

    function MatchManager(editor, editorElement) {
      this.editor = editor;
      this.destroy = bind(this.destroy, this);
      this.subscriptions = new CompositeDisposable;
      this.updateConfig();
      this.subscriptions.add(atom.config.observe('bracket-matcher.autocompleteCharacters', {
        scope: this.editor.getRootScopeDescriptor()
      }, (function(_this) {
        return function(newConfig) {
          return _this.updateConfig();
        };
      })(this)));
      this.subscriptions.add(atom.config.observe('bracket-matcher.pairsWithExtraNewline', {
        scope: this.editor.getRootScopeDescriptor()
      }, (function(_this) {
        return function(newConfig) {
          return _this.updateConfig();
        };
      })(this)));
      this.subscriptions.add(this.editor.onDidDestroy(this.destroy));
    }

    MatchManager.prototype.destroy = function() {
      return this.subscriptions.dispose();
    };

    return MatchManager;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
