(function() {
  var BracketMatcher, BracketMatcherView, MatchManager;

  MatchManager = require('./match-manager');

  BracketMatcherView = require('./bracket-matcher-view');

  BracketMatcher = require('./bracket-matcher');

  module.exports = {
    activate: function() {
      return atom.workspace.observeTextEditors(function(editor) {
        var editorElement, matchManager;
        editorElement = atom.views.getView(editor);
        matchManager = new MatchManager(editor, editorElement);
        new BracketMatcherView(editor, editorElement, matchManager);
        return new BracketMatcher(editor, editorElement, matchManager);
      });
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2JyYWNrZXQtbWF0Y2hlci9saWIvbWFpbi5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBOztFQUFBLFlBQUEsR0FBZSxPQUFBLENBQVEsaUJBQVI7O0VBQ2Ysa0JBQUEsR0FBcUIsT0FBQSxDQUFRLHdCQUFSOztFQUNyQixjQUFBLEdBQWlCLE9BQUEsQ0FBUSxtQkFBUjs7RUFFakIsTUFBTSxDQUFDLE9BQVAsR0FDRTtJQUFBLFFBQUEsRUFBVSxTQUFBO2FBQ1IsSUFBSSxDQUFDLFNBQVMsQ0FBQyxrQkFBZixDQUFrQyxTQUFDLE1BQUQ7QUFDaEMsWUFBQTtRQUFBLGFBQUEsR0FBZ0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFYLENBQW1CLE1BQW5CO1FBQ2hCLFlBQUEsR0FBbUIsSUFBQSxZQUFBLENBQWEsTUFBYixFQUFxQixhQUFyQjtRQUNmLElBQUEsa0JBQUEsQ0FBbUIsTUFBbkIsRUFBMkIsYUFBM0IsRUFBMEMsWUFBMUM7ZUFDQSxJQUFBLGNBQUEsQ0FBZSxNQUFmLEVBQXVCLGFBQXZCLEVBQXNDLFlBQXRDO01BSjRCLENBQWxDO0lBRFEsQ0FBVjs7QUFMRiIsInNvdXJjZXNDb250ZW50IjpbIk1hdGNoTWFuYWdlciA9IHJlcXVpcmUgJy4vbWF0Y2gtbWFuYWdlcidcbkJyYWNrZXRNYXRjaGVyVmlldyA9IHJlcXVpcmUgJy4vYnJhY2tldC1tYXRjaGVyLXZpZXcnXG5CcmFja2V0TWF0Y2hlciA9IHJlcXVpcmUgJy4vYnJhY2tldC1tYXRjaGVyJ1xuXG5tb2R1bGUuZXhwb3J0cyA9XG4gIGFjdGl2YXRlOiAtPlxuICAgIGF0b20ud29ya3NwYWNlLm9ic2VydmVUZXh0RWRpdG9ycyAoZWRpdG9yKSAtPlxuICAgICAgZWRpdG9yRWxlbWVudCA9IGF0b20udmlld3MuZ2V0VmlldyhlZGl0b3IpXG4gICAgICBtYXRjaE1hbmFnZXIgPSBuZXcgTWF0Y2hNYW5hZ2VyKGVkaXRvciwgZWRpdG9yRWxlbWVudClcbiAgICAgIG5ldyBCcmFja2V0TWF0Y2hlclZpZXcoZWRpdG9yLCBlZGl0b3JFbGVtZW50LCBtYXRjaE1hbmFnZXIpXG4gICAgICBuZXcgQnJhY2tldE1hdGNoZXIoZWRpdG9yLCBlZGl0b3JFbGVtZW50LCBtYXRjaE1hbmFnZXIpXG4iXX0=
