Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** @babel */

var _atom = require('atom');

var Bookmarks = (function () {
  _createClass(Bookmarks, null, [{
    key: "deserialize",
    value: function deserialize(editor, state) {
      return new Bookmarks(editor, editor.getMarkerLayer(state.markerLayerId));
    }
  }]);

  function Bookmarks(editor, markerLayer) {
    _classCallCheck(this, Bookmarks);

    this.editor = editor;
    this.markerLayer = markerLayer || this.editor.addMarkerLayer({ persistent: true });
    this.decorationLayer = this.editor.decorateMarkerLayer(this.markerLayer, { type: "line-number", "class": "bookmarked" });
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(atom.views.getView(this.editor), {
      "bookmarks:toggle-bookmark": this.toggleBookmark.bind(this),
      "bookmarks:jump-to-next-bookmark": this.jumpToNextBookmark.bind(this),
      "bookmarks:jump-to-previous-bookmark": this.jumpToPreviousBookmark.bind(this),
      "bookmarks:clear-bookmarks": this.clearBookmarks.bind(this)
    }));
    this.disposables.add(this.editor.onDidDestroy(this.destroy.bind(this)));
  }

  _createClass(Bookmarks, [{
    key: "destroy",
    value: function destroy() {
      this.deactivate();
      this.markerLayer.destroy();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      this.decorationLayer.destroy();
      this.disposables.dispose();
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return { markerLayerId: this.markerLayer.id };
    }
  }, {
    key: "toggleBookmark",
    value: function toggleBookmark() {
      var _this = this;

      for (var range of this.editor.getSelectedBufferRanges()) {
        var bookmarks = this.markerLayer.findMarkers({ intersectsRowRange: [range.start.row, range.end.row] });
        if (bookmarks && bookmarks.length > 0) {
          for (var bookmark of bookmarks) {
            bookmark.destroy();
          }
        } else {
          (function () {
            var bookmark = _this.markerLayer.markBufferRange(range, { invalidate: "surround", exclusive: true });
            _this.disposables.add(bookmark.onDidChange(function (_ref) {
              var isValid = _ref.isValid;

              if (!isValid) {
                bookmark.destroy();
              }
            }));
          })();
        }
      }
    }
  }, {
    key: "clearBookmarks",
    value: function clearBookmarks() {
      for (var bookmark of this.markerLayer.getMarkers()) {
        bookmark.destroy();
      }
    }
  }, {
    key: "jumpToNextBookmark",
    value: function jumpToNextBookmark() {
      var _this2 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this2.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this2.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          }) || markers[0];
          _this2.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this2.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "jumpToPreviousBookmark",
    value: function jumpToPreviousBookmark() {
      var _this3 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this3.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this3.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          }) || markers[0];
          _this3.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this3.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }]);

  return Bookmarks;
})();

exports["default"] = Bookmarks;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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