(function() {
  var BackgroundTipsElement, CompositeDisposable, Template, Tips, _;

  _ = require('underscore-plus');

  CompositeDisposable = require('event-kit').CompositeDisposable;

  Tips = require('./tips');

  Template = "<ul class=\"centered background-message\">\n  <li class=\"message\"></li>\n</ul>";

  module.exports = BackgroundTipsElement = (function() {
    BackgroundTipsElement.prototype.StartDelay = 1000;

    BackgroundTipsElement.prototype.DisplayDuration = 10000;

    BackgroundTipsElement.prototype.FadeDuration = 300;

    function BackgroundTipsElement() {
      var base, ref;
      this.element = document.createElement('background-tips');
      this.index = -1;
      this.disposables = new CompositeDisposable;
      this.workspaceCenter = (ref = typeof (base = atom.workspace).getCenter === "function" ? base.getCenter() : void 0) != null ? ref : atom.workspace;
      this.disposables.add(this.workspaceCenter.onDidAddPane((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.disposables.add(this.workspaceCenter.onDidDestroyPane((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.disposables.add(this.workspaceCenter.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.startTimeout = setTimeout(((function(_this) {
        return function() {
          return _this.start();
        };
      })(this)), this.StartDelay);
    }

    BackgroundTipsElement.prototype.destroy = function() {
      this.stop();
      this.disposables.dispose();
      return this.destroyed = true;
    };

    BackgroundTipsElement.prototype.attach = function() {
      var paneView, ref, ref1, top;
      this.element.innerHTML = Template;
      this.message = this.element.querySelector('.message');
      paneView = atom.views.getView(this.workspaceCenter.getActivePane());
      top = (ref = (ref1 = paneView.querySelector('.item-views')) != null ? ref1.offsetTop : void 0) != null ? ref : 0;
      this.element.style.top = top + 'px';
      return paneView.appendChild(this.element);
    };

    BackgroundTipsElement.prototype.detach = function() {
      return this.element.remove();
    };

    BackgroundTipsElement.prototype.updateVisibility = function() {
      if (this.shouldBeAttached()) {
        return this.start();
      } else {
        return this.stop();
      }
    };

    BackgroundTipsElement.prototype.shouldBeAttached = function() {
      return this.workspaceCenter.getPanes().length === 1 && (this.workspaceCenter.getActivePaneItem() == null);
    };

    BackgroundTipsElement.prototype.start = function() {
      if (!this.shouldBeAttached() || (this.interval != null)) {
        return;
      }
      this.renderTips();
      this.randomizeIndex();
      this.attach();
      this.showNextTip();
      return this.interval = setInterval(((function(_this) {
        return function() {
          return _this.showNextTip();
        };
      })(this)), this.DisplayDuration);
    };

    BackgroundTipsElement.prototype.stop = function() {
      this.element.remove();
      if (this.interval != null) {
        clearInterval(this.interval);
      }
      clearTimeout(this.startTimeout);
      clearTimeout(this.nextTipTimeout);
      return this.interval = null;
    };

    BackgroundTipsElement.prototype.randomizeIndex = function() {
      var len;
      len = Tips.length;
      return this.index = Math.round(Math.random() * len) % len;
    };

    BackgroundTipsElement.prototype.showNextTip = function() {
      this.index = ++this.index % Tips.length;
      this.message.classList.remove('fade-in');
      return this.nextTipTimeout = setTimeout((function(_this) {
        return function() {
          _this.message.innerHTML = Tips[_this.index];
          return _this.message.classList.add('fade-in');
        };
      })(this), this.FadeDuration);
    };

    BackgroundTipsElement.prototype.renderTips = function() {
      var i, j, len1, tip;
      if (this.tipsRendered) {
        return;
      }
      for (i = j = 0, len1 = Tips.length; j < len1; i = ++j) {
        tip = Tips[i];
        Tips[i] = this.renderTip(tip);
      }
      return this.tipsRendered = true;
    };

    BackgroundTipsElement.prototype.renderTip = function(str) {
      str = str.replace(/\{(.+)\}/g, (function(_this) {
        return function(match, command) {
          var binding, bindings, j, keystrokeLabel, len1, scope, scopeAndCommand;
          scopeAndCommand = command.split('>');
          if (scopeAndCommand.length > 1) {
            scope = scopeAndCommand[0], command = scopeAndCommand[1];
          }
          bindings = atom.keymaps.findKeyBindings({
            command: command.trim()
          });
          if (scope) {
            for (j = 0, len1 = bindings.length; j < len1; j++) {
              binding = bindings[j];
              if (binding.selector === scope) {
                break;
              }
            }
          } else {
            binding = _this.getKeyBindingForCurrentPlatform(bindings);
          }
          if (binding != null ? binding.keystrokes : void 0) {
            keystrokeLabel = _.humanizeKeystroke(binding.keystrokes).replace(/\s+/g, '&nbsp;');
            return "<span class=\"keystroke\">" + keystrokeLabel + "</span>";
          } else {
            return command;
          }
        };
      })(this));
      return str;
    };

    BackgroundTipsElement.prototype.getKeyBindingForCurrentPlatform = function(bindings) {
      var binding, j, len1;
      if (!(bindings != null ? bindings.length : void 0)) {
        return;
      }
      for (j = 0, len1 = bindings.length; j < len1; j++) {
        binding = bindings[j];
        if (binding.selector.indexOf(process.platform) !== -1) {
          return binding;
        }
      }
      return bindings[0];
    };

    return BackgroundTipsElement;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
