(function() {
  module.exports = {
    provider: null,
    activate: function() {},
    deactivate: function() {
      return this.provider = null;
    },
    provide: function() {
      var SnippetsProvider;
      if (this.provider == null) {
        SnippetsProvider = require('./snippets-provider');
        this.provider = new SnippetsProvider();
        if (this.snippets != null) {
          this.provider.setSnippetsSource(this.snippets);
        }
      }
      return this.provider;
    },
    consumeSnippets: function(snippets) {
      var ref;
      this.snippets = snippets;
      return (ref = this.provider) != null ? ref.setSnippetsSource(this.snippets) : void 0;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2F1dG9jb21wbGV0ZS1zbmlwcGV0cy9saWIvYXV0b2NvbXBsZXRlLXNuaXBwZXRzLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUFBLE1BQU0sQ0FBQyxPQUFQLEdBQ0U7SUFBQSxRQUFBLEVBQVUsSUFBVjtJQUVBLFFBQUEsRUFBVSxTQUFBLEdBQUEsQ0FGVjtJQUlBLFVBQUEsRUFBWSxTQUFBO2FBQ1YsSUFBQyxDQUFBLFFBQUQsR0FBWTtJQURGLENBSlo7SUFPQSxPQUFBLEVBQVMsU0FBQTtBQUNQLFVBQUE7TUFBQSxJQUFPLHFCQUFQO1FBQ0UsZ0JBQUEsR0FBbUIsT0FBQSxDQUFRLHFCQUFSO1FBQ25CLElBQUMsQ0FBQSxRQUFELEdBQWdCLElBQUEsZ0JBQUEsQ0FBQTtRQUNoQixJQUEwQyxxQkFBMUM7VUFBQSxJQUFDLENBQUEsUUFBUSxDQUFDLGlCQUFWLENBQTRCLElBQUMsQ0FBQSxRQUE3QixFQUFBO1NBSEY7O2FBS0EsSUFBQyxDQUFBO0lBTk0sQ0FQVDtJQWVBLGVBQUEsRUFBaUIsU0FBQyxRQUFEO0FBQ2YsVUFBQTtNQURnQixJQUFDLENBQUEsV0FBRDtnREFDUCxDQUFFLGlCQUFYLENBQTZCLElBQUMsQ0FBQSxRQUE5QjtJQURlLENBZmpCOztBQURGIiwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPVxuICBwcm92aWRlcjogbnVsbFxuXG4gIGFjdGl2YXRlOiAtPlxuXG4gIGRlYWN0aXZhdGU6IC0+XG4gICAgQHByb3ZpZGVyID0gbnVsbFxuXG4gIHByb3ZpZGU6IC0+XG4gICAgdW5sZXNzIEBwcm92aWRlcj9cbiAgICAgIFNuaXBwZXRzUHJvdmlkZXIgPSByZXF1aXJlKCcuL3NuaXBwZXRzLXByb3ZpZGVyJylcbiAgICAgIEBwcm92aWRlciA9IG5ldyBTbmlwcGV0c1Byb3ZpZGVyKClcbiAgICAgIEBwcm92aWRlci5zZXRTbmlwcGV0c1NvdXJjZShAc25pcHBldHMpIGlmIEBzbmlwcGV0cz9cblxuICAgIEBwcm92aWRlclxuXG4gIGNvbnN1bWVTbmlwcGV0czogKEBzbmlwcGV0cykgLT5cbiAgICBAcHJvdmlkZXI/LnNldFNuaXBwZXRzU291cmNlKEBzbmlwcGV0cylcbiJdfQ==
