(function() {
  var AttributesURL, TagsURL, attributesPromise, fetchGlobalAttributeDescriptions, fetchTagDescriptions, fs, globalAttributeDescriptionsPromise, path, request, tagDescriptionsPromise, tagsPromise;

  path = require('path');

  fs = require('fs');

  request = require('request');

  fetchTagDescriptions = require('./fetch-tag-docs');

  fetchGlobalAttributeDescriptions = require('./fetch-global-attribute-docs');

  TagsURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlTags.json';

  AttributesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/HTMLCodeHints/HtmlAttributes.json';

  tagsPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: TagsURL
    }, function(error, response, tags) {
      var options, ref, tag;
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for HtmlTags.json failed: " + response.statusCode);
        resolve(null);
      }
      for (tag in tags) {
        options = tags[tag];
        if (((ref = options.attributes) != null ? ref.length : void 0) === 0) {
          delete options.attributes;
        }
      }
      return resolve(tags);
    });
  });

  tagDescriptionsPromise = fetchTagDescriptions();

  attributesPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: AttributesURL
    }, function(error, response, attributes) {
      var attribute, options, ref;
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request for HtmlAttributes.json failed: " + response.statusCode);
        resolve(null);
      }
      for (attribute in attributes) {
        options = attributes[attribute];
        if (((ref = options.attribOption) != null ? ref.length : void 0) === 0) {
          delete options.attribOption;
        }
      }
      return resolve(attributes);
    });
  });

  globalAttributeDescriptionsPromise = fetchGlobalAttributeDescriptions();

  Promise.all([tagsPromise, tagDescriptionsPromise, attributesPromise, globalAttributeDescriptionsPromise]).then(function(values) {
    var attribute, attributeDescriptions, attributes, completions, options, tag, tagDescriptions, tags;
    tags = values[0];
    tagDescriptions = values[1];
    attributes = values[2];
    attributeDescriptions = values[3];
    for (tag in tags) {
      tags[tag].description = tagDescriptions[tag];
    }
    for (attribute in attributes) {
      options = attributes[attribute];
      if (options.global) {
        attributes[attribute].description = attributeDescriptions[attribute];
      }
    }
    completions = {
      tags: tags,
      attributes: attributes
    };
    return fs.writeFileSync(path.join(__dirname, 'completions.json'), (JSON.stringify(completions, null, '  ')) + "\n");
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
