Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _temp = require('temp');

var _temp2 = _interopRequireDefault(_temp);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _fileIcons = require('./file-icons');

var _fileIcons2 = _interopRequireDefault(_fileIcons);

var FileView = (function () {
  function FileView(parentView, indexInParentView, archivePath, entry) {
    var _name$classList,
        _this = this;

    _classCallCheck(this, FileView);

    this.disposables = new _atom.CompositeDisposable();
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.archivePath = archivePath;
    this.entry = entry;
    var typeClass = _fileIcons2['default'].getService().iconClassForPath(this.entry.path, 'archive-view') || [];
    if (!Array.isArray(typeClass)) {
      if (typeClass) {
        typeClass = typeClass.toString().split(/\s+/g);
      }
    }

    this.element = document.createElement('li');
    this.element.classList.add('list-item', 'entry');
    this.element.tabIndex = -1;

    this.name = document.createElement('span');
    (_name$classList = this.name.classList).add.apply(_name$classList, ['file', 'icon'].concat(_toConsumableArray(typeClass)));
    this.name.textContent = this.entry.getName();
    this.element.appendChild(this.name);

    var clickHandler = function clickHandler() {
      _this.select();
      _this.openFile();
    };
    this.element.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    }));

    this.disposables.add(atom.commands.add(this.element, {
      'core:confirm': function coreConfirm() {
        if (_this.isSelected()) {
          _this.openFile();
        }
      },

      'core:move-down': function coreMoveDown() {
        if (_this.isSelected()) {
          _this.parentView.selectFileAfterIndex(_this.indexInParentView);
        }
      },

      'core:move-up': function coreMoveUp() {
        if (_this.isSelected()) {
          _this.parentView.selectFileBeforeIndex(_this.indexInParentView);
        }
      }
    }));
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'isSelected',
    value: function isSelected() {
      return this.element.classList.contains('selected');
    }
  }, {
    key: 'logError',
    value: function logError(message, error) {
      console.error(message, error.stack != null ? error.stack : error);
    }
  }, {
    key: 'openFile',
    value: function openFile() {
      var _this2 = this;

      _lsArchive2['default'].readFile(this.archivePath, this.entry.getPath(), function (error, contents) {
        if (error != null) {
          _this2.logError('Error reading: ' + _this2.entry.getPath() + ' from ' + _this2.archivePath, error);
        } else {
          _temp2['default'].mkdir('atom-', function (error, tempDirPath) {
            if (error != null) {
              _this2.logError('Error creating temp directory: ' + tempDirPath, error);
            } else {
              (function () {
                var tempFilePath = _path2['default'].join(tempDirPath, _path2['default'].basename(_this2.archivePath), _this2.entry.getName());
                _fsPlus2['default'].writeFile(tempFilePath, contents, function (error) {
                  if (error != null) {
                    return _this2.logError('Error writing to ' + tempFilePath, error);
                  } else {
                    return atom.workspace.open(tempFilePath);
                  }
                });
              })();
            }
          });
        }
      });
    }
  }, {
    key: 'select',
    value: function select() {
      for (var selected of this.element.closest('.archive-editor').querySelectorAll('.selected')) {
        selected.classList.remove('selected');
      }
      this.element.classList.add('selected');
      this.element.focus();
    }
  }]);

  return FileView;
})();

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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