(function() {
  var ArchiveEditor, ArchiveEditorView, Disposable, Emitter, File, FileIcons, Serializable, fs, isPathSupported, path, ref,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Serializable = require('serializable');

  ref = require('atom'), Disposable = ref.Disposable, Emitter = ref.Emitter, File = ref.File;

  FileIcons = require('./file-icons');

  ArchiveEditorView = require('./archive-editor-view');

  isPathSupported = function(filePath) {
    switch (path.extname(filePath)) {
      case '.egg':
      case '.epub':
      case '.jar':
      case '.love':
      case '.nupkg':
      case '.tar':
      case '.tgz':
      case '.war':
      case '.whl':
      case '.xpi':
      case '.zip':
        return true;
      case '.gz':
        return path.extname(path.basename(filePath, '.gz')) === '.tar';
      default:
        return false;
    }
  };

  module.exports = ArchiveEditor = (function(superClass) {
    extend(ArchiveEditor, superClass);

    ArchiveEditor.activate = function() {
      return atom.workspace.addOpener(function(filePath) {
        if (filePath == null) {
          filePath = '';
        }
        if (isPathSupported(filePath) && fs.isFileSync(filePath)) {
          return new ArchiveEditor({
            path: filePath
          });
        }
      });
    };

    function ArchiveEditor(arg) {
      var path;
      path = arg.path;
      this.emitter = new Emitter();
      this.file = new File(path);
      this.view = new ArchiveEditorView(this);
      this.element = this.view.element;
    }

    ArchiveEditor.prototype.serializeParams = function() {
      return {
        path: this.getPath()
      };
    };

    ArchiveEditor.prototype.deserializeParams = function(params) {
      if (params == null) {
        params = {};
      }
      if (fs.isFileSync(params.path)) {
        return params;
      } else {
        return console.warn("Could not build archive editor for path '" + params.path + "' because that file no longer exists");
      }
    };

    ArchiveEditor.consumeFileIcons = function(service) {
      FileIcons.setService(service);
      return new Disposable(function() {
        return FileIcons.resetService();
      });
    };

    ArchiveEditor.prototype.getPath = function() {
      return this.file.getPath();
    };

    ArchiveEditor.prototype.destroy = function() {
      this.view.destroy();
      return this.emitter.emit('did-destroy');
    };

    ArchiveEditor.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    ArchiveEditor.prototype.getTitle = function() {
      if (this.getPath() != null) {
        return path.basename(this.getPath());
      } else {
        return 'untitled';
      }
    };

    ArchiveEditor.prototype.getURI = function() {
      return this.getPath();
    };

    ArchiveEditor.prototype.isEqual = function(other) {
      return other instanceof ArchiveEditor && this.getURI() === other.getURI();
    };

    return ArchiveEditor;

  })(Serializable);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
