Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var Unsupported = 'unsupported';
var Idle = 'idle';
var CheckingForUpdate = 'checking';
var DownloadingUpdate = 'downloading';
var UpdateAvailableToInstall = 'update-available';
var UpToDate = 'no-update-available';
var ErrorState = 'error';

var UpdateManager = (function () {
  function UpdateManager() {
    _classCallCheck(this, UpdateManager);

    this.emitter = new _atom.Emitter();
    this.currentVersion = atom.getVersion();
    this.availableVersion = atom.getVersion();
    this.resetState();
    this.listenForAtomEvents();
  }

  _createClass(UpdateManager, [{
    key: 'listenForAtomEvents',
    value: function listenForAtomEvents() {
      var _this = this;

      this.subscriptions = new _atom.CompositeDisposable();

      this.subscriptions.add(atom.autoUpdater.onDidBeginCheckingForUpdate(function () {
        _this.setState(CheckingForUpdate);
      }), atom.autoUpdater.onDidBeginDownloadingUpdate(function () {
        _this.setState(DownloadingUpdate);
      }), atom.autoUpdater.onDidCompleteDownloadingUpdate(function (_ref) {
        var releaseVersion = _ref.releaseVersion;

        _this.setAvailableVersion(releaseVersion);
      }), atom.autoUpdater.onUpdateNotAvailable(function () {
        _this.setState(UpToDate);
      }), atom.autoUpdater.onUpdateError(function () {
        _this.setState(ErrorState);
      }), atom.config.observe('core.automaticallyUpdate', function (value) {
        _this.autoUpdatesEnabled = value;
        _this.emitDidChange();
      }));

      // TODO: When https://github.com/atom/electron/issues/4587 is closed we can add this support.
      // atom.autoUpdater.onUpdateAvailable =>
      //   @find('.about-updates-item').removeClass('is-shown')
      //   @updateAvailable.addClass('is-shown')
    }
  }, {
    key: 'dispose',
    value: function dispose() {
      this.subscriptions.dispose();
    }
  }, {
    key: 'onDidChange',
    value: function onDidChange(callback) {
      return this.emitter.on('did-change', callback);
    }
  }, {
    key: 'emitDidChange',
    value: function emitDidChange() {
      this.emitter.emit('did-change');
    }
  }, {
    key: 'getAutoUpdatesEnabled',
    value: function getAutoUpdatesEnabled() {
      return this.autoUpdatesEnabled && this.state !== UpdateManager.State.Unsupported;
    }
  }, {
    key: 'setAutoUpdatesEnabled',
    value: function setAutoUpdatesEnabled(enabled) {
      return atom.config.set('core.automaticallyUpdate', enabled);
    }
  }, {
    key: 'getErrorMessage',
    value: function getErrorMessage() {
      return atom.autoUpdater.getErrorMessage();
    }
  }, {
    key: 'getState',
    value: function getState() {
      return this.state;
    }
  }, {
    key: 'setState',
    value: function setState(state) {
      this.state = state;
      this.emitDidChange();
    }
  }, {
    key: 'resetState',
    value: function resetState() {
      this.state = atom.autoUpdater.platformSupportsUpdates() ? atom.autoUpdater.getState() : Unsupported;
      this.emitDidChange();
    }
  }, {
    key: 'getAvailableVersion',
    value: function getAvailableVersion() {
      return this.availableVersion;
    }
  }, {
    key: 'setAvailableVersion',
    value: function setAvailableVersion(version) {
      this.availableVersion = version;

      if (this.availableVersion !== this.currentVersion) {
        this.state = UpdateAvailableToInstall;
      } else {
        this.state = UpToDate;
      }

      this.emitDidChange();
    }
  }, {
    key: 'checkForUpdate',
    value: function checkForUpdate() {
      atom.autoUpdater.checkForUpdate();
    }
  }, {
    key: 'restartAndInstallUpdate',
    value: function restartAndInstallUpdate() {
      atom.autoUpdater.restartAndInstallUpdate();
    }
  }, {
    key: 'getReleaseNotesURLForCurrentVersion',
    value: function getReleaseNotesURLForCurrentVersion() {
      return this.getReleaseNotesURLForVersion(this.currentVersion);
    }
  }, {
    key: 'getReleaseNotesURLForAvailableVersion',
    value: function getReleaseNotesURLForAvailableVersion() {
      return this.getReleaseNotesURLForVersion(this.availableVersion);
    }
  }, {
    key: 'getReleaseNotesURLForVersion',
    value: function getReleaseNotesURLForVersion(appVersion) {
      // Dev versions will not have a releases page
      if (appVersion.indexOf('dev') > -1) {
        return 'https://atom.io/releases';
      }

      if (!appVersion.startsWith('v')) {
        appVersion = 'v' + appVersion;
      }
      return 'https://github.com/atom/atom/releases/tag/' + appVersion;
    }
  }]);

  return UpdateManager;
})();

exports['default'] = UpdateManager;

UpdateManager.State = {
  Unsupported: Unsupported,
  Idle: Idle,
  CheckingForUpdate: CheckingForUpdate,
  DownloadingUpdate: DownloadingUpdate,
  UpdateAvailableToInstall: UpdateAvailableToInstall,
  UpToDate: UpToDate,
  Error: ErrorState
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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