/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeInfo;
import ancestris.modules.releve.merge.MergeTableAction;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.NbBundle;

abstract class ProposalRule {
    protected String m_label;
    protected boolean m_merge;
    protected boolean m_merge_initial;
    protected CompareResult m_compareResult;
    private final ArrayList<ProposalRule> m_subRules = new ArrayList();
    protected boolean m_display;

    ProposalRule() {
    }

    final ProposalRule addSubRule(ProposalRule rule, boolean display) {
        rule.m_display = display;
        return rule;
    }

    public abstract ProposalRule getSuperRule();

    public final List<ProposalRule> getSubRules() {
        return this.m_subRules;
    }

    public final ProposalRule findSubRule(Class<?> ruleClass) {
        return this.findSubRule(this, ruleClass);
    }

    private ProposalRule findSubRule(ProposalRule rule, Class<?> ruleClass) {
        ProposalRule result = null;
        for (ProposalRule subRule : rule.getSubRules()) {
            if (ruleClass.isInstance(subRule)) {
                return subRule;
            }
            result = this.findSubRule(subRule, ruleClass);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public String toString() {
        return this.m_label + " " + this.getDisplayRecord() + " " + this.getDisplayEntity();
    }

    public Object getDisplayRecord() {
        return null;
    }

    public void onRecordChanged(Object o) {
    }

    public Object getDisplayEntity() {
        return null;
    }

    public void onSelectedEntityChanged(Object o) {
    }

    public MergeTableAction getDisplayAction() {
        return null;
    }

    public boolean equalAs(ProposalRule that) {
        int thisSize = this.getSubRules().size();
        int thatSize = that.getSubRules().size();
        for (int i = 0; i < thisSize && i < thatSize; ++i) {
            ProposalRule thatSub;
            ProposalRule thisSub = this.getSubRules().get(i);
            if (thisSub.equalAs(thatSub = that.getSubRules().get(i))) continue;
            return false;
        }
        return true;
    }

    public abstract void copyRecordToEntity() throws Exception;

    public void copyRecordToEntitySubRules() throws Exception {
        for (ProposalRule rule : this.getSubRules()) {
            rule.copyRecordToEntity();
        }
    }

    public void getInfo(MergeInfo info) {
        for (ProposalRule rule : this.getSubRules()) {
            rule.getInfo(info);
        }
    }

    public boolean getMerge() {
        return this.m_merge;
    }

    public boolean isChecked() {
        boolean checked = this.m_merge;
        for (ProposalRule rule : this.getSubRules()) {
            checked |= rule.isChecked();
        }
        return checked;
    }

    public void setMerge(boolean merge) {
        this.m_merge = merge;
    }

    public boolean isMergeChanged() {
        return this.m_merge != this.m_merge_initial;
    }

    public CompareResult getCompareResult() {
        return this.m_compareResult;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getLabelResourceName() {
        return "";
    }

    public void restoreInitialMerge() {
        this.m_merge = this.m_merge_initial;
    }

    protected static String getRuleLabel(String resourceName) {
        if (resourceName.isEmpty()) {
            return "";
        }
        return NbBundle.getMessage(ProposalRule.class, (String)resourceName);
    }

    protected static enum CompareResult {
        EQUAL,
        COMPATIBLE,
        CONFLICT,
        MANDATORY,
        NOT_APPLICABLE;

    }
}

