/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public abstract class DNDAction
extends AbstractAction {
    private TopComponent tc = null;
    private Gedcom gedcom = null;
    private String name = "";
    private Entity importedEntity = null;
    private Entity newEntity = null;
    private String msgSuccess = "DND_SuccessMessage";
    private String msgFailure = "DND_ErrorMessage";

    public DNDAction(boolean isError, String name, Icon icon) {
        super(name, icon);
        this.setEnabled(!isError);
        this.name = name;
    }

    public void init(TopComponent tc, Entity importedEntity, Entity targetEntity) {
        this.tc = tc;
        this.gedcom = targetEntity.getGedcom();
        this.importedEntity = importedEntity;
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        try {
            this.gedcom.doUnitOfWork(new UnitOfWork(){

                @Override
                public void perform(Gedcom gedcom) throws GedcomException {
                    DNDAction.this.newEntity = DNDAction.this.dropActionPerformed(e);
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Toolkit.getDefaultToolkit().beep();
        if (this.newEntity != null) {
            String msg = NbBundle.getMessage(DNDAction.class, (String)this.msgSuccess, (Object)this.name);
            StatusDisplayer.getDefault().setStatusText(msg);
            SelectionDispatcher.fireSelection(new Context(this.newEntity));
            if (this.tc != null) {
                this.tc.requestActive();
            }
        } else {
            String msg = NbBundle.getMessage(DNDAction.class, (String)this.msgFailure, (Object)this.name);
            StatusDisplayer.getDefault().setStatusText(msg);
            Toolkit.getDefaultToolkit().beep();
            DialogManager.create(NbBundle.getMessage(DNDAction.class, (String)"DND_Title"), msg).setMessageType(0).setOptionType(10).show();
        }
    }

    public abstract Entity dropActionPerformed(ActionEvent var1);
}

