/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.ExplorerNode;
import ancestris.explorer.Filters;
import ancestris.explorer.GedcomExplorerSettings;
import ancestris.explorer.GedcomFileChildren;
import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Context;
import genj.gedcom.Property;
import genj.io.Filter;
import genj.view.SettingsAction;
import genj.view.ViewContext;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class GedcomExplorerTopComponent
extends TopComponent
implements ExplorerManager.Provider,
LookupListener {
    private static GedcomExplorerTopComponent instance;
    static final String ICON_PATH = "ancestris/explorer/explorer.png";
    private static final String PREFERRED_ID = "GedcomExplorerTopComponent";
    private final transient ExplorerManager explorerManager = new ExplorerManager();
    private final boolean forceClose = false;
    protected Lookup.Result<Property> lookupResultProperty;
    private Context memorizedSelectedContext = null;
    private final DefaultComboBoxModel<Filter> displayTypeModel = new DefaultComboBoxModel<Filter>(Filters.get());
    private Filter currentFilter = null;
    private JComboBox<Filter> displayType;
    private JScrollPane gedcomsPane;
    private JButton jButton1;

    public GedcomExplorerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"CTL_GedcomExplorerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"HINT_GedcomExplorerTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()));
        ((BeanTreeView)this.gedcomsPane).setRootVisible(false);
        ((BeanTreeView)this.gedcomsPane).setSelectionMode(1);
        this.displayType.setSelectedItem(this.displayTypeModel.getElementAt(0));
    }

    private void initComponents() {
        this.displayType = new JComboBox();
        this.gedcomsPane = new BeanTreeView();
        this.jButton1 = new JButton((Action)((Object)new Settings()));
        this.displayType.setModel(this.displayTypeModel);
        this.displayType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomExplorerTopComponent.this.displayTypeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"GedcomExplorerTopComponent.jButton1.text"));
        this.jButton1.setPreferredSize(new Dimension(26, 28));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gedcomsPane, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.displayType, 0, -1, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jButton1, -2, -1, -2).addGap(3, 3, 3)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton1, -2, -1, -2).addComponent(this.displayType, -2, -1, -2)).addComponent(this.gedcomsPane, -1, 472, Short.MAX_VALUE)));
    }

    private void displayTypeActionPerformed(ActionEvent evt) {
        Filter newFilter = (Filter)this.displayTypeModel.getSelectedItem();
        if (newFilter != this.currentFilter) {
            this.currentFilter = newFilter;
            this.buildTree();
        }
    }

    public static synchronized GedcomExplorerTopComponent getDefault() {
        if (instance == null) {
            instance = new GedcomExplorerTopComponent();
        }
        return instance;
    }

    public static synchronized GedcomExplorerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(GedcomExplorerTopComponent.class.getName()).warning("Cannot find GedcomExplorerTopComponent component. It will not be located properly in the window system.");
            return GedcomExplorerTopComponent.getDefault();
        }
        if (win instanceof GedcomExplorerTopComponent) {
            GedcomExplorerTopComponent gedcomExplorerTopComponent = (GedcomExplorerTopComponent)win;
            return gedcomExplorerTopComponent;
        }
        Logger.getLogger(GedcomExplorerTopComponent.class.getName()).warning("There seem to be multiple components with the 'GedcomExplorerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return GedcomExplorerTopComponent.getDefault();
    }

    public boolean canClose() {
        return false;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void open() {
        Mode m = WindowManager.getDefault().findMode("leftSlidingSide");
        if (m != null) {
            m.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentOpened() {
        if (this.lookupResultProperty == null) {
            this.lookupResultProperty = Utilities.actionsGlobalContext().lookupResult(Property.class);
        }
        this.lookupResultProperty.addLookupListener((LookupListener)this);
    }

    protected void componentClosed() {
        this.lookupResultProperty.removeLookupListener((LookupListener)this);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void buildTree() {
        this.explorerManager.setRootContext((Node)new AbstractNode((Children)new GedcomFileChildren()));
    }

    public ViewContext getContext() {
        Node[] nodes = this.getActivatedNodes();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        Node contextnode = nodes[0];
        if (contextnode instanceof ExplorerNode) {
            ExplorerNode explorerNode = (ExplorerNode)contextnode;
            return new ViewContext(explorerNode.getContext());
        }
        return null;
    }

    public void expandCollapse(boolean expand) {
        Node node = this.explorerManager.getRootContext();
        if ((node = node.getChildren().getNodeAt(0)) == null) {
            return;
        }
        if (expand) {
            ((BeanTreeView)this.gedcomsPane).expandNode(node);
        } else {
            ((BeanTreeView)this.gedcomsPane).collapseNode(node);
        }
    }

    public void setDefaultGedcom() {
        ViewContext selectedContext = this.getContext();
        if (selectedContext != null) {
            GedcomDirectory.getDefault().setDefaultContext((Context)selectedContext);
        }
    }

    public void resultChanged(LookupEvent ev) {
        ViewContext selectedContext = this.getContext();
        if (!(selectedContext == null || this.memorizedSelectedContext != null && selectedContext.equals((Object)this.memorizedSelectedContext))) {
            this.memorizedSelectedContext = selectedContext;
            for (Context ctx : GedcomDirectory.getDefault().getContexts()) {
                if (ctx.getGedcom() != this.getContext().getGedcom()) continue;
                GedcomDirectory.getDefault().setDefaultContext(ctx);
                break;
            }
        }
    }

    protected Filter getFilter() {
        return this.currentFilter;
    }

    protected class Settings
    extends SettingsAction {
        private boolean updateTree = false;

        protected Settings() {
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (this.updateTree && GedcomExplorerTopComponent.this.currentFilter.getSelectionName().equals("ChangedLast")) {
                GedcomExplorerTopComponent.this.buildTree();
            }
        }

        protected GedcomExplorerSettings getEditor() {
            this.updateTree = false;
            return new GedcomExplorerSettings(this);
        }

        protected void setUpdateTree(boolean set) {
            this.updateTree = set;
        }
    }
}

