/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking;

import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import swingx.docking.Bridge;
import swingx.docking.Dock;
import swingx.docking.Dockable;
import swingx.docking.Docking;
import swingx.docking.DockingPane;
import swingx.docking.Slice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Persister {
    protected DockingPane dockingPane;

    public Persister(DockingPane dockingPane) {
        this.dockingPane = dockingPane;
    }

    public void load() throws IOException {
        this.dockingPane.setDockings(this.loadDockings());
    }

    protected abstract List<Docking> loadDockings() throws IOException;

    public void save() throws IOException {
        this.saveDockings(this.dockingPane.getDockings());
    }

    protected abstract void saveDockings(List<Docking> var1) throws IOException;

    protected final Dockable resolveDockable(Object key) {
        return this.dockingPane.createDockable(key);
    }

    protected final JComponent resolveComponent(Object key) {
        return this.dockingPane.createComponent(key);
    }

    protected final Docking createDocking() {
        return this.dockingPane.createDocking();
    }

    protected final Slice createSlice() {
        return this.dockingPane.createSlice();
    }

    protected final Bridge createBridge() {
        return this.dockingPane.createBridge();
    }

    protected final Dock createDock() {
        return this.dockingPane.createDock();
    }
}

