/*
 * Decompiled with CFR 0.152.
 */
package swingx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;

public class Marker {
    private JComponent component;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private BasicStroke stroke;
    private Color foreground;
    private Color background;

    public Marker(JComponent component, Color background, Color foreground, BasicStroke stroke, int x1, int y1, int x2, int y2) {
        this.component = component;
        this.background = background;
        this.foreground = foreground;
        this.stroke = stroke;
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.mark();
    }

    public JComponent getComponent() {
        return this.component;
    }

    public boolean contains(int x, int y) {
        return this.contains(x, y, 0, 0);
    }

    public boolean contains(int x, int y, int width, int height) {
        return this.x1 < x && this.x2 > x + width && this.y1 < y && this.y2 > y + height;
    }

    public void release() {
        this.checkNotReleased();
        this.mark();
        this.component = null;
    }

    protected void mark() {
        this.component.repaint(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
    }

    public void paint(Graphics2D g) {
        this.checkNotReleased();
        int thick = Math.round(this.stroke.getLineWidth());
        int x = this.x1 + thick / 2;
        int width = this.x2 - this.x1 - Math.max(1, thick);
        int y = this.y1 + thick / 2;
        int height = this.y2 - this.y1 - Math.max(1, thick);
        if (this.background != null) {
            g.setColor(this.background);
            g.fillRect(x, y, width, height);
        }
        Stroke originalStroke = g.getStroke();
        g.setStroke(this.stroke);
        g.setColor(this.foreground);
        g.drawRect(x, y, width, height);
        g.setStroke(originalStroke);
    }

    protected void checkNotReleased() {
        if (this.component == null) {
            throw new IllegalStateException("already released");
        }
    }

    public static Marker create(JComponent component, boolean xor, Color background, Color foreground, BasicStroke stroke, Rectangle rect) {
        return Marker.create(component, xor, background, foreground, stroke, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
    }

    public static Marker create(JComponent component, boolean xor, Color background, Color foreground, BasicStroke stroke, int x1, int y1, int x2, int y2) {
        if (xor) {
            return new XORMarker(component, background, foreground, stroke, x1, y1, x2, y2);
        }
        return new Marker(component, background, foreground, stroke, x1, y1, x2, y2);
    }

    private static class XORMarker
    extends Marker {
        public XORMarker(JComponent component, Color background, Color foreground, BasicStroke stroke, int x1, int y1, int x2, int y2) {
            super(component, background, foreground, stroke, x1, y1, x2, y2);
        }

        protected void mark() {
            this.checkNotReleased();
            Graphics2D g = (Graphics2D)this.getComponent().getGraphics();
            if (g != null) {
                this.paint(g);
                g.dispose();
            }
        }

        public void paint(Graphics2D g) {
            g.setXORMode(Color.white);
            super.paint(g);
            g.setPaintMode();
        }
    }
}

